/*
Copyright (c) 2009, ImageShack Corp.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the ImageShack nor the names of its contributors may be
  used to endorse or promote products derived from this software without
  specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


#ifndef PROGRESSWIDGET_H
#define PROGRESSWIDGET_H

#include <QtGui/QStackedWidget>
#include "medialistmodel.h"

namespace Ui {
    class ProgressWidget;
}

class ProgressWidget : public QStackedWidget {
    Q_OBJECT
    Q_DISABLE_COPY(ProgressWidget)
public:
    ProgressWidget(QWidget *parent = 0);
    virtual ~ProgressWidget();
    void setProgress(int, int);
    void setMediaLoadProgress(int, int);
    void setUploadEnabled(bool);
    void setCurrentIndex(int);
    void setMedias(MediaListModel*);

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::ProgressWidget *m_ui;
    bool paused;
    MediaListModel *medias;

private slots:
    void uploadClicked();
    void cancelClicked();
    void updateETA(int);
    void pauseClicked();

signals:
    void cancel();
    void upload();
    void pause(bool);
};

#endif // PROGRESSWIDGET_H
