/***************************************************************************
                          mateditor.h  -  description
                             -------------------
    begin                : Tue Jan 18 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MATEDITOR_H
#define MATEDITOR_H

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qslider.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qlistbox.h>
//Generated area. DO NOT EDIT!!!(end)

#include <qgl.h>
#include <qdialog.h>

//STL includes
#include <vector>
#include <algorithm>

class GLPreview;
class TextureMaterial;


/** This is the MatEditor dialog.  It allows the user to set up
  * materials for use in modelling.  Materials are a combination of texture
  * maps and colors.  The user can set up all material parameters allowed by
  * OpenGL and and load texturemaps.
  *@author Jon Anderson
  */

class MatEditor : public QDialog  {
   Q_OBJECT
public: 
	MatEditor(QWidget *parent=0, const char *name=0);
	~MatEditor();
	
	void init();
	
	
	int addMaterial(TextureMaterial *);
	int getMaterialIndex(TextureMaterial *);
	vector<TextureMaterial *> * getMaterials(){return &materials;};
	void show();
	void refresh();
	
	TextureMaterial * createMaterial(char *filename);
	
protected slots:
	void slotChangeAmbient();
	
	void slotChangeAlpha();
	void slotChangeShininess();
	
	void slotChangeDiffuse();
	void slotChangeTexture();
	void slotChangeSpecular();
	void slotChangeEmission();
	void slotChangePreviewType(int);
	void slotNewMaterial();
	void slotSelected(int);
	void slotApplyMaterial();
	void slotCopyMaterial();
	void slotDeleteMaterial();
	void slotLoad();
	void slotSave();
	
protected: 
	void initDialog();
	//Generated area. DO NOT EDIT!!!(begin)
	QGroupBox *grpMaterial;
	QLabel *lblName;
	QPushButton *btnNew;
	QPushButton *btnDelete;
	QPushButton *btnCopy;
	QGroupBox *grpBlend;
	QComboBox *chBlend;
	QGroupBox *grpPreview;
	QComboBox *chType;
	QWidget *glPreview;
	QGroupBox *grpColors;
	QLabel *lblSpecular;
	QPushButton *btnSpecular;
	QLabel *lblAmbient;
	QPushButton *btnAmbient;
	QLabel *lblDiffuse;
	QPushButton *btnDiffuse;
	QLabel *lblEmission;
	QPushButton *btnEmission;
	QLabel *lblShininess;
	QSlider *sldrShininess;
	QLabel *lblAlpha;
	QSlider *sldrAlpha;
	QGroupBox *grpTexture;
	QCheckBox *chkTexture;
	QPushButton *btnBrowse;
	QLineEdit *fldTextureName;
	QPushButton *btnApply;
	QPushButton *btnClose;
	QPushButton *btnSave;
	QListBox *tblPreview;
	QLineEdit *fldName;
	QPushButton *btnLoad;
	//Generated area. DO NOT EDIT!!!(end)

	GLPreview *prvw;
	vector<TextureMaterial *> materials;
	TextureMaterial *currentMat;
	int currentIndex;
	int insertIndex;
	static MatEditor *mateditor;
	
private: 
};

#endif
