/***************************************************************************
                         controller.cpp  -  description                      
                            -------------------                               
   begin                : Sun Apr 25 1999                                   
   copyright            : (C) 1999 by Jonathan E. Anderson                    
   email                : ande1514@tc.umn.edu                                
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "controller.h"
#include "entity.h"
#include "keyframe.h"

#include "../basecontroller.h"


Controller::Controller() :
      frames()
{

   frames.reserve( 20 );
   time = 1;
   max_time = 1;

   Keyframe f( 1 );

   frames.push_back( f );


   dirty = true;

   prev = &( frames[ 0 ] );
   next = &( frames[ 0 ] );

   BaseController *bc = BaseController::getInstance();

   bc->addController( this );

}

Controller::~Controller()
{
   BaseController * bc = BaseController::getInstance();
   bc->removeController( this );
   // frames.clear();
}


void Controller::setAttrib( int s, const Vector4 & p )
{

   if ( next == prev )
   {  //are we on a keyframe right now?
      prev->set( s, p );
      return ;
   }

   //otherwise, make a new keyframe, setting it up correctly.
   Keyframe f;

   f.setTime( time );

   f.set( s, p );

   //insert it in sorted order
   int i = 0;

   while ( i < ( int ) frames.size() && frames[ i ].getTime() < time )
   {
      i++;
   }

   frames.insert( frames.begin() + i, f );


   //set the keyframe pointers appropriately.
   prev = &( frames[ i ] );
   next = &( frames[ i ] );

   return ;
}


Vector4 Controller::getAttrib( int s )
{

   if ( next == prev ) // we are on a keyframe;
      return prev->get( s );

   //otherwise we need to interpolate.
   if ( next == 0 )
   {
      return prev->get( s );
   }

   float start_percent = 0;
   //  float end_percent = 0;

   int temp1, temp2;
   //get the two vectors;
   Vector4 prev_vector = prev->get( s );
   Vector4 next_vector = next->get( s );
   Vector4 difference_vector( next_vector - prev_vector );

   //if it's not meant to be interpolated, return the prev vector
   if ( !prev_vector.isInterpolatable() )
      return prev_vector;

   //otherwise, let's interpolate it!
   //we need special casing for quats!

   temp1 = time - prev->getTime();

   temp2 = next->getTime() - prev->getTime();

   // int total = temp2- temp1;

   // float total_percent = (float)(time-temp1)/total;
   start_percent = ( float ) temp1 / temp2;

   /*
   Vector4 *current_vector = new Vector4(prev_vector->x + next_vector->x,
      prev_vector->y + next_vector->y,
      prev_vector->z + next_vector->z,
      prev_vector->w + next_vector->w);
   *current_vector *= start_percent;
      */
   Vector4 current_vector( prev_vector );

   difference_vector *= start_percent;

   current_vector += difference_vector;

   //    current_vector->w = 1;

   return current_vector;

}

void Controller::loadTime( int _time )
{
   //set the time of the controller
   time = _time;

   //compute the new interpolated keyframe stuff.
   int i = 0;

   while ( ( i < ( int ) frames.size() ) && ( frames[ i ].getTime() <= time ) )
   {
      //  Keyframe *kf = &(frames[i]);
      if ( frames[ i ].getTime() == time )
      { //we got a winner!!
         prev = &( frames[ i ] );
         next = &( frames[ i ] );
         ent->loadState();
         return ;
      }

      i++;
   }

   prev = &( frames[ i - 1 ] );

   if ( i == ( int ) frames.size() )
      next = 0;
   else
      next = &( frames[ i ] );


   //update the entity
   //if it's a new frame, the entity will be saving it's state, rather than loading it.
   // if(!bNewFrame)
   ent->loadState();

   // else
   //  ent->saveState();

}

void Controller::saveTime( int _time )
{
   //set the time of the controller
   // cerr<<"Saving time in controller"<<endl;
   time = _time;

   //update the max_time;
   if ( time > max_time )
      max_time = time;


   int i = 0;

   while ( ( i < ( int ) frames.size() ) && ( frames[ i ].getTime() <= time ) )
   {
      if ( frames[ i ].getTime() == time )
      { //we got a winner!!
         prev = &( frames[ i ] );
         next = &( frames[ i ] );
         ent->loadState();
         return ;
      }

      i++;
   }

   prev = &( frames[ i - 1 ] );

   if ( i == ( int ) frames.size() )
      next = 0;
   else
      next = &( frames[ i ] );

   //update the entity
   //if it's a new frame, the entity will be saving it's state, rather than loading it.
   // if(!bNewFrame)
   //  ent->loadState();
   // else
   ent->saveState();
}

void Controller::incrementTime()
{
   //This is used for playback mostly
   time++;

   //if(wraparound)
   // if(time > max_time)
   //   time -= max_time;

   //Computes the boundary frames for the current time.
   //this can be optimized because we know the linear progression of time.
   //of the time.

   if ( next == 0 )
   {      //we are currently on a exact keyframe
      //    next = prev->next();   //need to fix this=)
      return ;
   }

   if ( time > next->getTime() )
   { //entering into the next keyframe pair
      prev = next;
      // next = next->next();       //need to fix this=)
   }


   //update the entity

   ent->loadState();
}

Controller & Controller::operator=( Controller &rhs )
{
   frames.clear();
   frames = rhs.frames;
   return *this;
}



























