/***************************************************************************
                          i3dstaticio.h  -  description                              
                             -------------------                                         
    begin                : Tue Oct 19 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef I3DSTATICIO_H
#define I3DSTATICIO_H

#include "fileio.h"
#include <vector>
#include <string>
#include <map>

class Mesh;
class Line;
class Light;
class Bone;
class NurbsSurface;
class NurbsCurve;
class TextureMaterial;
class Entity;
class Spline;
class SubObject;
class Vertex;

/**I3DStaticIO saves the modelling database to a file
that contains only static information.  No animation
channels are saved.
  *@author Jon Anderson
  */

class I3DStaticIO : public FileIO  {
public:

    typedef map<string, Entity *, less<string> > EntityMap;
    typedef EntityMap::value_type EntityPair;

    typedef multimap<string, Entity *, less<string> > MultiEntityMap;
    typedef MultiEntityMap::value_type MultiEntityPair;

    typedef map<string, SubObject *, less<string> > SubObjectMap;
    typedef SubObjectMap::value_type SubObjectPair;

    typedef multimap<string, Bone *, less<string> > AffectedMap;
    typedef AffectedMap::value_type AffectedPair;


    I3DStaticIO(string name, int mode=1);
    virtual ~I3DStaticIO();

    virtual void write();
    virtual void read();
    void saveSurface(NurbsSurface *s);
    void saveCurve(NurbsCurve *c);
    void saveMesh(Mesh *o);
    void saveLine(Spline *s, bool poly);
    void saveLight(Light *l);
    void saveBone(Bone *b);
    void readMesh();
    void readLine(bool poly);
    void readLight();
    void readCurve();
    void readSurface();
    void readBone();

    void readMeta(Entity *);
    void saveMeta(Entity *);

protected:
    vector<TextureMaterial *> mats;

    EntityMap entity_map;

    MultiEntityMap entity_parentable;

    SubObjectMap subobject_map;

    AffectedMap affected_map;

};

#endif







