//
// (c) Polar Pyramid
// suggestions to stolken@kabelfoon.nl and/or stolk@xs4all.nl
//
// Description:
//	The Matrix44 class is a matrix of 4x4 floats
//      Example of usage:
//
//        Matrix44 A(1.2), B(10.0);
//        Matrix44 C = A*B;
//

#ifndef MATRIX44_HH
#define MATRIX44_HH

#include "vector3.h"
#include "vector4.h"
#include "quat.h"
#include <math.h>

class Matrix44         // generic float 4 x 4 matrix
{
public:
  // constructors

	Matrix44();
	Matrix44(const Vector3 &a); // construct from array: translation
	Matrix44(const Quat &q); // construct from quaternion: rotation

	Matrix44(const Matrix44 &);
	Matrix44(float m00, float m01, float m02, float m03,
	   float m10, float m11, float m12, float m13,
	   float m20, float m21, float m22, float m23,
	   float m30, float m31, float m32, float m33);

  // member functions

  float Invert(void);
  Matrix44 Transpose(void);
  void Unit(void);

  // assignment

  Matrix44& Assign(const float [4][4]);
  Matrix44& Matrix44::Assignf(const float mat[16]);

  Matrix44& TransposeAssign(const float [4][4]);

  bool IsValid(void) const;

  // math operators

  Matrix44& operator *= (const Matrix44& m);

  
  Vector3 operator * (const Vector3 &) const;
  Vector4 operator * (const Vector4 &) const;

  bool operator == (const Matrix44&) const;
  bool operator != (const Matrix44&) const;

  // conversions

  void CopyTo(float [4][4]) const;
	void CopyTof(float [16]) const;

  void TransposeCopyTo(float [4][4]) const;

  // translation part

  void SetPos(const Vector4 &pos);
  Vector4 GetPos(void) const;

  // arbitrary colomn vector

  Vector3 GetAxis(int columnnr) const;

  Matrix44 Orbit(float horizontal,
		 float vertical) const;
  Matrix44 Ori(void) const;
   Quat GetQuat(void) const;
   void ResetOrientation(void);
   void Dump(void) const;
public:
  float           m[4][4];  // the matrix data
};


inline const Matrix44 operator*(const Matrix44 &lhs, const Matrix44
&rhs) {
  return Matrix44(lhs) *= rhs;
}


#endif








