/***************************************************************************
                          fileplugin.h  -  description
                             -------------------
    begin                : Thu Feb 10 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEPLUGIN_H
#define FILEPLUGIN_H

#include "pluginbase.h"

#include <objectdb.h>
#include <i3ddoc.h>
#include <i3d.h>
#include <Controls/mateditor.h>
#include <fstream.h>


class Entity;
class TransactionCommand;

/**This is the base class for all import/export plugins.  File plugins are created by
  *deriving a new class from this one.
  * The plugin then sets what kind of IO it can do (export/import/both)
  * and re-implements the appropriate IO functions.
  *@author Jon Anderson
  */

class FilePlugin : public PluginBase  {
public: 
	FilePlugin(QString name, QString ext);
	virtual ~FilePlugin();
	
	QString getExtension();
	
	virtual void importData(ifstream &){};             //each plugin can re-implement this;
	virtual void exportData(ofstream &){};             //each plugin can re-implement this;

  void addEntity(Entity *);  								//encapsulate all the adding stuff;

  void setExportable(bool f);
	void setImportable(bool f);
	void setBinary(bool f);

	void beginImport();
	void endImport();
	
	bool isExportable();
	bool isImportable();
	bool isBinary();
	

	void fileImport();
	void fileExport();	
	
private:
	bool binary;
	bool importable;
	bool exportable;
  QString extension;
  TransactionCommand *c;
	
};

#endif
