/***************************************************************************
                          redostack.h  -  description                              
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef REDOSTACK_H
#define REDOSTACK_H

#include <qstack.h>
#include "Commands/command.h"


/**This static class object contains all commands that can
be redone.
  *@author Jon Anderson
  */

class RedoStack {
public: 
	RedoStack();
	~RedoStack();
  /**  */
  Command * pop();
  void push(Command *);
  void clear();
  void setSize(int i){size = i;};
  static RedoStack *getInstance();
  bool isEmpty(){return stack->isEmpty();};
  Command* current() {return stack->current();};

private: // Private attributes
	/**  */
  QStack<Command> * stack;
  static RedoStack *redo;
  int size;

};

#endif
