/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  context.cc - GdkGLContext C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "context.h"
#include "private/context_p.h"
#include "config.h"
#include "drawable.h"

using namespace Inti;

/*  Gdk::GL::Context
 */

Gdk::GL::Context::Context(GdkGLContext *context, bool reference)
: G::Object((GObject*)context, reference)
{
}

Gdk::GL::Context::~Context()
{
}

Pointer<Gdk::GL::Context>
Gdk::GL::Context::create(const Drawable& gldrawable, bool direct, int render_type)
{
	return G::Object::wrap<Context>(gdk_gl_context_new(gldrawable.gdk_gl_drawable(), 0, direct, render_type));
}

Pointer<Gdk::GL::Context>
Gdk::GL::Context::create(const Drawable& gldrawable, const Context& share_list, bool direct, int render_type)
{
	return G::Object::wrap<Context>(gdk_gl_context_new(gldrawable.gdk_gl_drawable(), share_list.gdk_gl_context(), direct, render_type));
}

GdkGLContextClass*
Gdk::GL::Context::gdk_gl_context_class() const
{
	return get_class<GdkGLContextClass>();
}

Gdk::GL::Context::operator GdkGLContext* () const
{
	return this ? gdk_gl_context() : 0;
}

Gdk::GL::Drawable*
Gdk::GL::Context::get_gl_drawable() const
{
	GdkGLDrawable *drawable = gdk_gl_context_get_gl_drawable(gdk_gl_context());
	Gdk::GL::Drawable *tmp_drawable = 0;
	if (drawable)
	{
		G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(drawable));
		tmp_drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	}
	return tmp_drawable;
}

Gdk::GL::Config*
Gdk::GL::Context::get_gl_config() const
{
	return G::Object::wrap<Config>(gdk_gl_context_get_gl_config(gdk_gl_context()));
}

Gdk::GL::Context*
Gdk::GL::Context::get_share_list() const
{
	return G::Object::wrap<Context>(gdk_gl_context_get_share_list(gdk_gl_context()));
}

bool
Gdk::GL::Context::is_direct() const
{
	return gdk_gl_context_is_direct(gdk_gl_context());
}

int
Gdk::GL::Context::get_render_type() const
{
	return gdk_gl_context_get_render_type(gdk_gl_context());
}

Gdk::GL::Context*
Gdk::GL::Context::get_current()
{
	return G::Object::wrap<Context>(gdk_gl_context_get_current());
}

void
Gdk::GL::Context::dispose()
{
	gdk_gl_context_destroy(gdk_gl_context());
}

bool
Gdk::GL::Context::copy(const Context& src, unsigned long mask)
{
	return gdk_gl_context_copy(gdk_gl_context(), src.gdk_gl_context(), mask);
}

/*  Gdk::GL::ContextClass
 */

void
Gdk::GL::ContextClass::init(GdkGLContextClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
}

GType
Gdk::GL::ContextClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GDK_TYPE_GL_CONTEXT, (GClassInitFunc)init);
	}
	return type;
}

void*
Gdk::GL::ContextClass::create()
{
	return g_object_new(get_type(), 0);
}

