<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999,2000 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("normal");

commonHeader(_("Networking") . " - " . _("Port"));
__("This is where you can connect ports together, disconnect them, change their properties, etc.")."<hr noshade>\n";

PRINT '<form method=get action="'.Config::AbsLoc('users/networking-port-update.php').'">';
PRINT "<table border=1>\n";	
$qID = $DB->getTextValue($ID);
$query_port = "SELECT * FROM networking_ports WHERE ID = $qID";
$DB = Config::Database();
$result_port = $DB->getRow($query_port);
$ID = $result_port["ID"];
$name = $result_port["name"];
$logical_number = $result_port["logical_number"];
$iface = $result_port["iface"];
$device_on = $result_port["device_on"];
$device_type = $result_port["device_type"];
$ifaddr = $result_port["ifaddr"];
$ifmac = $result_port["ifmac"];

$qID = $DB->getTextValue($ID);
$wquery = "SELECT * FROM networking_wire WHERE (end1 = $qID OR end2 = $qID)";
$wresult = $DB->getRow($wquery);
if (count($wresult) > 0) 
{
	$wID = $wresult["ID"];
	$wend1 = $wresult["end1"];
	$wend2 = $wresult["end2"];
	if ($wend1 == $ID) 
	{
		$qwID = $DB->getTextValue($wend2);
	}
	else 
	{
		$qwID = $DB->getTextValue($wend1);
	}
	$pquery = "SELECT * FROM networking_ports WHERE (ID = $qwID)";
	$presult = $DB->getRow($pquery);
	$pID = $presult["ID"];
	$pNum = $presult["logical_number"];
	$pOn = $presult["device_on"];
	$pType = $presult["device_type"];
	$qpOn = $DB->getTextValue($pOn);
	if ($pType == 1) 
	{
		$nquery = "SELECT ID,name FROM computers WHERE (ID = $qpOn)";
	}
	else if ($pType == 2)
	{
		$nquery = "SELECT ID,name FROM networking WHERE (ID = $qpOn)";
	}
	$nresult = $DB->getRow($nquery);
	$nname = $nresult["name"];
	$nID = $nresult["ID"];
	$found = 1;
}

PRINT "<tr><td>"._("Logical Number:")."</td><td><input type=text size=5 name=logical_number value=$logical_number></td></tr>";
PRINT "<tr><td>"._("Name")."</td><td><input type=text size=20 value=\"$name\" name=name></td></tr>";
PRINT "<tr><td>"._("Interface")."</td><td>";
Dropdown_value("dropdown_iface","iface", $iface);
PRINT "</td></tr>";
PRINT "<tr><td>"._("IP Address")."</td><td><input type=text size=20 name=ifaddr value=\"$ifaddr\"></td></tr>";
PRINT "<tr><td>"._("MAC/Network Address")."</td><td><input type=text size=25 name=ifmac value=\"$ifmac\"></td></tr>";
PRINT "<tr><td>"._("Connection")."</td><td>";
if ($pType == 1) 
{
	printf(_('Port %s on computer %s'),
		'<a href="'
			.Config::AbsLoc("users/networking-port.php", array('ID' => $pID))
			."\">$pNum</a>",
		'<a href="'
			.Config::AbsLoc("users/computers-info.php", array('ID' => $nID))
			."\">$nname ($nID)</a>"
		);
	PRINT ' | <a href="'.Config::AbsLoc("users/networking-port-discon.php", array('ID' => $ID)).'">'._("Disconnect").'</a>.';
}
else if ($pType == 2) 
{
	printf(_("Port %s on network device %s"),
		'<a href="'.Config::AbsLoc("users/networking-port.php", array('ID' => $pID))
			."\">$pNum</a>",
		'<a href="'.Config::AbsLoc("users/networking-info.php", array('ID' => $nID))
			."\">$nname ($nID)</a>"
		);

	PRINT ' | <a href="'.Config::AbsLoc("users/networking-port-discon.php?ID=$ID").'">'._("Disconnect").'</a>.';
}
else if ($found != 1) 
{
	__("Nothing Connected.").' <a href="'.Config::AbsLoc("users/networking-connecter.php?ID=$ID").'">'._("Connect").'</a>';
}
PRINT "</td></tr>";
PRINT "<tr><td><input type=hidden name=device value=$device_on><input type=hidden name=device_type value=$device_type><input type=hidden name=ID value=$ID><input type=submit value=\""._("Update")."\"></td></form>";
PRINT '<form method=get action="'.Config::AbsLoc('users/networking-port-del.php').'">';
PRINT "<input type=hidden name=ID value=$ID><td><input type=submit value=\""._("Remove")."\"></td></tr></form>";
PRINT "</table>";

commonFooter();
