#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <unistd.h>

#include "prototypes.h"

/*
   Copyright (C) 2003 Red Hat, Inc. All rights reserved.
                                                                                                             
   Usage and distribution of this file are subject to the Open Software License version 2.1
   that can be found at http://www.opensource.org/licenses/osl-2.1.txt and the COPYING file as
   distributed together with this file is included herein by reference. Alternatively you can use 
   and distribute this file under version 1.1 of the same license.

   Author: Arjan van de Ven   <arjanv@redhat.com>

*/

/*
 * Code to deal with /proc/cpuinfo 
 */

static int siblings[MAX_CPU];	         /* number of HT siblings for each cpu */
static unsigned int cpunumber[MAX_CPU];  /* physical package identifier for each CPU*/
int cpucount = -1;		         /* total number of CPU's */
int machineneedsbalance;		 /* set to 15 for Intel pIV, 0 or 1 elsewhere */
unsigned int cpubrother[MAX_CPU];        /* the cpu number of the HT sibling if present, if absent
				            cpubrother[x] yields x */

int parse_proc_cpuinfo(void) 
{
	FILE *file;
	char linebuffer[1024];
	int i, j;
	
#if !defined(__i386__) && !defined(__x86_64__)
	for (i = 0; i < MAX_CPU; i++)
		cpubrother[i] = i;
	cpucount = sysconf(_SC_NPROCESSORS_ONLN);
	return 0;
#endif		
	
	file = fopen("/proc/cpuinfo","r");
	assert(file != NULL);
	while (!feof(file) && cpucount < MAX_CPU) {
		fgets(linebuffer, 1024, file);
		if (strstr(linebuffer,"Physical processor ID\t:"))
			sscanf(linebuffer,"Physical processor ID\t: %ui", &cpunumber[cpucount]);
		else if (strstr(linebuffer,"processor\t:"))
			cpucount++;
		else if (strstr(linebuffer,"Number of siblings\t:"))
			sscanf(linebuffer,"Number of siblings \t: %i", &siblings[cpucount]);
		else if (strstr(linebuffer,"siblings\t:"))
			sscanf(linebuffer,"siblings\t: %i", &siblings[cpucount]);
		else if (strstr(linebuffer,"physical id\t:"))
			sscanf(linebuffer,"physical id\t: %ui", &cpunumber[cpucount]);
		else if (strstr(linebuffer,"GenuineIntel")) {
			if (!machineneedsbalance)
				machineneedsbalance = 1;
		} else if (machineneedsbalance && strstr(linebuffer,"cpu family\t:"))
			sscanf(linebuffer,"cpu family\t: %ui",&machineneedsbalance);
	}
	
	cpucount++;
	
	fclose(file);
	
	/* now to match up the HT siblings based on physical ID */
	
	/* start out unmatched */
	for (i = 0; i < MAX_CPU; i++)
		cpubrother[i] = i;

	/* and brute-force the search */
	for (i = 0; i < cpucount; i++)
	 	for (j=0; j < cpucount; j++) {
	 		if ( (cpunumber[i]==cpunumber[j]) && (i!=j) && (siblings[i]>1)) {
	 			cpubrother[i] = j;
	 			continue;
	 		}
	 	}	
		
	return 0;
}

