/*
 setup.c : configuration for sound plugin

    Copyright (C) 1999 Trever Adams

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include "sound.h"

static gchar *mp3_path, *midi_path, *default_path, *sound_dir;

SETUP_REC plugin_sound_options[] =
{
    { SETUP_TYPE_ENTRY, &sound_dir, "sound_dir", "~/ircwaves" },
    { SETUP_TYPE_ENTRY, &mp3_path, "mp3_player", "mpg123 %s" },
    { SETUP_TYPE_ENTRY, &midi_path, "midi_player", "playmidi %s" },
    { SETUP_TYPE_ENTRY, &default_path, "default_player", "esdplay %s" },
    { 0, NULL, NULL }
};

void plugin_sound_get_setup(PLUGIN_DATA *data)
{
    data->sound_dir = g_strdup(sound_dir);
    data->mp3_path = g_strdup(mp3_path);
    data->midi_path = g_strdup(midi_path);
    data->default_path = g_strdup(default_path);
}

void plugin_sound_setup_init(PLUGIN_REC *plugin)
{
    PLUGIN_DATA *data = plugin->data;

    setup_read("plugin_"PLUGIN_NAME, plugin_sound_options);
    plugin_sound_get_setup(data);
}

void plugin_sound_setup_deinit(PLUGIN_REC *plugin)
{
    setup_free(plugin_sound_options);
}
