/*
 setup-ircproxy.c : IRC proxy notebook entry for preferences

    Copyright (C) 1999 Timo Sirainen
                       Kari Lavikka (tuner@bdb.fi)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "setup-int.h"

static GtkWidget *setup_dialog;

static gboolean sig_setup_apply(void)
{
    setup_write("ircproxy", ircproxy_options);
    return TRUE;
}

static void sig_ircproxy_toggled(GtkWidget *button)
{
    gboolean active;

    active = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button));

    gtk_widget_set_sensitive(ircproxy_options[OPTION_PROXY_ADDRESS].widget, active);
    gtk_widget_set_sensitive(ircproxy_options[OPTION_PROXY_PORT].widget, active);
    gtk_widget_set_sensitive(ircproxy_options[OPTION_PROXY_STRING].widget, active);
}

static gboolean setup_ircproxy(GtkWidget *dialog)
{
    GtkWidget *table, *checkbox, *entry, *label, *spin, *hbox;
    GtkAdjustment *adj;

    setup_dialog = dialog;

    table = gtk_table_new(3, 2, FALSE);
    gtk_container_border_width(GTK_CONTAINER(table), 7);
    gtk_table_set_col_spacing(GTK_TABLE(table), 0, 5);

    checkbox = gtk_check_button_new_with_label(_("Use IRC proxy"));
    gtk_signal_connect(GTK_OBJECT(checkbox), "toggled",
                       GTK_SIGNAL_FUNC(sig_ircproxy_toggled), NULL);
    ircproxy_options[OPTION_USE_IRCPROXY].widget = checkbox;
    gtk_table_attach(GTK_TABLE(table), checkbox, 0, 2, 0, 1, GTK_FILL, GTK_FILL, 0, 0);

    entry = gui_create_tablelabelentry(table, 0, 1, _("Address"),
                                       *((gchar **) ircproxy_options[OPTION_PROXY_ADDRESS].data));
    gtk_widget_set_sensitive(entry, FALSE);
    ircproxy_options[OPTION_PROXY_ADDRESS].widget = entry;

    label = gtk_label_new(_("Port"));
    gtk_misc_set_alignment(GTK_MISC(label), 1, .5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 0, 0);

    hbox = gtk_hbox_new(FALSE, 0); /* to left justify the spin.. couldn't think of any other way.. */
    gtk_table_attach(GTK_TABLE(table), hbox, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 0, 0);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) ircproxy_options[OPTION_PROXY_PORT].data),
                                                1, G_MAXINT, 1, 100, 0);
    spin = gtk_spin_button_new(adj, 0, 0);
    ircproxy_options[OPTION_PROXY_PORT].widget = spin;
    gtk_widget_set_sensitive(spin, FALSE);
    gtk_widget_set_usize(spin, 60, -1);
    gtk_box_pack_start(GTK_BOX(hbox), spin, FALSE, FALSE, 0);

    entry = gui_create_tablelabelentry(table, 0, 3, _("Send to proxy after connect"),
                                       *((gchar **) ircproxy_options[OPTION_PROXY_STRING].data));
    gtk_widget_set_sensitive(entry, FALSE);
    ircproxy_options[OPTION_PROXY_STRING].widget = entry;

    setup_finish_init(dialog, ircproxy_options);

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
                                   table, gtk_label_new(_("IRC proxy")));
    return TRUE;
}

void init_ircproxy(void)
{
    signal_add("setup servers apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_add("setup servers", (SIGNAL_FUNC) setup_ircproxy);
}

void deinit_ircproxy(void)
{
    signal_remove("setup servers apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_remove("setup servers", (SIGNAL_FUNC) setup_ircproxy);
}
