/*

 ui-hilight.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

static gboolean sig_hilight_text(SERVER_REC *server, gchar *channel, gpointer level, gchar *msg)
{
    CHANNEL_REC *chanrec;

    chanrec = channel_find_closest(server, channel, GPOINTER_TO_INT(level));
    if (CHANNEL_PARENT(chanrec) == CHANNEL_PARENT(cur_channel) || chanrec->type == CHANNEL_TYPE_SETUP ||
	(GPOINTER_TO_INT(level) & (MSGLEVEL_NEVER|MSGLEVEL_NO_ACT|MSGLEVEL_MSGS))) return TRUE;

    if (chanrec->new_data == 0) chanrec->new_data = NEWDATA_TEXT;
    signal_emit("gui hilight channel", 1, chanrec);

    return TRUE;
}

static gboolean sig_hilight_msg(gchar *data, SERVER_REC *server, gchar *nick, gchar *addr)
{
    CHANNEL_REC *channel;
    gchar *params, *target, *msg;
    gint level;

    g_return_val_if_fail(data != NULL, FALSE);

    params = event_get_params(data, 2 | PARAM_FLAG_GETREST, &target, &msg);

    if (*msg == 1)
    {
	/* don't hilight CTCPs */
	g_free(params);
	return TRUE;
    }
    channel = ischannel(*target) ?
	channel_find_closest(server, target, MSGLEVEL_PUBLIC) :
	channel_find_closest(server, nick, MSGLEVEL_MSGS);

    /* check that msg wasn't send to current channel and that it didn't get ignored */
    if (channel != NULL && CHANNEL_PARENT(channel) != CHANNEL_PARENT(cur_channel) &&
	channel->type != CHANNEL_TYPE_SETUP && !ignore_check(server, nick, addr, ischannel(*target) ? MSGLEVEL_PUBLIC : MSGLEVEL_MSGS) &&
	(!ischannel(*target) || !ignore_check(server, target, NULL, MSGLEVEL_PUBLIC)))
    {
	level = !ischannel(*target) || ui_completion_msgtoyou(server, msg) ?
	    NEWDATA_MSG_FORYOU : NEWDATA_MSG;
	if (channel->new_data < level)
	{
	    channel->new_data = level;
	    signal_emit("gui hilight channel", 1, channel);
        }
    }

    g_free(params);
    return TRUE;
}

static gboolean sig_dehilight(CHANNEL_REC *channel)
{
    g_return_val_if_fail(channel != NULL, FALSE);

    if (channel->new_data != 0)
    {
        channel->new_data = 0;
        signal_emit("gui hilight channel", 1, channel);
    }
    return TRUE;
}

static gboolean sig_dehilight_window(WINDOW_REC *window)
{
    g_return_val_if_fail(window != NULL, FALSE);

    g_list_foreach(window->channels, (GFunc) sig_dehilight, NULL);
    return TRUE;
}

static gboolean sig_hilight_channel(CHANNEL_REC *channel)
{
    WINDOW_REC *window;
    GList *tmp;
    gint level, oldlevel;

    window = CHANNEL_PARENT(channel); level = 0;
    for (tmp = g_list_first(window->channels); tmp != NULL; tmp = tmp->next)
    {
        channel = tmp->data;
        if (channel->new_data > level)
            level = channel->new_data;
    }

    oldlevel = window->new_data;
    if (window->new_data < level || level == 0)
    {
	window->new_data = level;
	signal_emit("gui hilight window", 2, window, GINT_TO_POINTER(oldlevel));
    }
    signal_emit("gui window activity", 2, window, GINT_TO_POINTER(oldlevel));

    return TRUE;
}

void ui_hilight_init(void)
{
    signal_add("print text", (SIGNAL_FUNC) sig_hilight_text);
    signal_add_last("event privmsg", (SIGNAL_FUNC) sig_hilight_msg);
    signal_add("channel focused", (SIGNAL_FUNC) sig_dehilight);
    signal_add("window focused", (SIGNAL_FUNC) sig_dehilight_window);
    signal_add("window dehilight", (SIGNAL_FUNC) sig_dehilight_window);
    signal_add("gui hilight channel", (SIGNAL_FUNC) sig_hilight_channel);
}

void ui_hilight_deinit(void)
{
    signal_remove("print text", (SIGNAL_FUNC) sig_hilight_text);
    signal_remove("event privmsg", (SIGNAL_FUNC) sig_hilight_msg);
    signal_remove("channel focused", (SIGNAL_FUNC) sig_dehilight);
    signal_remove("window focused", (SIGNAL_FUNC) sig_dehilight_window);
    signal_remove("window dehilight", (SIGNAL_FUNC) sig_dehilight_window);
    signal_remove("gui hilight channel", (SIGNAL_FUNC) sig_hilight_channel);
}
