/*
 ui-translation.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

guchar translation_in[256], translation_out[256];

void ui_translation_reset(void)
{
    gint n;

    for (n = 0; n < 256; n++)
        translation_in[n] = (guchar) n;
    for (n = 0; n < 256; n++)
        translation_out[n] = (guchar) n;
}

void ui_translate_output(gchar *text)
{
    while (*text != '\0')
    {
	*text = (gchar) translation_out[(gint) (guchar) *text];
	text++;
    }
}

#define gethex(a) \
    (isdigit(a) ? ((a)-'0') : (toupper(a)-'A'+10))

gboolean ui_translation_read(gchar *file)
{
    GString *output, *buffer;
    gchar *path, *ptr;
    gint f, pos, value;

    g_return_val_if_fail(file != NULL, FALSE);

    path = convert_home(file);
    f = open(file, O_RDONLY);
    g_free(path);

    if (f == -1) return FALSE;

    pos = 0;
    output = g_string_new(NULL);
    buffer = g_string_new(NULL);
    while (read_line(FALSE, f, output, buffer) > 0)
    {
	if (pos == 512)
	    break;

	for (ptr = output->str; *ptr != '\0'; ptr++)
	{
	    if (ptr[0] != '0' || ptr[1] != 'x')
		break;
	    ptr += 2;

	    value = (gethex(ptr[0]) << 4) + gethex(ptr[1]);
	    if (pos < 256)
		translation_in[pos] = (guchar) value;
            else
		translation_out[pos-256] = (guchar) value;
	    pos++;

	    ptr += 2;
	    if (*ptr != ',') break;
	}
    }
    g_string_free(output, TRUE);
    g_string_free(buffer, TRUE);

    close(f);
    if (pos != 512)
	ui_translation_reset();
    return pos == 512;
}

static gboolean sig_setup(void)
{
    ui_translation_read(setup_get_str("translation"));
    return TRUE;
}

void ui_translation_init(void)
{
    ui_translation_reset();

    signal_add("setup changed", (SIGNAL_FUNC) sig_setup);
    signal_add("irssi init finished", (SIGNAL_FUNC) sig_setup);
}

void ui_translation_deinit(void)
{
    signal_remove("setup changed", (SIGNAL_FUNC) sig_setup);
    signal_remove("irssi init finished", (SIGNAL_FUNC) sig_setup);
}
