/*
 * text_input_dialog.h - declaration of class textInputDialog, a simple dialog for editing a string
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _TEXT_INPUT_DIALOG_H
#define _TEXT_INPUT_DIALOG_H

#include <qdialog.h>


/*!
  \brief The Text-Input-Dialog

  This widget provides a simple dialog with a line-edit-widget. It's useful for input of a line, for example an user, that should
  be logged in...

  \sa   cmdInputDialog
*/


class QLineEdit;
class QLabel;


class textInputDialog : public QDialog
{
	Q_OBJECT
public:
	textInputDialog( const QString & _txt, QString & _r_string, QWidget * _parent );
	~textInputDialog();


protected:
	void resizeEvent( QResizeEvent * _re );


private slots:
	void textChanged( const QString & _new_string );


private:
	void keyPressEvent( QKeyEvent * _ke );

	QLabel * m_txtLbl;
	QString & m_stringToEdit;
	QLineEdit * m_stringLineEdit;

} ;

#endif
