/*****************************************************************************
 *                               CmdSwitcher.cc 
 * Author: Matthew Ballance
 * Desc:   Implements the command switcher..
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *****************************************************************************/
#include "CmdSwitcher.h"
#include <tcl.h>

/**************************************************************
 * CmdSwitch() 
 **************************************************************/
Int32 CmdSwitch(CmdSwitchStruct    *Cmds, Char *Cmd)
{
    int i = 0;
    int cmdIdx = 0; 
    int foundCmd = -1;

    while(Cmds[i].cmdString[0] != 0) {
        while ((Cmds[i].cmdString[cmdIdx] != 0) && 
               (Cmd[cmdIdx] != 0) && 
               (Cmd[cmdIdx] == Cmds[i].cmdString[cmdIdx])) cmdIdx++;
        if (Cmds[i].cmdString[cmdIdx] || Cmd[cmdIdx]) {
            i++;
            cmdIdx = 0;
        } else {
            foundCmd = Cmds[i].cmdIdx;
            break;
        }
    }
    return foundCmd;
}

/**************************************************************
 * CmdSwitch_AppendAll()
 **************************************************************/
void CmdSwitch_AppendAll(Tcl_Interp *interp, CmdSwitchStruct *cmds)
{
    Uint32 idx = 0;

    while (cmds[idx].cmdString[0]) {
        Tcl_AppendResult(interp, cmds[idx].cmdString, " ", 0);
        idx++;
    }
}

/**************************************************************
 * ParseArgs()
 **************************************************************/
Int32 ParseArgs(
    OptTypeStruct   *optSpec,
    Uint32           argc,
    Char           **argv,
    Uint32          *argcO, 
    Char           **argvO,
    Uint32          *optcO,
    Char           **optO,
    Int32           *optTO
    )
{
    Uint32    i, x, y;
    Int32     status = 1;

    *argcO = 0;
    *optcO = 0;

    for (i=0; i<argc; i++) {
        /**** Match against the opt specs ****/
        if (argv[i][0] == '-') {
            for (x=0; (optSpec[x].optString[0] != 0); x++) {
                y = 0;
                while ((optSpec[x].optString[y] != 0) &&
                       (argv[i][y] != 0) &&
                       (optSpec[x].optString[y] == argv[i][y])) y++;
                if ((argv[i][y] == 0) && (optSpec[x].optString[y] == 0)) {
                    optTO[(*optcO)] = optSpec[x].optType;
                    if (optSpec[x].flagOpt == false) {
                        i++; 
                        if (i < argc) {
                            optO[(*optcO)] = argv[i];
                        } else {
                            status = -1;
                            goto opt_exit;
                        }
                    } else {
                        optO[(*optcO)] = argv[i];
                    }
                    (*optcO)++;
                    break;
                }
            }
        } else {
            argvO[(*argcO)++] = argv[i];
        }
    }

opt_exit:
    return status;
}

