/****************************************************************************
 *                            Tokenizer.cc
 *
 * Author: Matthew Ballance
 * Desc:
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "Tokenizer.h"
#include <ctype.h>

/********************************************************************
 * Tokenizer()
 ********************************************************************/
Tokenizer::Tokenizer() : d_accObj(0), d_store(512)
{

}

/********************************************************************
 * operator ()
 ********************************************************************/
void Tokenizer::operator () (FileAccObj *f_acc)
{
    d_accObj = f_acc;
}

/********************************************************************
 * skipWhite()
 ********************************************************************/
char Tokenizer::skipWhite(char ch1)
{
    char ch = 0;

    if (ch1 > 0) {
        ch = ch1;
    } else {
        ch = getChar();
    }

    do {
        if ((ch < 0) || !isspace(ch)) {
            return ch;
        }

        ch = getChar();
    } while (1);

    return -1;
}

/********************************************************************
 * skipComment()
 ********************************************************************/
char Tokenizer::skipComment(char ch1)
{
    char ch;

    if (ch1 > 0) {
        ch = ch1;
    } else {
        ch = getChar();
    }

    do {
        if (ch < 0) { return -1; }
        if (ch == '#') {
            while (((ch=getChar()) > 0) && (ch != '\n')) { ; }
            ch = getChar();
        } else {
            return ch;
        }
    } while (1);

    return -1;
}

/********************************************************************
 * isTokSep()
 ********************************************************************/
bool Tokenizer::isTokSep(char c)
{
    if (isspace(c)) {
        return true;
    } else {
        return false;
    }
}

/********************************************************************
 * isOneChTok()
 ********************************************************************/
#if 0
bool Tokenizer::isOneChTok(char c)
{

}
#endif

/********************************************************************
 * getToken()
 ********************************************************************/
char *Tokenizer::getToken()
{
    if (d_store.length()) {
        return d_store.value();
    } else {
        return 0;
    }
}

/********************************************************************
 * nextToken()
 ********************************************************************/
char *Tokenizer::nextToken()
{
    char ch;

    d_store.setLen(0);
    d_store[0] = 0;

    /**** Remove leading whitespace and comments ****/
    do {
        if ((ch = skipWhite(0)) < 0) {
            return 0;
        }

        if ((ch = skipComment(ch)) < 0) {
            return 0;
        }
    } while (isspace(ch) || ch == '#');

    do {
        if (ch < 0) {
            d_store[d_store.length()] = 0;
            return 0;
        } else if (ch == '"') {
            /**** Must find the end of the quote ****/
            while (((ch = getChar()) > 0) && (ch != '"')) { 
                d_store += ch; 
            }

            d_store[d_store.length()] = 0;
            return (ch > 0)?d_store.value():0;
        } else if (isTokSep(ch)) {
            d_store[d_store.length()] = 0;
            return d_store.value();
        } 

        d_store += ch;

        ch = getChar();
    } while (1);

    return 0;
}

/********************************************************************
 * getChar()
 ********************************************************************/
char Tokenizer::getChar()
{
    char buf[4];

    if (!d_accObj || d_accObj->eof()) {
        return -1;
    }

    d_accObj->read_bytes((Uint8 *)buf, 1);

    return buf[0];
}




