//------------------------------------------------------------------------------
// File:        MacOSXargv.c
// Description: extract command-line args for a carbon app package.
// Origin:      cut&paste from Apple Developer Support, files
//              macgetargv.c, macgetpath.c, mactoolboxglue.c
// History:     2003iv25, FB, created.
//------------------------------------------------------------------------------

#include "config.h"

#ifdef MAC_OS_X

#include <Carbon/Carbon.h>
#include <unistd.h> // chdir, getcwd
#include <stdlib.h> // getenv, setenv
#include <memory.h> // calloc, malloc

typedef long refcontype;

#define PATHNAMELEN 1024

//------------------------------------------------------------------------------
static int               arg_count;
static char              *arg_vector[256];
static FSSpec            PyMac_ApplicationFSSpec;
static char              PyMac_ApplicationPath[PATHNAMELEN];
static int               got_one; /* Flag that we can stop getting events */
static AEEventHandlerUPP open_doc_upp;
static AEEventHandlerUPP open_app_upp;
static AEEventHandlerUPP not_upp;

//------------------------------------------------------------------------------
static OSErr PyMac_GetFullPathname(FSSpec *fss, char *path, int len)
{	FSRef fsr;
	OSErr err;
	
	*path = '\0';
	err = FSpMakeFSRef(fss, &fsr);
	if ( err == fnfErr ) 
	{	/* FSSpecs can point to non-existing files, fsrefs can't. */
		FSSpec fss2;
		int tocopy;
		
		err = FSMakeFSSpec(fss->vRefNum, fss->parID, "", &fss2);
		if ( err ) return err;
		err = FSpMakeFSRef(&fss2, &fsr);
		if ( err ) return err;
		err = (OSErr)FSRefMakePath(&fsr, path, len-1);
		if ( err ) return err;
		/* This part is not 100% safe: we append the filename part, but
		** I'm not sure that we don't run afoul of the various 8bit
		** encodings here. Will have to look this up at some point...
		*/
		strcat(path, "/");
		tocopy = fss->name[0];
		if ( strlen(path) + tocopy >= len ) tocopy = len - strlen(path) - 1;
		if ( tocopy > 0 ) strncat(path, fss->name+1, tocopy);
	} 
	else 
	{	if ( err ) return err;
		err = (OSErr)FSRefMakePath(&fsr, path, len);
		if ( err ) return err;
	}
	return 0;
}

//------------------------------------------------------------------------------
/* Check that there aren't any args remaining in the event */
static OSErr get_missing_params(const AppleEvent *theAppleEvent)
{	DescType theType;
	Size actualSize;
	OSErr err;
	
	err = AEGetAttributePtr(theAppleEvent, keyMissedKeywordAttr, typeWildCard, &theType, nil, 0, &actualSize);
	if (err == errAEDescNotFound) return noErr;
	else                          return errAEEventNotHandled;
}

//------------------------------------------------------------------------------
/* Handle the Print or Quit events (by failing) */
static pascal OSErr handle_not(const AppleEvent *theAppleEvent, AppleEvent *reply, refcontype refCon)
{
	#pragma unused (reply, refCon)
	got_one = 1;
	return errAEEventNotHandled;
}

//------------------------------------------------------------------------------
/* Handle the Open Application event (by ignoring it) */
static pascal OSErr handle_open_app(const AppleEvent *theAppleEvent, AppleEvent *reply, refcontype refCon)
{
	#pragma unused (reply, refCon)
#if 0
	/* Test by Jack: would removing this facilitate debugging? */
	got_one = 1;
#endif
	return get_missing_params(theAppleEvent);
}

//------------------------------------------------------------------------------
/* Handle the Open Document event, by adding an argument */
static pascal OSErr handle_open_doc(const AppleEvent *theAppleEvent, AppleEvent *reply, refcontype refCon)
{
	#pragma unused (reply, refCon)
	OSErr err;
	AEDescList doclist;
	AEKeyword keywd;
	DescType rttype;
	long i, ndocs, size;
	FSSpec fss;
	char path[PATHNAMELEN];
	char* q;
	
	got_one = 1;
	if ((err = AEGetParamDesc(theAppleEvent, keyDirectObject, typeAEList, &doclist)))
		return err;
	if ((err = get_missing_params(theAppleEvent)))
		return err;
	if ((err = AECountItems(&doclist, &ndocs)))
		return err;

	for(i = 1; i <= ndocs; i++) 
	{	err = AEGetNthPtr(&doclist, i, typeFSS, &keywd, &rttype, &fss, sizeof(fss), &size);
		if (err) break;
		PyMac_GetFullPathname(&fss, path, PATHNAMELEN);
		
		// IVI specific: check for a ".do" file and add "-do" if required
		if (!strcmp(".do", &path[strlen(path)-3]))
		{	arg_vector[arg_count++] = "-do";
		}
		
		// IVI specific: check for ".vcd" and add "-view" if required
		if (!strcmp(".vcd", &path[strlen(path)-4]))
		{	arg_vector[arg_count++] = "-view";
		}
		
		// IVI specific: check for ".sdd" and add "-view" if required
		if (!strcmp(".sdd", &path[strlen(path)-4]))
		{	arg_vector[arg_count++] = "-view";
		}

		arg_vector[arg_count++] = strdup(path);
		
		// IVI specific: whatever file is passed via drag&drop, change to its dir
		for(q= &path[strlen(path)-1]; q>= path; q--)
		{	if (*q == '/')
			{	*q= '\0';
				break;
			}
		}
		chdir(path);
	}
	return err;
}

//------------------------------------------------------------------------------
/* Install standard core event handlers */
static void set_ae_handlers(void)
{	open_doc_upp = NewAEEventHandlerUPP(&handle_open_doc);
	open_app_upp = NewAEEventHandlerUPP(&handle_open_app);
	not_upp =      NewAEEventHandlerUPP(&handle_not);
	
	AEInstallEventHandler(kCoreEventClass, kAEOpenApplication, open_app_upp, 0L, false);
	AEInstallEventHandler(kCoreEventClass, kAEOpenDocuments,   open_doc_upp, 0L, false);
	AEInstallEventHandler(kCoreEventClass, kAEPrintDocuments,  not_upp,      0L, false);
	AEInstallEventHandler(kCoreEventClass, kAEQuitApplication, not_upp,      0L, false);
}

//------------------------------------------------------------------------------
/* Uninstall standard core event handlers */
static void reset_ae_handlers(void)
{	AERemoveEventHandler(kCoreEventClass, kAEOpenApplication, open_app_upp, false);
	AERemoveEventHandler(kCoreEventClass, kAEOpenDocuments,   open_doc_upp, false);
	AERemoveEventHandler(kCoreEventClass, kAEPrintDocuments,  not_upp,      false);
	AERemoveEventHandler(kCoreEventClass, kAEQuitApplication, not_upp,      false);
}

//------------------------------------------------------------------------------
/* Wait for events until a core event has been handled */
static void event_loop(void)
{	EventRecord event;
	int n;
	int ok;
	
	got_one = 0;
	for (n = 0; n < 100 && !got_one; n++) 
	{	ok = GetNextEvent(everyEvent, &event);
		if (ok && event.what == kHighLevelEvent) 
		{	AEProcessAppleEvent(&event);
		}
	}
}

//------------------------------------------------------------------------------
/* Get the argv vector, return argc */
int MacOSXargv(char ***pargv)
{	
#if 1
	// setup IVI_HOME
	// argv[0]=/Simulator/IVI/IVI.app/Contents/MacOS/ivi
	char* IVI_HOME= strdup((*pargv)[0]);
	for (int j= 0; j< 2; j++)
		for (int i= strlen(IVI_HOME)-1; i>0; i--)
		{	if (IVI_HOME[i]=='/')
			{	IVI_HOME[i]='\0';
				break;
			}
		}
	// IVI_HOME=/Simulator/IVI/IVI.app/Contents
	setenv("IVI_HOME", IVI_HOME, 1);
	
	printf("%s: IVI_HOME = %s\n", "MacOSXargv.cc", getenv("IVI_HOME"));
#endif

#if 1
	// setup PATH
	char* SIMUL= strdup(IVI_HOME);
	for (int l= 0; l< 3; l++)
		for (int m= strlen(SIMUL)-1; m>0 ; m--)
		{	if (SIMUL[m]=='/')
			{	SIMUL[m]='\0';
				break;
			}
		}
	const char* PATH1= getenv("PATH");
	const char* PATH2= "/Icarus/bin:";
	const char* PATH3= "/GHDL/bin:";
	char* PATH4= (char*)malloc(strlen(PATH1)+2*strlen(IVI_HOME)
		+    strlen(PATH2)+strlen(PATH3)+1);
	sprintf(PATH4, "%s%s%s%s%s", SIMUL, PATH2, SIMUL, PATH3, PATH1);
	setenv("PATH", PATH4, 1);
	printf("%s: PATH = %s\n", "MacOSXargv.cc", getenv("PATH"));
#endif

#if 1
	// setup TCLLIBPATH
	char* TCLLIBPATH= (char*)malloc(strlen(IVI_HOME)+10);
	sprintf(TCLLIBPATH, "%s/lib", IVI_HOME);
	setenv("TCLLIBPATH", TCLLIBPATH, 1);
#endif
	
	arg_count = 0;
	int i;
	
	/* In an OSX bundle argv[0] is okay */
	//arg_vector[arg_count++]= argv[0];
	arg_vector[arg_count++]= (*pargv)[0];
	//arg_count++;
	
//	if( !noevents ) 
	{	set_ae_handlers();
		event_loop();
		reset_ae_handlers();
	}
	
	arg_vector[arg_count] = NULL;

#if 0
	for(i=0; i< arg_count; i++)
	{	printf("%2d: \"%s\"\n", i, arg_vector[i]);
	}
#endif

	*pargv = arg_vector;
	return arg_count;
}

#endif // #ifdef MAC_OS_X

//------------------------------------------------------------------------------
// end of file
