/****************************************************************************
 *                             VVPRemoteSim.cc
 *
 * Author: Matthew Ballance
 * Desc:   Implements the IviSim interface for the IVI side of the VVP 
 *         simulator interface
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "VVPRemoteSim.h"
#include <stdlib.h>
#include <stdio.h>
#include "ivi_print.h"

/********************************************************************
 * VVPRemoteSim()
 ********************************************************************/
VVPRemoteSim::VVPRemoteSim(Tcl_Interp *interp, int argc, char **argv) :
    IviRemoteSim(interp, argc, argv)
{
}

/********************************************************************
 * ~VVPRemoteSim()
 ********************************************************************/
VVPRemoteSim::~VVPRemoteSim()
{
}

/********************************************************************
 * LoadDesign()
 ********************************************************************/
int VVPRemoteSim::LoadDesign(char *design_path)
{
    char         *ivi_home = getenv("IVI_HOME");
    String        cmd;
    int           ret;
    FILE         *fp;

#if 0
    cmd =  ivi_home;
    cmd += "/bin/vvp";
#else
    cmd = "vvp";
#endif

#if 0
    /**** If vvp isn't installed in IVI_HOME, then use the path ****/
    if (!(fp = fopen(cmd.value(), "r"))) {
        cmd = "vvp";
    } else {
        fclose(fp);
    }
#endif

    cmd  = "vvp";

    cmd += " -m ";
    cmd += ivi_home;
    cmd += "/modules/vvp_remote_sim/vvp_remote.vpi ";
    cmd += design_path;


/*** Debug... ***/
#if 0
    cmd = "c:/mingw/bin/gdb.exe ";
    cmd += ivi_home;
    cmd += "/bin/vvp";

    ivi_print("-m c:\\msys\\1.0\\home\\ballance\\bld_0.4-winport\\ivi_home\\modules\\vvp_remote_sim\\vvp_remote.vpi\n");
#endif

    /*** On windows, need to translate the '/' path separators
     *** to '\' path separators... Otherwise, CreateProcess doesn't
     *** work...
     ***/
#ifdef __MINGW32__
    {
        char *p = cmd.value();
        while (*p) {
            if (*p == '/') {
                *p = '\\';
            }
            p++;
        }
    }
#endif

    ret = StartSimulator(cmd.value());

    return ret;
}

