#ifndef LOG_H
#define LOG_H

#include <stdarg.h>

#define LOG_QUIET		0
#define LOG_ERROR		(LOG_QUIET + 1)
#define LOG_WARNING		(LOG_ERROR + 1)
#define LOG_NORMAL		(LOG_WARNING + 1)
#define LOG_VERBOSE		(LOG_NORMAL + 1)
#ifdef DEBUG
#define LOG_DEBUG		(LOG_VERBOSE + 1)
#define LOG_NOISY		(LOG_DEBUG + 1)
#endif

/* initialize logging */
extern void log_init (int level);

/* close logging. any calls to log_printf() after this call is undefined */
extern void log_close ();

/* closes and reopens the log file if necessary */
extern void log_reset ();

/* print a message to the log file */
extern void log_printf_stub (int level,const char *file,const char *function,int line,const char *fmt, ...);

/* print a message to the log file */
extern void log_vprintf_stub (int level,const char *file,const char *function,int line,const char *fmt,va_list ap);

#define log_printf(level,fmt,args...) (log_printf_stub (level,__FILE__,__FUNCTION__,__LINE__,fmt,## args))
#define log_vprintf(level,fmt,args...) (log_vprintf_stub (level,__FILE__,__FUNCTION__,__LINE__,fmt,ap))

#ifdef DEBUG
#define BREAKPOINT() log_printf(LOG_DEBUG,"%d: BREAKPOINT\n",__LINE__)
#endif

#endif
