/*
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   MODULE_NAME:		fsckmsgp.h
 *
 *   COMPONENT_NAME: 	jfs utilities
 *
 */
#ifndef H_FSCKMSGP
#define H_FSCKMSGP

#include "xfsck.h"

/***********************************************************************
 *
 * The message protocol array entries are used to control fsck message
 * traffic and permission (to perform a repair) protocol in compliance
 * with the parameters with which fsck was invoked.
 *
 *  See xfsck.h for declarations of the symbolic constants used
 *              in the following table and to access the following
 *              table.
 */
int16_t MsgProtocol[fsck_highest_msgid_defined+1][3]={

/*  msg   output      messaging    local lang   */
/*  id    stream        level       msg file    */
/* ----  ---------  -------------  ------------ */
/*  0*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*  1*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*  2*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*  3*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*  4*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*  5*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*  6*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*  7*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*  8*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*  9*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 10*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 11*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 12*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 13*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 14*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 15*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 16*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 17*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 18*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 19*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 20*/ { fsck_err  ,fsck_debug    ,no_msgfile  },
/* 21*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 22*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 23*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 24*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 25*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 26*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 27*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 28*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 29*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 30*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 31*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 32*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 33*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 34*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 35*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 36*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 37*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 38*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 39*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 40*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 41*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 42*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 43*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 44*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 45*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 46*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 47*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 48*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 49*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/* 50*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 51*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 52*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 53*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 54*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 55*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 56*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 57*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 58*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 59*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 60*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 61*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 62*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 63*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 64*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 65*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/* 66*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 67*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 68*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 69*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 70*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 71*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 72*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 73*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 74*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 75*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 76*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 77*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 78*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 79*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 80*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 81*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 82*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 83*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 84*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 85*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 86*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 87*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 88*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 89*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 90*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 91*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 92*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 93*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 94*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/* 95*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 96*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/* 97*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/* 98*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/* 99*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },

/*100*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*101*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*102*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*103*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*104*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*105*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*106*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*107*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*108*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*109*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*110*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*111*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*112*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*113*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*114*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*115*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*116*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile }, 
/*117*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile }, 
/*118*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile }, 
/*119*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*120*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*121*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*122*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*123*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*124*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*125*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*126*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*127*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*128*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*129*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*130*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*131*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*132*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*133*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*134*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*135*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*136*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*137*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*138*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*139*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*140*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*141*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*142*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*143*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*144*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile }, 
/*145*/ { fsck_out  ,fsck_autochk  ,jfs_msgfile }, 
/*146*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*147*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*148*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*149*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*150*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*151*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*152*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*153*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*154*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*155*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*156*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*157*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*158*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*159*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*160*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*161*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*162*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*163*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*164*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*165*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*166*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*167*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*168*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*169*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*170*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*171*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile }, 
/*172*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*173*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*174*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*175*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*176*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*177*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*178*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*179*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*180*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*181*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*182*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*183*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*184*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*185*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*186*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*187*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*188*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*189*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*190*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*191*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*192*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*193*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*194*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*195*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*196*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*197*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*198*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*199*/ { fsck_out  ,fsck_debug    ,no_msgfile  },

/*200*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*201*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*202*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*203*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*204*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*205*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*206*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*207*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*208*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*209*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*210*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*211*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*212*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*213*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*214*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*215*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*216*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*217*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*218*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*219*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*220*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*221*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*222*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*223*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*224*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*225*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*226*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*227*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*228*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*229*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*230*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*231*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*232*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*233*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*234*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*235*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*236*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*237*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*238*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*239*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*240*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*241*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*242*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*243*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*244*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*245*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*246*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*247*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*248*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*249*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*250*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*251*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*252*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*253*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*254*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*255*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*256*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*257*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*258*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*259*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*260*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*261*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*262*/ { fsck_out  ,fsck_hrtbt    ,no_msgfile  },
/*263*/ { fsck_out  ,fsck_hrtbt    ,no_msgfile  },
/*264*/ { fsck_out  ,fsck_hrtbt    ,no_msgfile  },
/*265*/ { fsck_out  ,fsck_hrtbt    ,no_msgfile  },
/*266*/ { fsck_out  ,fsck_hrtbt    ,no_msgfile  },
/*267*/ { fsck_out  ,fsck_hrtbt    ,no_msgfile  },
/*268*/ { fsck_out  ,fsck_hrtbt    ,no_msgfile  },
/*269*/ { fsck_out  ,fsck_hrtbt    ,no_msgfile  },
/*270*/ { fsck_out  ,fsck_hrtbt    ,no_msgfile  },
/*271*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile }, 
/*272*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile }, 
/*273*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*274*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*275*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*276*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*277*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*278*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*279*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*280*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*281*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*282*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*283*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*284*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*285*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*286*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*287*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*288*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*289*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*290*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*291*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*292*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*293*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*294*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*295*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*296*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*297*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*298*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*299*/ { fsck_out  ,fsck_debug    ,no_msgfile  },

/*300*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*301*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*302*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*303*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*304*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*305*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*306*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*307*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*308*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*309*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*310*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*311*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*312*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*313*/ { fsck_out  ,fsck_quiet    ,no_msgfile  },
/*314*/ { fsck_out  ,fsck_quiet    ,no_msgfile  },
/*315*/ { fsck_out  ,fsck_quiet    ,no_msgfile  },
/*316*/ { fsck_out  ,fsck_quiet    ,no_msgfile  },
/*317*/ { fsck_out  ,fsck_quiet    ,no_msgfile  },
/*318*/ { fsck_out  ,fsck_quiet    ,no_msgfile  },
/*319*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*320*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*321*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*322*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*323*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*324*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*325*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*326*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*327*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*328*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*329*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*330*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*331*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*332*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*333*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*334*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*335*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*336*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*337*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*338*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*339*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*340*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*341*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*342*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*343*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*344*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*345*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*346*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*347*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*348*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*349*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*350*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*351*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*352*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile }, 
/*353*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*354*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*355*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*356*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*357*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*358*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*359*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*360*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*361*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*362*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*363*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*364*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*365*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*366*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*367*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*368*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*369*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*370*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*371*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile },
/*372*/ { fsck_out  ,fsck_quiet    ,jfs_msgfile }, 
/*373*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*374*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*375*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*376*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*377*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*378*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*379*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*380*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*381*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*382*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*383*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*384*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*385*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*386*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*387*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*388*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*389*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile }, 
/*390*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*391*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*392*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*393*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*394*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*395*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*396*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*397*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*398*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile },
/*399*/ { fsck_out  ,fsck_txtins   ,jfs_msgfile }, 

/*400*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*401*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*402*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*403*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*404*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*405*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*406*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*407*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*408*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*409*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*410*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*411*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*412*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*413*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*414*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*415*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*416*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*417*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*418*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*419*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*420*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*421*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*422*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*423*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*424*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*425*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*426*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*427*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*428*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*429*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*430*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*431*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*432*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*433*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*434*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*435*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*436*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*437*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*438*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*439*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*440*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*441*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*442*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*443*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*444*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*445*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*446*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*447*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*448*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*449*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*450*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*451*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*452*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*453*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*454*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*455*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*456*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*457*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*458*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*459*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*460*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*461*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*462*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*463*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*464*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*465*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*466*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*467*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*468*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*469*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*470*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*471*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*472*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*473*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*474*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*475*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*477*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*478*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*479*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*480*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*481*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*482*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*483*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*484*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*485*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*486*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*487*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*488*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*489*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*490*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*491*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*492*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*493*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*494*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*495*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*496*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*497*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*498*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*499*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 

/*500*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*501*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*502*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*503*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*504*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*505*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*506*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*507*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*508*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*509*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*510*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*511*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*512*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*513*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*514*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*515*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*516*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*517*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*518*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*519*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*520*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*521*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*522*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*523*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*524*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*525*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*526*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*527*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*528*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*529*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*530*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*531*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*532*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*533*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*534*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*535*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*536*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*537*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*538*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*539*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*540*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*541*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*542*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*543*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*544*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*545*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*546*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*547*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*548*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*549*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*550*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*551*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*552*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*553*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*554*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*555*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*556*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*557*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*558*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*559*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*560*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*561*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*562*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*563*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*564*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*565*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*566*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*567*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*568*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*569*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*570*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*571*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*572*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*573*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*574*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*575*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*576*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*577*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*578*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*579*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*580*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*581*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*582*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*583*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*584*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*585*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*586*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*587*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*588*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*589*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*590*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*591*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*592*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*593*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*594*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*595*/ { fsck_out  ,fsck_debug    ,no_msgfile  }, 
/*596*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*597*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*598*/ { fsck_out  ,fsck_debug    ,no_msgfile  },
/*599*/ { fsck_out  ,fsck_debug    ,no_msgfile  }

    };

#endif

