#ifndef K3DSDK_IVIEWPORT_HOST_H
#define K3DSDK_IVIEWPORT_HOST_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares k3d::iviewport_host, an abstract interface for an object that can host (provide position and projection information to) a viewport
		\author Tim Shead (tshead@k-3d.com)
*/

#include "iunknown.h"
#include "signal_system.h"
#include <sdpgl/sdpgl.h>
#include <vector>

namespace k3d
{

// Forward declarations
class iprojection;

/// Abstract interface for objects that can host (provide position and projection information to) a viewport
class iviewport_host :
	public virtual iunknown
{
public:
	/// Gives the host a chance to (optionally) constrain the requested screen aspect ratio
	virtual void constrain_screen_aspect_ratio(double& Ratio) = 0;
	/// Returns the (optional) 3D-to-2D projection for this host
	virtual iprojection* projection() = 0;

	/// Defines a signal that will be emitted if the requested screen aspect ratio changes
	typedef SigC::Signal0<void> aspect_ratio_changed_signal_t;
	virtual aspect_ratio_changed_signal_t& aspect_ratio_changed_signal() = 0;
		
protected:
	iviewport_host() {}
	iviewport_host(const iviewport_host& RHS) {}
	iviewport_host& operator=(const iviewport_host& RHS) { return *this; }
	virtual ~iviewport_host() {}
};

} // namespace k3d

#endif // K3DSDK_IVIEWPORT_HOST_H

