#ifndef SDPGL_TRACE_ENABLED_PRIVATE_H
#define SDPGL_TRACE_ENABLED_PRIVATE_H

// SDPGL
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include <iosfwd>
#include <string>

namespace sdpgl
{

namespace implementation_private
{

void set_stream(std::ostream& Stream);
void push_trace(bool State);
void pop_trace();
void trace(const std::string Text);

void Accum (GLenum op, GLfloat value);
void AlphaFunc (GLenum func, GLclampf ref);
GLboolean AreTexturesResident (GLsizei n, const GLuint *textures, GLboolean *residences);
void ArrayElement (GLint i);
void Begin (GLenum mode);
void BindTexture (GLenum target, GLuint texture);
void Bitmap (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
void BlendFunc (GLenum sfactor, GLenum dfactor);
void CallList (GLuint list);
void CallLists (GLsizei n, GLenum type, const GLvoid *lists);
void Clear (GLbitfield mask);
void ClearAccum (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void ClearColor (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
void ClearDepth (GLclampd depth);
void ClearIndex (GLfloat c);
void ClearStencil (GLint s);
void ClipPlane (GLenum plane, const GLdouble *equation);
void Color3b (GLbyte red, GLbyte green, GLbyte blue);
void Color3bv (const GLbyte *v);
void Color3d (GLdouble red, GLdouble green, GLdouble blue);
void Color3dv (const GLdouble *v);
void Color3f (GLfloat red, GLfloat green, GLfloat blue);
void Color3fv (const GLfloat *v);
void Color3i (GLint red, GLint green, GLint blue);
void Color3iv (const GLint *v);
void Color3s (GLshort red, GLshort green, GLshort blue);
void Color3sv (const GLshort *v);
void Color3ub (GLubyte red, GLubyte green, GLubyte blue);
void Color3ubv (const GLubyte *v);
void Color3ui (GLuint red, GLuint green, GLuint blue);
void Color3uiv (const GLuint *v);
void Color3us (GLushort red, GLushort green, GLushort blue);
void Color3usv (const GLushort *v);
void Color4b (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
void Color4bv (const GLbyte *v);
void Color4d (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
void Color4dv (const GLdouble *v);
void Color4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void Color4fv (const GLfloat *v);
void Color4i (GLint red, GLint green, GLint blue, GLint alpha);
void Color4iv (const GLint *v);
void Color4s (GLshort red, GLshort green, GLshort blue, GLshort alpha);
void Color4sv (const GLshort *v);
void Color4ub (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
void Color4ubv (const GLubyte *v);
void Color4ui (GLuint red, GLuint green, GLuint blue, GLuint alpha);
void Color4uiv (const GLuint *v);
void Color4us (GLushort red, GLushort green, GLushort blue, GLushort alpha);
void Color4usv (const GLushort *v);
void ColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
void ColorMaterial (GLenum face, GLenum mode);
void ColorPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void CopyPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
void CopyTexImage1D (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border);
void CopyTexImage2D (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
void CopyTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
void CopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void CullFace (GLenum mode);
void DeleteLists (GLuint list, GLsizei range);
void DeleteTextures (GLsizei n, const GLuint *textures);
void DepthFunc (GLenum func);
void DepthMask (GLboolean flag);
void DepthRange (GLclampd zNear, GLclampd zFar);
void Disable (GLenum cap);
void DisableClientState (GLenum array);
void DrawArrays (GLenum mode, GLint first, GLsizei count);
void DrawBuffer (GLenum mode);
void DrawElements (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
void DrawPixels (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void EdgeFlag (GLboolean flag);
void EdgeFlagPointer (GLsizei stride, const GLvoid *pointer);
void EdgeFlagv (const GLboolean *flag);
void Enable (GLenum cap);
void EnableClientState (GLenum array);
void End (void);
void EndList (void);
void EvalCoord1d (GLdouble u);
void EvalCoord1dv (const GLdouble *u);
void EvalCoord1f (GLfloat u);
void EvalCoord1fv (const GLfloat *u);
void EvalCoord2d (GLdouble u, GLdouble v);
void EvalCoord2dv (const GLdouble *u);
void EvalCoord2f (GLfloat u, GLfloat v);
void EvalCoord2fv (const GLfloat *u);
void EvalMesh1 (GLenum mode, GLint i1, GLint i2);
void EvalMesh2 (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
void EvalPoint1 (GLint i);
void EvalPoint2 (GLint i, GLint j);
void FeedbackBuffer (GLsizei size, GLenum type, GLfloat *buffer);
void Finish (void);
void Flush (void);
void Fogf (GLenum pname, GLfloat param);
void Fogfv (GLenum pname, const GLfloat *params);
void Fogi (GLenum pname, GLint param);
void Fogiv (GLenum pname, const GLint *params);
void FrontFace (GLenum mode);
void Frustum (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
GLuint GenLists (GLsizei range);
void GenTextures (GLsizei n, GLuint *textures);
void GetBooleanv (GLenum pname, GLboolean *params);
void GetClipPlane (GLenum plane, GLdouble *equation);
void GetDoublev (GLenum pname, GLdouble *params);
GLenum GetError (void);
void GetFloatv (GLenum pname, GLfloat *params);
void GetIntegerv (GLenum pname, GLint *params);
void GetLightfv (GLenum light, GLenum pname, GLfloat *params);
void GetLightiv (GLenum light, GLenum pname, GLint *params);
void GetMapdv (GLenum target, GLenum query, GLdouble *v);
void GetMapfv (GLenum target, GLenum query, GLfloat *v);
void GetMapiv (GLenum target, GLenum query, GLint *v);
void GetMaterialfv (GLenum face, GLenum pname, GLfloat *params);
void GetMaterialiv (GLenum face, GLenum pname, GLint *params);
void GetPixelMapfv (GLenum map, GLfloat *values);
void GetPixelMapuiv (GLenum map, GLuint *values);
void GetPixelMapusv (GLenum map, GLushort *values);
void GetPointerv (GLenum pname, GLvoid* *params);
void GetPolygonStipple (GLubyte *mask);
const GLubyte* GetString (GLenum name);
void GetTexEnvfv (GLenum target, GLenum pname, GLfloat *params);
void GetTexEnviv (GLenum target, GLenum pname, GLint *params);
void GetTexGendv (GLenum coord, GLenum pname, GLdouble *params);
void GetTexGenfv (GLenum coord, GLenum pname, GLfloat *params);
void GetTexGeniv (GLenum coord, GLenum pname, GLint *params);
void GetTexImage (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
void GetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat *params);
void GetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint *params);
void GetTexParameterfv (GLenum target, GLenum pname, GLfloat *params);
void GetTexParameteriv (GLenum target, GLenum pname, GLint *params);
void Hint (GLenum target, GLenum mode);
void IndexMask (GLuint mask);
void IndexPointer (GLenum type, GLsizei stride, const GLvoid *pointer);
void Indexd (GLdouble c);
void Indexdv (const GLdouble *c);
void Indexf (GLfloat c);
void Indexfv (const GLfloat *c);
void Indexi (GLint c);
void Indexiv (const GLint *c);
void Indexs (GLshort c);
void Indexsv (const GLshort *c);
void Indexub (GLubyte c);
void Indexubv (const GLubyte *c);
void InitNames (void);
void InterleavedArrays (GLenum format, GLsizei stride, const GLvoid *pointer);
GLboolean IsEnabled (GLenum cap);
GLboolean IsList (GLuint list);
GLboolean IsTexture (GLuint texture);
void LightModelf (GLenum pname, GLfloat param);
void LightModelfv (GLenum pname, const GLfloat *params);
void LightModeli (GLenum pname, GLint param);
void LightModeliv (GLenum pname, const GLint *params);
void Lightf (GLenum light, GLenum pname, GLfloat param);
void Lightfv (GLenum light, GLenum pname, const GLfloat *params);
void Lighti (GLenum light, GLenum pname, GLint param);
void Lightiv (GLenum light, GLenum pname, const GLint *params);
void LineStipple (GLint factor, GLushort pattern);
void LineWidth (GLfloat width);
void ListBase (GLuint base);
void LoadIdentity (void);
void LoadMatrixd (const GLdouble *m);
void LoadMatrixf (const GLfloat *m);
void LoadName (GLuint name);
void LogicOp (GLenum opcode);
void Map1d (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
void Map1f (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
void Map2d (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
void Map2f (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
void MapGrid1d (GLint un, GLdouble u1, GLdouble u2);
void MapGrid1f (GLint un, GLfloat u1, GLfloat u2);
void MapGrid2d (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
void MapGrid2f (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
void Materialf (GLenum face, GLenum pname, GLfloat param);
void Materialfv (GLenum face, GLenum pname, const GLfloat *params);
void Materiali (GLenum face, GLenum pname, GLint param);
void Materialiv (GLenum face, GLenum pname, const GLint *params);
void MatrixMode (GLenum mode);
void MultMatrixd (const GLdouble *m);
void MultMatrixf (const GLfloat *m);
void NewList (GLuint list, GLenum mode);
void Normal3b (GLbyte nx, GLbyte ny, GLbyte nz);
void Normal3bv (const GLbyte *v);
void Normal3d (GLdouble nx, GLdouble ny, GLdouble nz);
void Normal3dv (const GLdouble *v);
void Normal3f (GLfloat nx, GLfloat ny, GLfloat nz);
void Normal3fv (const GLfloat *v);
void Normal3i (GLint nx, GLint ny, GLint nz);
void Normal3iv (const GLint *v);
void Normal3s (GLshort nx, GLshort ny, GLshort nz);
void Normal3sv (const GLshort *v);
void NormalPointer (GLenum type, GLsizei stride, const GLvoid *pointer);
void Ortho (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
void PassThrough (GLfloat token);
void PixelMapfv (GLenum map, GLsizei mapsize, const GLfloat *values);
void PixelMapuiv (GLenum map, GLsizei mapsize, const GLuint *values);
void PixelMapusv (GLenum map, GLsizei mapsize, const GLushort *values);
void PixelStoref (GLenum pname, GLfloat param);
void PixelStorei (GLenum pname, GLint param);
void PixelTransferf (GLenum pname, GLfloat param);
void PixelTransferi (GLenum pname, GLint param);
void PixelZoom (GLfloat xfactor, GLfloat yfactor);
void PointSize (GLfloat size);
void PolygonMode (GLenum face, GLenum mode);
void PolygonOffset (GLfloat factor, GLfloat units);
void PolygonStipple (const GLubyte *mask);
void PopAttrib (void);
void PopClientAttrib (void);
void PopMatrix (void);
void PopName (void);
void PrioritizeTextures (GLsizei n, const GLuint *textures, const GLclampf *priorities);
void PushAttrib (GLbitfield mask);
void PushClientAttrib (GLbitfield mask);
void PushMatrix (void);
void PushName (GLuint name);
void RasterPos2d (GLdouble x, GLdouble y);
void RasterPos2dv (const GLdouble *v);
void RasterPos2f (GLfloat x, GLfloat y);
void RasterPos2fv (const GLfloat *v);
void RasterPos2i (GLint x, GLint y);
void RasterPos2iv (const GLint *v);
void RasterPos2s (GLshort x, GLshort y);
void RasterPos2sv (const GLshort *v);
void RasterPos3d (GLdouble x, GLdouble y, GLdouble z);
void RasterPos3dv (const GLdouble *v);
void RasterPos3f (GLfloat x, GLfloat y, GLfloat z);
void RasterPos3fv (const GLfloat *v);
void RasterPos3i (GLint x, GLint y, GLint z);
void RasterPos3iv (const GLint *v);
void RasterPos3s (GLshort x, GLshort y, GLshort z);
void RasterPos3sv (const GLshort *v);
void RasterPos4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void RasterPos4dv (const GLdouble *v);
void RasterPos4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void RasterPos4fv (const GLfloat *v);
void RasterPos4i (GLint x, GLint y, GLint z, GLint w);
void RasterPos4iv (const GLint *v);
void RasterPos4s (GLshort x, GLshort y, GLshort z, GLshort w);
void RasterPos4sv (const GLshort *v);
void ReadBuffer (GLenum mode);
void ReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
void Rectd (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
void Rectdv (const GLdouble *v1, const GLdouble *v2);
void Rectf (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
void Rectfv (const GLfloat *v1, const GLfloat *v2);
void Recti (GLint x1, GLint y1, GLint x2, GLint y2);
void Rectiv (const GLint *v1, const GLint *v2);
void Rects (GLshort x1, GLshort y1, GLshort x2, GLshort y2);
void Rectsv (const GLshort *v1, const GLshort *v2);
GLint RenderMode (GLenum mode);
void Rotated (GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
void Rotatef (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
void Scaled (GLdouble x, GLdouble y, GLdouble z);
void Scalef (GLfloat x, GLfloat y, GLfloat z);
void Scissor (GLint x, GLint y, GLsizei width, GLsizei height);
void SelectBuffer (GLsizei size, GLuint *buffer);
void ShadeModel (GLenum mode);
void StencilFunc (GLenum func, GLint ref, GLuint mask);
void StencilMask (GLuint mask);
void StencilOp (GLenum fail, GLenum zfail, GLenum zpass);
void TexCoord1d (GLdouble s);
void TexCoord1dv (const GLdouble *v);
void TexCoord1f (GLfloat s);
void TexCoord1fv (const GLfloat *v);
void TexCoord1i (GLint s);
void TexCoord1iv (const GLint *v);
void TexCoord1s (GLshort s);
void TexCoord1sv (const GLshort *v);
void TexCoord2d (GLdouble s, GLdouble t);
void TexCoord2dv (const GLdouble *v);
void TexCoord2f (GLfloat s, GLfloat t);
void TexCoord2fv (const GLfloat *v);
void TexCoord2i (GLint s, GLint t);
void TexCoord2iv (const GLint *v);
void TexCoord2s (GLshort s, GLshort t);
void TexCoord2sv (const GLshort *v);
void TexCoord3d (GLdouble s, GLdouble t, GLdouble r);
void TexCoord3dv (const GLdouble *v);
void TexCoord3f (GLfloat s, GLfloat t, GLfloat r);
void TexCoord3fv (const GLfloat *v);
void TexCoord3i (GLint s, GLint t, GLint r);
void TexCoord3iv (const GLint *v);
void TexCoord3s (GLshort s, GLshort t, GLshort r);
void TexCoord3sv (const GLshort *v);
void TexCoord4d (GLdouble s, GLdouble t, GLdouble r, GLdouble q);
void TexCoord4dv (const GLdouble *v);
void TexCoord4f (GLfloat s, GLfloat t, GLfloat r, GLfloat q);
void TexCoord4fv (const GLfloat *v);
void TexCoord4i (GLint s, GLint t, GLint r, GLint q);
void TexCoord4iv (const GLint *v);
void TexCoord4s (GLshort s, GLshort t, GLshort r, GLshort q);
void TexCoord4sv (const GLshort *v);
void TexCoordPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void TexEnvf (GLenum target, GLenum pname, GLfloat param);
void TexEnvfv (GLenum target, GLenum pname, const GLfloat *params);
void TexEnvi (GLenum target, GLenum pname, GLint param);
void TexEnviv (GLenum target, GLenum pname, const GLint *params);
void TexGend (GLenum coord, GLenum pname, GLdouble param);
void TexGendv (GLenum coord, GLenum pname, const GLdouble *params);
void TexGenf (GLenum coord, GLenum pname, GLfloat param);
void TexGenfv (GLenum coord, GLenum pname, const GLfloat *params);
void TexGeni (GLenum coord, GLenum pname, GLint param);
void TexGeniv (GLenum coord, GLenum pname, const GLint *params);
void TexImage1D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void TexImage2D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void TexParameterf (GLenum target, GLenum pname, GLfloat param);
void TexParameterfv (GLenum target, GLenum pname, const GLfloat *params);
void TexParameteri (GLenum target, GLenum pname, GLint param);
void TexParameteriv (GLenum target, GLenum pname, const GLint *params);
void TexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
void TexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void Translated (GLdouble x, GLdouble y, GLdouble z);
void Translatef (GLfloat x, GLfloat y, GLfloat z);
void Vertex2d (GLdouble x, GLdouble y);
void Vertex2dv (const GLdouble *v);
void Vertex2f (GLfloat x, GLfloat y);
void Vertex2fv (const GLfloat *v);
void Vertex2i (GLint x, GLint y);
void Vertex2iv (const GLint *v);
void Vertex2s (GLshort x, GLshort y);
void Vertex2sv (const GLshort *v);
void Vertex3d (GLdouble x, GLdouble y, GLdouble z);
void Vertex3dv (const GLdouble *v);
void Vertex3f (GLfloat x, GLfloat y, GLfloat z);
void Vertex3fv (const GLfloat *v);
void Vertex3i (GLint x, GLint y, GLint z);
void Vertex3iv (const GLint *v);
void Vertex3s (GLshort x, GLshort y, GLshort z);
void Vertex3sv (const GLshort *v);
void Vertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void Vertex4dv (const GLdouble *v);
void Vertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void Vertex4fv (const GLfloat *v);
void Vertex4i (GLint x, GLint y, GLint z, GLint w);
void Vertex4iv (const GLint *v);
void Vertex4s (GLshort x, GLshort y, GLshort z, GLshort w);
void Vertex4sv (const GLshort *v);
void VertexPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void Viewport (GLint x, GLint y, GLsizei width, GLsizei height);

} // namespace implementation_private

} // namespace sdpgl

// Hijack OpenGL calls ...
#define glAccum sdpgl::implementation_private::Accum
#define glAlphaFunc sdpgl::implementation_private::AlphaFunc
#define glAreTexturesResident sdpgl::implementation_private::AreTexturesResident
#define glArrayElement sdpgl::implementation_private::ArrayElement
#define glBegin sdpgl::implementation_private::Begin
#define glBindTexture sdpgl::implementation_private::BindTexture
#define glBitmap sdpgl::implementation_private::Bitmap
#define glBlendFunc sdpgl::implementation_private::BlendFunc
#define glCallList sdpgl::implementation_private::CallList
#define glCallLists sdpgl::implementation_private::CallLists
#define glClear sdpgl::implementation_private::Clear
#define glClearAccum sdpgl::implementation_private::ClearAccum
#define glClearColor sdpgl::implementation_private::ClearColor
#define glClearDepth sdpgl::implementation_private::ClearDepth
#define glClearIndex sdpgl::implementation_private::ClearIndex
#define glClearStencil sdpgl::implementation_private::ClearStencil
#define glClipPlane sdpgl::implementation_private::ClipPlane
#define glColor3b sdpgl::implementation_private::Color3b
#define glColor3bv sdpgl::implementation_private::Color3bv
#define glColor3d sdpgl::implementation_private::Color3d
#define glColor3dv sdpgl::implementation_private::Color3dv
#define glColor3f sdpgl::implementation_private::Color3f
#define glColor3fv sdpgl::implementation_private::Color3fv
#define glColor3i sdpgl::implementation_private::Color3i
#define glColor3iv sdpgl::implementation_private::Color3iv
#define glColor3s sdpgl::implementation_private::Color3s
#define glColor3sv sdpgl::implementation_private::Color3sv
#define glColor3ub sdpgl::implementation_private::Color3ub
#define glColor3ubv sdpgl::implementation_private::Color3ubv
#define glColor3ui sdpgl::implementation_private::Color3ui
#define glColor3uiv sdpgl::implementation_private::Color3uiv
#define glColor3us sdpgl::implementation_private::Color3us
#define glColor3usv sdpgl::implementation_private::Color3usv
#define glColor4b sdpgl::implementation_private::Color4b
#define glColor4bv sdpgl::implementation_private::Color4bv
#define glColor4d sdpgl::implementation_private::Color4d
#define glColor4dv sdpgl::implementation_private::Color4dv
#define glColor4f sdpgl::implementation_private::Color4f
#define glColor4fv sdpgl::implementation_private::Color4fv
#define glColor4i sdpgl::implementation_private::Color4i
#define glColor4iv sdpgl::implementation_private::Color4iv
#define glColor4s sdpgl::implementation_private::Color4s
#define glColor4sv sdpgl::implementation_private::Color4sv
#define glColor4ub sdpgl::implementation_private::Color4ub
#define glColor4ubv sdpgl::implementation_private::Color4ubv
#define glColor4ui sdpgl::implementation_private::Color4ui
#define glColor4uiv sdpgl::implementation_private::Color4uiv
#define glColor4us sdpgl::implementation_private::Color4us
#define glColor4usv sdpgl::implementation_private::Color4usv
#define glColorMask sdpgl::implementation_private::ColorMask
#define glColorMaterial sdpgl::implementation_private::ColorMaterial
#define glColorPointer sdpgl::implementation_private::ColorPointer
#define glCopyPixels sdpgl::implementation_private::CopyPixels
#define glCopyTexImage1D sdpgl::implementation_private::CopyTexImage1D
#define glCopyTexImage2D sdpgl::implementation_private::CopyTexImage2D
#define glCopyTexSubImage1D sdpgl::implementation_private::CopyTexSubImage1D
#define glCopyTexSubImage2D sdpgl::implementation_private::CopyTexSubImage2D
#define glCullFace sdpgl::implementation_private::CullFace
#define glDeleteLists sdpgl::implementation_private::DeleteLists
#define glDeleteTextures sdpgl::implementation_private::DeleteTextures
#define glDepthFunc sdpgl::implementation_private::DepthFunc
#define glDepthMask sdpgl::implementation_private::DepthMask
#define glDepthRange sdpgl::implementation_private::DepthRange
#define glDisable sdpgl::implementation_private::Disable
#define glDisableClientState sdpgl::implementation_private::DisableClientState
#define glDrawArrays sdpgl::implementation_private::DrawArrays
#define glDrawBuffer sdpgl::implementation_private::DrawBuffer
#define glDrawElements sdpgl::implementation_private::DrawElements
#define glDrawPixels sdpgl::implementation_private::DrawPixels
#define glEdgeFlag sdpgl::implementation_private::EdgeFlag
#define glEdgeFlagPointer sdpgl::implementation_private::EdgeFlagPointer
#define glEdgeFlagv sdpgl::implementation_private::EdgeFlagv
#define glEnable sdpgl::implementation_private::Enable
#define glEnableClientState sdpgl::implementation_private::EnableClientState
#define glEnd sdpgl::implementation_private::End
#define glEndList sdpgl::implementation_private::EndList
#define glEvalCoord1d sdpgl::implementation_private::EvalCoord1d
#define glEvalCoord1dv sdpgl::implementation_private::EvalCoord1dv
#define glEvalCoord1f sdpgl::implementation_private::EvalCoord1f
#define glEvalCoord1fv sdpgl::implementation_private::EvalCoord1fv
#define glEvalCoord2d sdpgl::implementation_private::EvalCoord2d
#define glEvalCoord2dv sdpgl::implementation_private::EvalCoord2dv
#define glEvalCoord2f sdpgl::implementation_private::EvalCoord2f
#define glEvalCoord2fv sdpgl::implementation_private::EvalCoord2fv
#define glEvalMesh1 sdpgl::implementation_private::EvalMesh1
#define glEvalMesh2 sdpgl::implementation_private::EvalMesh2
#define glEvalPoint1 sdpgl::implementation_private::EvalPoint1
#define glEvalPoint2 sdpgl::implementation_private::EvalPoint2
#define glFeedbackBuffer sdpgl::implementation_private::FeedbackBuffer
#define glFinish sdpgl::implementation_private::Finish
#define glFlush sdpgl::implementation_private::Flush
#define glFogf sdpgl::implementation_private::Fogf
#define glFogfv sdpgl::implementation_private::Fogfv
#define glFogi sdpgl::implementation_private::Fogi
#define glFogiv sdpgl::implementation_private::Fogiv
#define glFrontFace sdpgl::implementation_private::FrontFace
#define glFrustum sdpgl::implementation_private::Frustum
#define glGenLists sdpgl::implementation_private::GenLists
#define glGenTextures sdpgl::implementation_private::GenTextures
#define glGetBooleanv sdpgl::implementation_private::GetBooleanv
#define glGetClipPlane sdpgl::implementation_private::GetClipPlane
#define glGetDoublev sdpgl::implementation_private::GetDoublev
#define glGetError sdpgl::implementation_private::GetError
#define glGetFloatv sdpgl::implementation_private::GetFloatv
#define glGetIntegerv sdpgl::implementation_private::GetIntegerv
#define glGetLightfv sdpgl::implementation_private::GetLightfv
#define glGetLightiv sdpgl::implementation_private::GetLightiv
#define glGetMapdv sdpgl::implementation_private::GetMapdv
#define glGetMapfv sdpgl::implementation_private::GetMapfv
#define glGetMapiv sdpgl::implementation_private::GetMapiv
#define glGetMaterialfv sdpgl::implementation_private::GetMaterialfv
#define glGetMaterialiv sdpgl::implementation_private::GetMaterialiv
#define glGetPixelMapfv sdpgl::implementation_private::GetPixelMapfv
#define glGetPixelMapuiv sdpgl::implementation_private::GetPixelMapuiv
#define glGetPixelMapusv sdpgl::implementation_private::GetPixelMapusv
#define glGetPointerv sdpgl::implementation_private::GetPointerv
#define glGetPolygonStipple sdpgl::implementation_private::GetPolygonStipple
#define glGetString sdpgl::implementation_private::GetString
#define glGetTexEnvfv sdpgl::implementation_private::GetTexEnvfv
#define glGetTexEnviv sdpgl::implementation_private::GetTexEnviv
#define glGetTexGendv sdpgl::implementation_private::GetTexGendv
#define glGetTexGenfv sdpgl::implementation_private::GetTexGenfv
#define glGetTexGeniv sdpgl::implementation_private::GetTexGeniv
#define glGetTexImage sdpgl::implementation_private::GetTexImage
#define glGetTexLevelParameterfv sdpgl::implementation_private::GetTexLevelParameterfv
#define glGetTexLevelParameteriv sdpgl::implementation_private::GetTexLevelParameteriv
#define glGetTexParameterfv sdpgl::implementation_private::GetTexParameterfv
#define glGetTexParameteriv sdpgl::implementation_private::GetTexParameteriv
#define glHint sdpgl::implementation_private::Hint
#define glIndexMask sdpgl::implementation_private::IndexMask
#define glIndexPointer sdpgl::implementation_private::IndexPointer
#define glIndexd sdpgl::implementation_private::Indexd
#define glIndexdv sdpgl::implementation_private::Indexdv
#define glIndexf sdpgl::implementation_private::Indexf
#define glIndexfv sdpgl::implementation_private::Indexfv
#define glIndexi sdpgl::implementation_private::Indexi
#define glIndexiv sdpgl::implementation_private::Indexiv
#define glIndexs sdpgl::implementation_private::Indexs
#define glIndexsv sdpgl::implementation_private::Indexsv
#define glIndexub sdpgl::implementation_private::Indexub
#define glIndexubv sdpgl::implementation_private::Indexubv
#define glInitNames sdpgl::implementation_private::InitNames
#define glInterleavedArrays sdpgl::implementation_private::InterleavedArrays
#define glIsEnabled sdpgl::implementation_private::IsEnabled
#define glIsList sdpgl::implementation_private::IsList
#define glIsTexture sdpgl::implementation_private::IsTexture
#define glLightModelf sdpgl::implementation_private::LightModelf
#define glLightModelfv sdpgl::implementation_private::LightModelfv
#define glLightModeli sdpgl::implementation_private::LightModeli
#define glLightModeliv sdpgl::implementation_private::LightModeliv
#define glLightf sdpgl::implementation_private::Lightf
#define glLightfv sdpgl::implementation_private::Lightfv
#define glLighti sdpgl::implementation_private::Lighti
#define glLightiv sdpgl::implementation_private::Lightiv
#define glLineStipple sdpgl::implementation_private::LineStipple
#define glLineWidth sdpgl::implementation_private::LineWidth
#define glListBase sdpgl::implementation_private::ListBase
#define glLoadIdentity sdpgl::implementation_private::LoadIdentity
#define glLoadMatrixd sdpgl::implementation_private::LoadMatrixd
#define glLoadMatrixf sdpgl::implementation_private::LoadMatrixf
#define glLoadName sdpgl::implementation_private::LoadName
#define glLogicOp sdpgl::implementation_private::LogicOp
#define glMap1d sdpgl::implementation_private::Map1d
#define glMap1f sdpgl::implementation_private::Map1f
#define glMap2d sdpgl::implementation_private::Map2d
#define glMap2f sdpgl::implementation_private::Map2f
#define glMapGrid1d sdpgl::implementation_private::MapGrid1d
#define glMapGrid1f sdpgl::implementation_private::MapGrid1f
#define glMapGrid2d sdpgl::implementation_private::MapGrid2d
#define glMapGrid2f sdpgl::implementation_private::MapGrid2f
#define glMaterialf sdpgl::implementation_private::Materialf
#define glMaterialfv sdpgl::implementation_private::Materialfv
#define glMateriali sdpgl::implementation_private::Materiali
#define glMaterialiv sdpgl::implementation_private::Materialiv
#define glMatrixMode sdpgl::implementation_private::MatrixMode
#define glMultMatrixd sdpgl::implementation_private::MultMatrixd
#define glMultMatrixf sdpgl::implementation_private::MultMatrixf
#define glNewList sdpgl::implementation_private::NewList
#define glNormal3b sdpgl::implementation_private::Normal3b
#define glNormal3bv sdpgl::implementation_private::Normal3bv
#define glNormal3d sdpgl::implementation_private::Normal3d
#define glNormal3dv sdpgl::implementation_private::Normal3dv
#define glNormal3f sdpgl::implementation_private::Normal3f
#define glNormal3fv sdpgl::implementation_private::Normal3fv
#define glNormal3i sdpgl::implementation_private::Normal3i
#define glNormal3iv sdpgl::implementation_private::Normal3iv
#define glNormal3s sdpgl::implementation_private::Normal3s
#define glNormal3sv sdpgl::implementation_private::Normal3sv
#define glNormalPointer sdpgl::implementation_private::NormalPointer
#define glOrtho sdpgl::implementation_private::Ortho
#define glPassThrough sdpgl::implementation_private::PassThrough
#define glPixelMapfv sdpgl::implementation_private::PixelMapfv
#define glPixelMapuiv sdpgl::implementation_private::PixelMapuiv
#define glPixelMapusv sdpgl::implementation_private::PixelMapusv
#define glPixelStoref sdpgl::implementation_private::PixelStoref
#define glPixelStorei sdpgl::implementation_private::PixelStorei
#define glPixelTransferf sdpgl::implementation_private::PixelTransferf
#define glPixelTransferi sdpgl::implementation_private::PixelTransferi
#define glPixelZoom sdpgl::implementation_private::PixelZoom
#define glPointSize sdpgl::implementation_private::PointSize
#define glPolygonMode sdpgl::implementation_private::PolygonMode
#define glPolygonOffset sdpgl::implementation_private::PolygonOffset
#define glPolygonStipple sdpgl::implementation_private::PolygonStipple
#define glPopAttrib sdpgl::implementation_private::PopAttrib
#define glPopClientAttrib sdpgl::implementation_private::PopClientAttrib
#define glPopMatrix sdpgl::implementation_private::PopMatrix
#define glPopName sdpgl::implementation_private::PopName
#define glPrioritizeTextures sdpgl::implementation_private::PrioritizeTextures
#define glPushAttrib sdpgl::implementation_private::PushAttrib
#define glPushClientAttrib sdpgl::implementation_private::PushClientAttrib
#define glPushMatrix sdpgl::implementation_private::PushMatrix
#define glPushName sdpgl::implementation_private::PushName
#define glRasterPos2d sdpgl::implementation_private::RasterPos2d
#define glRasterPos2dv sdpgl::implementation_private::RasterPos2dv
#define glRasterPos2f sdpgl::implementation_private::RasterPos2f
#define glRasterPos2fv sdpgl::implementation_private::RasterPos2fv
#define glRasterPos2i sdpgl::implementation_private::RasterPos2i
#define glRasterPos2iv sdpgl::implementation_private::RasterPos2iv
#define glRasterPos2s sdpgl::implementation_private::RasterPos2s
#define glRasterPos2sv sdpgl::implementation_private::RasterPos2sv
#define glRasterPos3d sdpgl::implementation_private::RasterPos3d
#define glRasterPos3dv sdpgl::implementation_private::RasterPos3dv
#define glRasterPos3f sdpgl::implementation_private::RasterPos3f
#define glRasterPos3fv sdpgl::implementation_private::RasterPos3fv
#define glRasterPos3i sdpgl::implementation_private::RasterPos3i
#define glRasterPos3iv sdpgl::implementation_private::RasterPos3iv
#define glRasterPos3s sdpgl::implementation_private::RasterPos3s
#define glRasterPos3sv sdpgl::implementation_private::RasterPos3sv
#define glRasterPos4d sdpgl::implementation_private::RasterPos4d
#define glRasterPos4dv sdpgl::implementation_private::RasterPos4dv
#define glRasterPos4f sdpgl::implementation_private::RasterPos4f
#define glRasterPos4fv sdpgl::implementation_private::RasterPos4fv
#define glRasterPos4i sdpgl::implementation_private::RasterPos4i
#define glRasterPos4iv sdpgl::implementation_private::RasterPos4iv
#define glRasterPos4s sdpgl::implementation_private::RasterPos4s
#define glRasterPos4sv sdpgl::implementation_private::RasterPos4sv
#define glReadBuffer sdpgl::implementation_private::ReadBuffer
#define glReadPixels sdpgl::implementation_private::ReadPixels
#define glRectd sdpgl::implementation_private::Rectd
#define glRectdv sdpgl::implementation_private::Rectdv
#define glRectf sdpgl::implementation_private::Rectf
#define glRectfv sdpgl::implementation_private::Rectfv
#define glRecti sdpgl::implementation_private::Recti
#define glRectiv sdpgl::implementation_private::Rectiv
#define glRects sdpgl::implementation_private::Rects
#define glRectsv sdpgl::implementation_private::Rectsv
#define glRenderMode sdpgl::implementation_private::RenderMode
#define glRotated sdpgl::implementation_private::Rotated
#define glRotatef sdpgl::implementation_private::Rotatef
#define glScaled sdpgl::implementation_private::Scaled
#define glScalef sdpgl::implementation_private::Scalef
#define glScissor sdpgl::implementation_private::Scissor
#define glSelectBuffer sdpgl::implementation_private::SelectBuffer
#define glShadeModel sdpgl::implementation_private::ShadeModel
#define glStencilFunc sdpgl::implementation_private::StencilFunc
#define glStencilMask sdpgl::implementation_private::StencilMask
#define glStencilOp sdpgl::implementation_private::StencilOp
#define glTexCoord1d sdpgl::implementation_private::TexCoord1d
#define glTexCoord1dv sdpgl::implementation_private::TexCoord1dv
#define glTexCoord1f sdpgl::implementation_private::TexCoord1f
#define glTexCoord1fv sdpgl::implementation_private::TexCoord1fv
#define glTexCoord1i sdpgl::implementation_private::TexCoord1i
#define glTexCoord1iv sdpgl::implementation_private::TexCoord1iv
#define glTexCoord1s sdpgl::implementation_private::TexCoord1s
#define glTexCoord1sv sdpgl::implementation_private::TexCoord1sv
#define glTexCoord2d sdpgl::implementation_private::TexCoord2d
#define glTexCoord2dv sdpgl::implementation_private::TexCoord2dv
#define glTexCoord2f sdpgl::implementation_private::TexCoord2f
#define glTexCoord2fv sdpgl::implementation_private::TexCoord2fv
#define glTexCoord2i sdpgl::implementation_private::TexCoord2i
#define glTexCoord2iv sdpgl::implementation_private::TexCoord2iv
#define glTexCoord2s sdpgl::implementation_private::TexCoord2s
#define glTexCoord2sv sdpgl::implementation_private::TexCoord2sv
#define glTexCoord3d sdpgl::implementation_private::TexCoord3d
#define glTexCoord3dv sdpgl::implementation_private::TexCoord3dv
#define glTexCoord3f sdpgl::implementation_private::TexCoord3f
#define glTexCoord3fv sdpgl::implementation_private::TexCoord3fv
#define glTexCoord3i sdpgl::implementation_private::TexCoord3i
#define glTexCoord3iv sdpgl::implementation_private::TexCoord3iv
#define glTexCoord3s sdpgl::implementation_private::TexCoord3s
#define glTexCoord3sv sdpgl::implementation_private::TexCoord3sv
#define glTexCoord4d sdpgl::implementation_private::TexCoord4d
#define glTexCoord4dv sdpgl::implementation_private::TexCoord4dv
#define glTexCoord4f sdpgl::implementation_private::TexCoord4f
#define glTexCoord4fv sdpgl::implementation_private::TexCoord4fv
#define glTexCoord4i sdpgl::implementation_private::TexCoord4i
#define glTexCoord4iv sdpgl::implementation_private::TexCoord4iv
#define glTexCoord4s sdpgl::implementation_private::TexCoord4s
#define glTexCoord4sv sdpgl::implementation_private::TexCoord4sv
#define glTexCoordPointer sdpgl::implementation_private::TexCoordPointer
#define glTexEnvf sdpgl::implementation_private::TexEnvf
#define glTexEnvfv sdpgl::implementation_private::TexEnvfv
#define glTexEnvi sdpgl::implementation_private::TexEnvi
#define glTexEnviv sdpgl::implementation_private::TexEnviv
#define glTexGend sdpgl::implementation_private::TexGend
#define glTexGendv sdpgl::implementation_private::TexGendv
#define glTexGenf sdpgl::implementation_private::TexGenf
#define glTexGenfv sdpgl::implementation_private::TexGenfv
#define glTexGeni sdpgl::implementation_private::TexGeni
#define glTexGeniv sdpgl::implementation_private::TexGeniv
#define glTexImage1D sdpgl::implementation_private::TexImage1D
#define glTexImage2D sdpgl::implementation_private::TexImage2D
#define glTexParameterf sdpgl::implementation_private::TexParameterf
#define glTexParameterfv sdpgl::implementation_private::TexParameterfv
#define glTexParameteri sdpgl::implementation_private::TexParameteri
#define glTexParameteriv sdpgl::implementation_private::TexParameteriv
#define glTexSubImage1D sdpgl::implementation_private::TexSubImage1D
#define glTexSubImage2D sdpgl::implementation_private::TexSubImage2D
#define glTranslated sdpgl::implementation_private::Translated
#define glTranslatef sdpgl::implementation_private::Translatef
#define glVertex2d sdpgl::implementation_private::Vertex2d
#define glVertex2dv sdpgl::implementation_private::Vertex2dv
#define glVertex2f sdpgl::implementation_private::Vertex2f
#define glVertex2fv sdpgl::implementation_private::Vertex2fv
#define glVertex2i sdpgl::implementation_private::Vertex2i
#define glVertex2iv sdpgl::implementation_private::Vertex2iv
#define glVertex2s sdpgl::implementation_private::Vertex2s
#define glVertex2sv sdpgl::implementation_private::Vertex2sv
#define glVertex3d sdpgl::implementation_private::Vertex3d
#define glVertex3dv sdpgl::implementation_private::Vertex3dv
#define glVertex3f sdpgl::implementation_private::Vertex3f
#define glVertex3fv sdpgl::implementation_private::Vertex3fv
#define glVertex3i sdpgl::implementation_private::Vertex3i
#define glVertex3iv sdpgl::implementation_private::Vertex3iv
#define glVertex3s sdpgl::implementation_private::Vertex3s
#define glVertex3sv sdpgl::implementation_private::Vertex3sv
#define glVertex4d sdpgl::implementation_private::Vertex4d
#define glVertex4dv sdpgl::implementation_private::Vertex4dv
#define glVertex4f sdpgl::implementation_private::Vertex4f
#define glVertex4fv sdpgl::implementation_private::Vertex4fv
#define glVertex4i sdpgl::implementation_private::Vertex4i
#define glVertex4iv sdpgl::implementation_private::Vertex4iv
#define glVertex4s sdpgl::implementation_private::Vertex4s
#define glVertex4sv sdpgl::implementation_private::Vertex4sv
#define glVertexPointer sdpgl::implementation_private::VertexPointer
#define glViewport sdpgl::implementation_private::Viewport

#endif // SDPGL_TRACE_ENABLED_PRIVATE_H
