#ifndef AUTORESPONDER_H
#define AUTORESPONDER_H

#include <QtCore/QObject>
#include <QtCore/QList>

#include "config_file.h"
#include "configuration_aware_object.h"
#include "main_configuration_window.h"
#include "misc.h"
#include "protocol.h"
#include "usergroup.h"
/**
 * @defgroup autoresponder Autoresponder
 * @{
 */

class ChatWidget;

class AutoResponder : public ConfigurationUiHandler, ConfigurationAwareObject
{
	Q_OBJECT

	private:
		QList<UserListElements> repliedUsers; /*!< uiny osb, ktrym ju odpowiedziano */

		QString autotext; /*!< tre automatycznej odpowiedzi */

		bool respondConferences; /*!< czy odpowiada na konkerencje */
		bool respondOnlyFirst; /*!< czy odpowiada tylko na pierwsz wiadomo */

		bool statusAvailable; /*!< czy odpowiadamy, gdy jestemy dostpni */
		bool statusBusy; /*!< czy odpowiadamy, gdy jestemy zajci */
		bool statusInvisible; /*!< czy odpowiadamy, gdy jestemy niewidoczni */
		bool statusTalkWithMe; /*!< czy odpowiadamy, gdy jestemy 'porozmawiaj ze mna' */
		bool statusDoNotDisturb; /*!< czy odpowiadamy, gdy jestemy 'nie przeszkadzac' */

		/**
			\fn void import_0_5_0_Configuration()
			Import danych konfiguracyjnych ze starszej wersji Kadu.
		**/
		void import_0_5_0_Configuration();
		void createDefaultConfiguration();

	protected:
		/**
			\fn void configurationUpdated()
			Metoda jest wywoywana po zmianie w oknie konfiguracyjnym.
		**/
		virtual void configurationUpdated();

	public:
		/**
			\fn AutoResponder(QObject *parent=0, const char *name=0)
			Standardowy konstruktor
			\param parent rodzic - domylnie 0
			\param name nazwa - domylnie 0
		**/
		AutoResponder(QObject *parent=0, const char *name=0);
		virtual ~AutoResponder();
		virtual void mainConfigurationWindowCreated(MainConfigurationWindow *mainConfigurationWindow);

	public slots:

		/**
			\fn void messageReceived(Protocol *protocol, UserListElements senders, const QString& msg, time_t time)
			Slot jest wywoywany po odebraniu wiadomoci.
			\param protocol protok po ktrym nadesza wiadomo
			\param senders lista nadawcw wiadomoci
			\param msg tre wiadomoci
			\param time czas
		**/
		void messageReceived(Protocol *protocol, UserListElements senders, const QString& msg, time_t time);

		/**
			\fn void chatOpenedClosed(ChatWidget *chat)
			Slot jest wywoywany przy otwieraniu lub po zamkniciu
			okna chat.
			\param chat okno wiadomoci
		**/
		void chatOpenedClosed(ChatWidget *chat);
};

extern AutoResponder* autoresponder;

/** @} */

#endif
