/***************************************************************************
 *   Copyright (C) 2004-2005 by Jürgen Kofler                                   *
 *   kaffeine@gmx.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 /*
  * Last modified: $Date: 2005/02/02 10:08:26 $ by $Author: juergenk $
  */
 
#ifndef KMEDIAPART_H
#define KMEDIAPART_H

#include <kparts/part.h>

#include <qstring.h>
#include <qdatetime.h>

#include "mrl.h"

/*
 * Base-Class for Kaffeine-Parts. Derive from this class if you want to develop a player part for Kaffeine.
 * At least you have to reimplement openURL(const MRL&) and to emit signalTrackFinished()!
 *
 * IMPORTANT: Forward the double-click, middle-click and wheel mouse-events to the parent widget (don't use
 * QMouseEvent::accept())!
 * 
 * @author Jürgen Kofler
 */

class QSize;

class KMediaPart : public KParts::ReadOnlyPart
{
  Q_OBJECT
public:
  KMediaPart(QObject* parent, const char* name);
  virtual ~KMediaPart();
  
  /*
   * Playback in progress?
   */
  virtual bool isPlaying() { return false; }
  
  /*
   * Playback paused?
   */
  virtual bool isPaused() {return false; }
  
  /*
   *  Current mrl. signalNewMeta() tells Kaffeine the mrl was filled with new meta info.
   */
  const MRL& mrl() const { return m_mrl; }
  
  /* 
   * Get mrls for DVD/VCD/AudioCD playback. Maybe something like "dvd://"
   * You should set mime to "video/dvd", "video/vcd" or "audio/cd".
   *
   *  prototype: void xxxMRLS(MRL::List& mrls, bool& ok, bool& supported, const QString&)
   *
   *  Set supported to false, if the player don't support DVD,VCD,AudioCD playback.
   *  Set ok to true if there are valid mrls.
   */
  virtual void audiocdMRLS(MRL::List&, bool&, bool& supported, const QString& = QString::null) { supported = false; }
  virtual void vcdMRLS(MRL::List&, bool&, bool& supported, const QString& = QString::null) { supported = false; }
  virtual void dvdMRLS(MRL::List&, bool&, bool& supported, const QString&  = QString::null){ supported = false; }
  
  /* 
   * Should look like "*.mp3 *.MP3 *.avi *.AVI", used as file filter for directory import
   */
  virtual QString supportedExtensions() { return QString::null; }
  
  /*
   * Current volume. In percent.
   */
  virtual uint volume() const { return 0; }
  /*
   * Current position. In percent.
   */
  virtual uint position() const { return 0; }
  
  /*
   * DVD etc.
   */
  virtual bool hasChapters() { return false; }
  
  /*
   * Contain the stream video?
   */
  virtual bool hasVideo() { return false; }
  
  /*
   * Return a pointer to the player engine. Kaffeine will not use that at the moment!
   */
  virtual void* engine() { return NULL; }
  
signals:
  /*
   * Frame size of video changed
   */
  void signalNewFrameSize(const QSize& frame);
  
  /* 
   * New meta information in mrl()
   */
  void signalNewMeta();
  
  /*
   * Playback of current track finished
   */
  void signalTrackFinished();
  
  /*
   *  Playback failed
   */
  void signalPlaybackFailed();
   
public slots:  
  /* 
   * You have to reimplement this! Opens an url and plays it.
   */
  virtual bool openURL(const MRL& mrl) { m_mrl = mrl; return false; }
  
  bool openURL(const KURL& url) { return openURL(MRL(url)); }
  
  /* 
   * Tells the player we go fullscreen now. Hide controls etc.
   */
  virtual void slotPrepareForFullscreen(bool) {} 
  
  /*
   * DVD etc.
   */
  virtual void playNextChapter() {}
  
  /*
   * DVD etc.
   */
  virtual void playPreviousChapter() {}
  
  /*
   * Toggle play/pause
   */
  virtual void slotTogglePause(bool pauseLive = true) { pauseLive = true; }
  
  /*
   * Stop playback
   */
  virtual void slotStop() {}
  
  /*
   * Sets Volume. In percent.
   */
  virtual void slotSetVolume(uint) {} 
  
  /*
   * Sets Position. In percent.
   */
  virtual void slotSetPosition(uint) {} 
  
  /*
   * Turn mute on/off
   */
  virtual void slotMute() {} 
  
protected:
   /* 
    * Don't reimplement this, a player should be able to stream media 
    */
  bool openFile() { return false; } 
  
  MRL m_mrl;
};

#endif
