/*
    filterlistwidget.h - Display a list of filter.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef FILTERLISTWIDGET_H
#define FILTERLISTWIDGET_H

#include <qwidget.h>

/**
 * Display in a list the available values for a filter.
 *
 * @author Michaël Larouche <michael.larouche@kdemail.net>
 */
class FilterListWidget : public QWidget
{
	Q_OBJECT
public:
	FilterListWidget(const QString &filterName, QWidget *parent = 0, const char *name = 0);
	~FilterListWidget();
	
	QString selection() const;

public slots:
	void insertItem(const QString &item);
	void clear();
	void sort();
	void select(const QString &text);

private slots:
	void privateItemSelected(int index);

signals:
	void selectionChanged(const QString&);

private:
	void createGUI();

	class Private;
	Private *d;
};
#endif
