types = {'INTEGER':int,
    'FLOAT':float,
    'VARCHAR':str }
    
inits = """import gadfly

def makeDict(res):
    # convert the result of a cursor.fetchall() to a list
    # of dictionaries
    records = []
    for item in res:
        records.append(dict([(fname,item[i])
            for (i,fname) in enumerate(['recno']+field_names)]))
    return records

__id__ = 'recno'

Types = {
    int : 'INTEGER',
    str : 'VARCHAR',
    float : 'FLOAT',
    datetime : 'VARCHAR',
    date : 'VARCHAR'
    }
"""

create_or_open = """# open connection
table_name = os.path.basename(name)
table_dir = os.path.dirname(name)

try:
    connection = gadfly.gadfly(table_name,table_dir)
    cursor = connection.cursor()
except IOError:
    connection = gadfly.gadfly()
    connection.startup(table_name,table_dir)
    field_def = ', '.join(['recno INTEGER'] + \
        ['%s %s' %(n,t) for (n,t) in zip(field_names, field_types)])
    sql = 'CREATE TABLE %s (%s)' %(name,field_def)
    cursor = connection.cursor()
    cursor.execute(sql)
"""

all_records = """cursor.execute('SELECT %s FROM %s' %(','.join(['recno']+field_names),name))
    records = makeDict(cursor.fetchall())
"""

select_by_id = """field_string = ','.join(field_names)
        sql = 'SELECT recno,%s FROM %s WHERE recno = %s' \
            %(field_string,name,record_id)
        cursor.execute(sql)
        record = makeDict(cursor.fetchall())[0]\n"""

insert_or_update = """
    # get next id
    sql="SELECT MAX(recno) FROM %s" %name
    try:
        cursor.execute(sql)
        res=cursor.fetchall()
        next_id = res[0][0]+1
    except ValueError: # empty base
        next_id = 0

    # replace single quotes by double quotes
    for (k,v) in untyped_fields.items():
        untyped_fields[k]=v.replace("'","''")
    if record_id == -1:
        field_string = 'recno,' + ','.join(field_names)
        vals = '%s,' %next_id + ','.join([ "'%s'" %untyped_fields[f] 
            for f in field_names])
        sql = 'INSERT INTO %s (%s) VALUES (%s)' \\
            %(name,field_string,vals)
    else:
        vals = ','.join(["%s = '%s'" %(k,v) 
            for (k,v) in untyped_fields.iteritems()])
        sql = 'UPDATE %s SET %s WHERE recno = %s' %(name,vals,record_id)
    cursor.execute(sql)
    connection.commit()
    connection.close()
    """ 

remove = """
    sql = 'DELETE FROM %s WHERE recno = %s' %(name,record_id)
    cursor.execute(sql)
    connection.commit()
    connection.close()
"""
