#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qtoolbutton.h>
#include <qapplication.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qpalette.h>
#include <qcolor.h>
#include <qtooltip.h>
#include <qtimer.h>

#include "category.h"
#include "browser.h"
#include "aapjedialog.h"
#include "categorylabel.h"
#include "iconlabel.h"
#include "globals.h"
#include "separator.h"
#include "sourcebox.h"
#include "expression.h"
#include "utility.h"
#include "preferences.h"
#include "chatbox.h"
#include "keyboard.h"
#include "bookmarks.h"
#include "mailinglists.h"
#include "ownerbutton.h"

#include "mailicon.xpm"
#include "folder.xpm"

void Browser::buildBookmarkMenu()
{
	bmmenu->clear();	

	bmaddid = bmmenu->insertItem( "&Add Bookmark", this, SLOT(addBookmark()), CTRL+Key_A );
	bmmenu->insertItem( "&View Bookmarks", this, SLOT(showBookmarks()), CTRL+Key_B );
	bmmenu->insertSeparator();

	bmmenu->setItemEnabled( bmaddid, FALSE );

	for( unsigned int n = 0; ( n < config->bookmarkv.size() ) && ( n < 18 ); n += 2 )
	{
		string item = config->bookmarkv[n];
		bmmenu->insertItem( item.c_str(), this, SLOT( bookmarkSelected( int ) ), Key_1+n/2 );
	}
}

void Browser::checkScrollHeight()
{
	if( highlight == -1 ) 
		return;

	int viewtop = scrollView->contentsY();
	int viewbottom = viewtop + scrollView->viewport()->height();
	int labeltop = allLabelv[2*highlight]->y();
	int labelbottom = allLabelv[2*highlight]->y() + allLabelv[2*highlight]->height();
	
	if( labelbottom+4 > viewbottom ) 
		scrollView->setContentsPos( 0, labelbottom+4-(viewbottom-viewtop) );
	else if( labeltop-4 < viewtop )
		scrollView->setContentsPos( 0, labeltop-4 );
}

void Browser::setCatLabelColors()
{
	for( unsigned int n = 0; n < allLabelv.size(); n += 2 )
	{
		CategoryLabel *label = (CategoryLabel *)(allLabelv[n]);

		QColorGroup group;
		group.setColor( QColorGroup::Background, QColor( config->backgroundColor() ) );

		allLabelv[n+1]->setPalette( QPalette( group, group, group ) );

		if( n == 2*highlight )
		{
			group.setColor( QColorGroup::Background, config->highlightBackground() );
			group.setColor( QColorGroup::Foreground, config->highlightForeground() );
		}
		else
		{
			char visited, failed, extension; 
			label->category->setNavigationFlags( visited, failed, extension );
	
			if( extension )
			{
				if( visited )
					group.setColor( QColorGroup::Foreground, config->visitedColor() ); 
				else	
					group.setColor( QColorGroup::Foreground, config->extensionColor() );

				label->extension = TRUE;
				QToolTip::add( label, extensionaddress.c_str() );

				QFont f = label->font();
				f.setUnderline( TRUE );
				label->setFont( f );
			}	
			else if( visited )
				group.setColor( QColorGroup::Foreground, config->visitedColor() ); 
		}	

		label->setPalette( QPalette( group, group, group ) ); 
	}	
}

void Browser::renewToolbar()
{
	TBback->hide();
	TBforward->hide();
	TBinfo->hide();
	TBnews->hide();
	TBchat->hide();
	TBdiscuss->hide();
	TBbase->hide();
	TBlinks->hide(); 
	TBmark->hide(); 
	TBtomark->hide();
	TBbookmarks->hide();
	TBroot->hide();
	TBstop->hide();

	vector<string> icons;
	config->toolbarIcons( icons );
	
	for( unsigned int n = 0; n < icons.size(); n++ )
	{
		if( icons[n] == "back" )
			TBback->show();
		else if( icons[n] == "forward" )
			TBforward->show();
		else if( icons[n] == "information" )
			TBinfo->show();
		else if( icons[n] == "news" )
			TBnews->show();
		else if( icons[n] == "chat" )
			TBchat->show();
		else if( icons[n] == "discuss" )
			TBdiscuss->show();
		else if( icons[n] == "recommended" )
			TBbase->show();
		else if( icons[n] == "links" )
			TBlinks->show();
		else if( icons[n] == "mark" )
			TBmark->show();
		else if( icons[n] == "to mark" )	
			TBtomark->show();
		else if( icons[n] == "bookmarks" )
			TBbookmarks->show();
		else if( icons[n] == "new search" )	
			TBroot->show();
		else if( icons[n] == "stop" )
			TBstop->show();
	}  
}

void Browser::buildToolbar()
{
	toolBar = new QToolBar( this );
	addToolBar( toolBar, config->dock, TRUE );

	addToolButton( TBback, "back", "Take a step back", SLOT( backPressed() ) );
	addToolButton( TBforward, "forward", "Undo a step back", SLOT( forwardPressed() ) );
	addToolButton( TBinfo, "info", "Category information", SLOT( infoPressed() ) );
	addToolButton( TBnews, "news", "Category news", SLOT( newsPressed() ) );
	addToolButton( TBchat, "chat", "Chat about this topic", SLOT( chatPressed() ) );
	addToolButton( TBdiscuss, "discuss", "Discuss this topic", SLOT( discussPressed() ) ); 
	addToolButton( TBbase, "bases", "Web bases for this topic", SLOT( basePressed() ) );
	addToolButton( TBlinks, "links", "View related web links", SLOT( linksPressed() ) );
	addToolButton( TBmark, "mark", "Mark this category", SLOT( markPressed() ) );
	addToolButton( TBtomark, "tomark", "Jump to marked category", SLOT( tomarkPressed() ) );
	addToolButton( TBbookmarks, "bookmarks", "View bookmarks", SLOT( showBookmarks() ) ); 
	addToolButton( TBroot, "root", "Go to Start Address", SLOT( rootPressed() ) );
	addToolButton( TBstop, "stop", "Abort network action", SLOT( stopPressed() ) ); 
	
	renewToolbar();
}

void Browser::addToolButton( QToolButton *&tb, string name, string desc, const char *slot )
{
	string gifname = slashConcat( config->iconDir(), name ) + "_16.gif";

	tb = new QToolButton( QPixmap( gifname.c_str() ), desc.c_str(), QString::null, this, slot, toolBar, 0 ); 
}

void Browser::showNewCategory()
{
	allLabelv.clear();
        for( unsigned int n = 0; n < catLabelv.size(); n++ )
		delete catLabelv[n];
	catLabelv.clear();
	for( unsigned int n = 0; n < maskLabelv.size(); n++ )
		delete maskLabelv[n];
	maskLabelv.clear();
	for( unsigned int n = 0; n < genLabelv.size(); n++ )
		delete genLabelv[n];
	genLabelv.clear();
	
	genSep->hide();
	maskSep->hide();

        for( unsigned int n = 0; n < cCategory->subCatv->size(); n++ )
	{
		Category *c = (*(cCategory->subCatv))[n];

		if( !c->isVisible() )
			continue;
			
                int deselected = FALSE;

                if( !maskv.empty() &&
                    (*(cCategory->subCatv))[n]->realsubcat )
                {
                    for( unsigned int m = 0; m < maskv.size(); m++ )
                        if( !exprTrueForCategory( maskv[m], (*(cCategory->subCatv))[n] ) )
                        {
                            deselected = TRUE;
                            break;
                        }
                }
		
		if( deselected )
		{
			addCatLabel( maskLabelv, c );
			maskSep->show();
		}	
		else if( c->generalization )
		{
			addCatLabel( genLabelv, c );
			genSep->show();
		}	
		else
			addCatLabel( catLabelv, c );
	}
		
	if( selectionentered &&
	    !selectionv.size() &&
	    skippedCat->isVisible() )
	{
		int already = FALSE;

		for( unsigned int n = 0; n < genLabelv.size(); n += 2 )
			if( equalCI( ((CategoryLabel *)(genLabelv[n]))->category->name, skippedCat->name ) )
			{
				already = TRUE;
				break;
			}	
		
		addCatLabel( genLabelv, skippedCat );
		genSep->show();
	}
	
	for( unsigned int n = 0; n < catLabelv.size(); n++ )
		allLabelv.push_back( catLabelv[n] );
	for( unsigned int n = 0; n < maskLabelv.size(); n++ )
		allLabelv.push_back( maskLabelv[n] );
	for( unsigned int n = 0; n < genLabelv.size(); n++ )
		allLabelv.push_back( genLabelv[n] );
		
	setCatLabelColors();

	enableDisable( FALSE );

	sourceBox->update();
	debugWindow->renew();
	resizeEvent(0);
}

void Browser::addCatLabel( vector<QLabel *> &labelv, Category *category )
{
	CategoryLabel *label = new CategoryLabel( scrollWidget, category );
	label->setMargin( 2 );
	label->setAlignment( AlignLeft );
	label->setCursor( pointingHandCursor );

	label->memory = "oerkie";
	
	QObject::connect( label, SIGNAL( LeftMouseButtonClicked( Category * ) ), 
			  this, SLOT( enterCategory( Category * ) ) ); 

	QObject::connect( label, SIGNAL( rightMenuExtension( int, int, Category * ) ),
			  this, SLOT( showRightMenuExtension( int, int, Category * ) ) );
	QObject::connect( label, SIGNAL( rightMenu( int, int ) ), this, 
			  SLOT( showRightMenu( int, int ) ) );

	IconLabel *icon = new IconLabel( scrollWidget );
	icon->setPixmap( folder );

	QObject::connect( icon, SIGNAL( rightMenu( int, int ) ), this,
			  SLOT( showRightMenu( int, int ) ) );

	labelv.push_back( label );
	labelv.push_back( icon );
}

void Browser::resizeEvent( QResizeEvent * )
{
	QSize viewpsize = scrollView->viewport()->size();

	// adjust title label

	QToolTip::remove( titleLabel );

	string title, tooltip = "No description";
	if( cCategory )
	{
		title = cCategory->calcTitle();
		
		int i;
		if( ( i = title.find( ";" ) ) != -1 )
		{
			tooltip = trim( title.substr( i+1, title.length()-i-1 ) );
			title = trim( title.substr( 0, i ) );
		}
			
	}
	
	titleLabel->setText( wrapLabel( title, titleLabel->width(), this ).c_str() );
	QToolTip::add( titleLabel, tooltip.c_str() );
	
	int heightdiff = titleLabel->sizeHint().height() - titleLabel->height(); 

	// adjust owner button

	if( cCategory )
		Bowner->setText( cCategory->calcOwner().c_str() ); 

	// add labels and separators
	
	int h = resizeCatLabels( catLabelv, 4 );
	
	if( maskLabelv.size() )
	{
		maskSep->setGeometry( 0, h, viewpsize.width(), 16 );
		h = resizeCatLabels( maskLabelv, h+22 );
	}

	if( genLabelv.size() )
	{
		genSep->setGeometry( 0, h, viewpsize.width(), 16 );
		h = resizeCatLabels( genLabelv, h+22 );
	}

	if( h < viewpsize.height()-heightdiff )
		scrollWidget->resize( viewpsize.width(), viewpsize.height()-heightdiff );	
	else
		scrollWidget->resize( viewpsize.width(), h );
				
	scrollView->verticalScrollBar()->setValue( 0 );   
}

int Browser::resizeCatLabels( vector<QLabel *> &labelv, int h )
{
	int maxwidth = scrollView->viewport()->size().width()-22;

        for( unsigned int n = 0; n < labelv.size(); n += 2 )
	{
		CategoryLabel *label = (CategoryLabel *)(labelv[n]);
		IconLabel *icon = (IconLabel *)(labelv[n+1]);
	
		string name = showName( label->category->name );
		if( name == "" )
			name = label->category->calcTitle();

		int i = name.find( ";" );
		if(i != -1 )
			name = name.substr( 0, i );

		label->setText( wrapLabel( name.c_str(), maxwidth, this ).c_str() );
		label->setGeometry( 22, h, maxwidth, label->sizeHint().height()-4 );
		icon->setGeometry( 4, h, 16, 16 );

		h += label->size().height()+2;	
	}

	return h; 
}

void Browser::setTitleLabelColors()
{
	QColorGroup group;
	group.setColor( QColorGroup::Background, config->titleBackground() );
	group.setColor( QColorGroup::Foreground, config->titleForeground() );
	titleLabel->setPalette( QPalette( group, group, group ) );
}

void Browser::setBackgroundColor()
{
	QColorGroup group = scrollView->viewport()->colorGroup();
	QColorGroup group2 = group;

	group.setColor( QColorGroup::Dark, QColor( config->backgroundColor() ) );
	scrollView->viewport()->setPalette( QPalette( group, group, group ) ); 

	group2.setColor( QColorGroup::Background, QColor( config->backgroundColor() ) );
	scrollWidget->setPalette( QPalette( group2, group2, group2 ) );
	group2.setColor( QColorGroup::Dark, QColor( darkGray ) );
	genSep->setPalette( QPalette( group2, group2, group2 ) );
	maskSep->setPalette( QPalette( group2, group2, group2 ) );
}

void  Browser::initDialog()
{
	if( config->maincoords )
		this->setGeometry( *(config->maincoords) );
	else	
		this->resize(150,330);

	folder = QPixmap( (const char **)folder_xpm );

	buildToolbar();

	catmenu = new QPopupMenu();
	catinfoid = catmenu->insertItem( "&Information", this, SLOT(infoPressed()), ALT+Key_I );
	catnewsid = catmenu->insertItem( "&News", this, SLOT(newsPressed()), ALT+Key_N );
	catlinksid = catmenu->insertItem( "&Links", this, SLOT(linksPressed()), ALT+Key_G );
	catchatid = catmenu->insertItem( "&Chat", this, SLOT(chatPressed()), ALT+Key_C );
	catdiscussid = catmenu->insertItem( "&Discuss", this, SLOT(discussPressed()), ALT+Key_D );
	catfaqid = catmenu->insertItem( "&Faqs", this, SLOT(faqPressed()), ALT+Key_Q );
	catbaseid = catmenu->insertItem( "&Bases", this, SLOT(basePressed()), ALT+Key_B );
	catmlistid = catmenu->insertItem( "Mailin&g lists", this, SLOT(mlistPressed()), ALT+Key_Y );
	
	movemenu = new QPopupMenu();
	movebackid = movemenu->insertItem( "&Back", this, SLOT(backPressed()), ALT+Key_Left );
	movefwdid = movemenu->insertItem( "&Forward", this, SLOT(forwardPressed()), ALT+Key_Right );
	movemenu->insertSeparator();
	moverootid = movemenu->insertItem( "&New Search", this, SLOT(rootPressed()), ALT+Key_R );
	movemarkid = movemenu->insertItem( "&Mark", this, SLOT(markPressed()), ALT+Key_M );
	movetomarkid = movemenu->insertItem( "&To Mark", this, SLOT(tomarkPressed()), ALT+Key_T );
	movestopid = movemenu->insertItem( "&Stop", this, SLOT(stopPressed()), Key_Escape );

	rightmenu = new QPopupMenu();

	rightinfoid = rightmenu->insertItem( "&Information", this, SLOT( infoPressed() ), 0 );
	rightnewsid = rightmenu->insertItem( "&News", this, SLOT( newsPressed() ), 0 );
	rightmenu->insertSeparator();
	rightlinksid = rightmenu->insertItem( "&Links", this, SLOT(linksPressed()), 0 );
	rightchatid = rightmenu->insertItem( "&Chat", this, SLOT(chatPressed()), 0 );
	rightdiscussid = rightmenu->insertItem( "&Discuss", this, SLOT(discussPressed()), 0 );
	rightbaseid = rightmenu->insertItem( "&Bases", this, SLOT(basePressed()), 0 );
	rightfaqid = rightmenu->insertItem( "&Faqs", this, SLOT(faqPressed()), 0 );
	rightmlistid = rightmenu->insertItem( "&Mailing lists", this, SLOT(mlistPressed()), 0 );
	rightmenu->insertSeparator();
	rightopenid = rightmenu->insertItem( "&Open", this, SLOT(extensionOpen()), 0 );
	rightopenwid = rightmenu->insertItem( "Open &With", this, SLOT(extensionOpenWith()), 0 );
	rightcopyid = rightmenu->insertItem( "&Copy Link Location", this, SLOT(copyLinkLocation()), 0 );

	editmenu = new QPopupMenu();
	editsourceid = editmenu->insertItem( "View Page &Source", this, SLOT(viewPageSource()), CTRL+Key_S );
	editdebugid = editmenu->insertItem( "&Debug Window", this, SLOT(debugWindowPressed()), CTRL+Key_Z );
	editmenu->insertSeparator();
	editclearid = editmenu->insertItem( "&Clear Cache", this, SLOT(clearCachePressed()), CTRL+Key_E );	

	bmmenu = new QPopupMenu();

	mainmenu = new QPopupMenu();
	menuBar()->insertItem( "M&enu", mainmenu );
	menuBar()->insertSeparator();

	mainmenu->insertItem( "&Category Options", catmenu, 0 );
	mainmenu->insertItem( "&Navigation", movemenu, 0 );
	mainmenu->insertSeparator();
	if( config->editingOptions() )
	 	editmenuid = mainmenu->insertItem( "&Editing Options", editmenu, CTRL+Key_E );
	bmmenuid = mainmenu->insertItem( "&Bookmarks", bmmenu, 0 );
	mainmenu->insertItem( "Mailing &Lists", this, SLOT(showMailingLists()), CTRL+Key_M );
	mainmenu->insertItem( "&Preferences", this, SLOT(showPreferences()), CTRL+Key_P ); 
	mainmenu->insertSeparator();
	mainmenu->insertItem( "Open &File", this, SLOT(openFile()), CTRL+Key_O );
	mainmenu->insertItem( "Open &URL", this, SLOT(openURL()), CTRL+Key_U );
	mainmenu->insertSeparator();
	mainmenu->insertItem( "E&xit", qApp, SLOT(quit()), CTRL+Key_X );

	QPopupMenu *helpmenu = new QPopupMenu();
	menuBar()->insertItem( "&Help", helpmenu );

	helpmenu->insertItem( "&Contents", this, SLOT(uhm_oops()), Key_F1 );
	helpmenu->insertItem( "&Quick Start", this, SLOT(uhm_oops()), 0 );
	helpmenu->insertSeparator();
	helpmenu->insertItem( "About &Kascade", this, SLOT(about()), 0 );
	helpmenu->insertItem( "About &Qt", this, SLOT(aboutQt()), 0 );
	helpmenu->insertItem( "About K&DE", this, SLOT(aboutKDE()), 0 );
	helpmenu->insertSeparator();
	helpmenu->insertItem( "Er&nesto Dufour", this, SLOT(aboutAapje()), CTRL+Key_N );

	QWidget *central = new QWidget( this );
	setCentralWidget( central );
 	central->setMinimumSize( 0, 0 );

	grid = new QVBoxLayout( central );  

	titleLabel = new QLabel( central );
	titleLabel->setMargin( 2 );
	titleLabel->setMinimumSize( 0, 0 );
	titleLabel->setAlignment( AlignCenter );
	setTitleLabelColors();
	titleLabel->setText( "Untitled" );
	grid->addWidget( titleLabel );
 
	scrollView = new QScrollView( central );
	scrollView->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
	scrollView->setVScrollBarMode( QScrollView::AlwaysOn );
	scrollView->setMinimumSize( 0, 0 );
	scrollView->setHScrollBarMode( QScrollView::AlwaysOff );
	
	grid->addWidget( scrollView );
	
	scrollWidget = new IconLabel( scrollView );
	scrollView->addChild( scrollWidget );
	QObject::connect( scrollWidget, SIGNAL( rightMenu( int, int ) ),
			  this, SLOT( showRightMenu( int, int ) ) );
	
	QHBoxLayout *ownerLayout = new QHBoxLayout();
	grid->addLayout( ownerLayout );

	Bowner = new OwnerButton( central );
	QToolTip::add( Bowner, "View owner homepage" );
	ownerLayout->addWidget( Bowner );

	mailButton = new QPushButton( central );
	QPixmap mailIcon = QPixmap( (const char **)mailicon_xpm );
	mailButton->setPixmap( mailIcon );
	mailButton->setFixedWidth( 34 );
	mailButton->setCursor( pointingHandCursor );
	QToolTip::add( mailButton, "Send mail to owner" );
	ownerLayout->addWidget( mailButton );

	QObject::connect( Bowner, SIGNAL( clicked() ), this, SLOT( gotoHomepage() ) );
	QObject::connect( mailButton, SIGNAL( clicked() ), this, SLOT( sendEmail() ) );
 
	( genSep = new Separator( scrollWidget, "Related" ) )->hide();
	( maskSep = new Separator( scrollWidget, "Deselected" ) )->hide();	

	keyboard = new Keyboard();
	chatBox = new ChatBox();
	sourceBox = new SourceBox();
	debugWindow = new SourceBox(); 
	debugWindow->resize( 410, 250 );
	bookmarks = new Bookmarks();
	mailinglists = new MailingLists();

	markcurrents = 0;

	bookmarks->load();
	mailinglists->load();
	buildBookmarkMenu();

	setFont( config->browserFont() );
	maskSep->adjustFont( config->browserFont() );
	genSep->adjustFont( config->browserFont() );

	setBackgroundColor();

	statusBar()->message( "Ready.." );  
	if( !config->statusBar() )
		statusBar()->hide();
	if( !config->upperToolbar() )
		toolBar->hide();	

	setCaption( "Kascade" );

	extcat = 0;	

	enableDisable( TRUE );
}

void Browser::enableDisable( int i )
{
	TBinfo->setEnabled( i ? FALSE : cCategory->info != "" );
	TBnews->setEnabled( i ? FALSE : cCategory->news != "" );
	TBback->setEnabled( i ? FALSE : backptr != -1 );
    	TBforward->setEnabled( i ? FALSE : backlast > backptr + 1 );
	TBlinks->setEnabled( i ? FALSE : cCategory->linkv || cCategory->basev );
	TBdiscuss->setEnabled( i ? FALSE : cCategory->discussv );
	TBbase->setEnabled( i ? FALSE : cCategory->basev );
	TBmark->setEnabled( i ? FALSE : cCategory ); 
	TBtomark->setEnabled( i ? FALSE : markaddress != "" );
	TBchat->setEnabled( i ? FALSE : cCategory );

	Bowner->setEnabled( i ? FALSE : cCategory );
	mailButton->setEnabled( i ? FALSE : cCategory );

	catmenu->setItemEnabled( catinfoid, i ? FALSE : cCategory->info != "" );
	catmenu->setItemEnabled( catnewsid, i ? FALSE : cCategory->news != "" );
	catmenu->setItemEnabled( catlinksid, i ? FALSE : cCategory->linkv || cCategory->basev );
	catmenu->setItemEnabled( catchatid, i ? FALSE : cCategory );
	catmenu->setItemEnabled( catbaseid, i ? FALSE : cCategory->basev );
	catmenu->setItemEnabled( catfaqid, i ? FALSE : cCategory->faqv );
	catmenu->setItemEnabled( catmlistid, i ? FALSE : cCategory->mlistv );
	catmenu->setItemEnabled( catdiscussid, i ? FALSE : cCategory->discussv );

	movemenu->setItemEnabled( movebackid, i ? FALSE : backptr != -1 );
	movemenu->setItemEnabled( movefwdid, i ? FALSE : backlast > backptr + 1 );
	movemenu->setItemEnabled( movemarkid, i ? FALSE : cCategory );
	movemenu->setItemEnabled( movetomarkid, i ? FALSE : markaddress != "" );

	rightmenu->setItemEnabled( rightinfoid, i ? FALSE : cCategory->info != "" );
	rightmenu->setItemEnabled( rightnewsid, i ? FALSE : cCategory->news != "" );
	rightmenu->setItemEnabled( rightchatid, i ? FALSE : cCategory );
	rightmenu->setItemEnabled( rightlinksid, i ? FALSE : cCategory->linkv );
	rightmenu->setItemEnabled( rightbaseid, i ? FALSE : cCategory->basev );
	rightmenu->setItemEnabled( rightfaqid, i ? FALSE : cCategory->faqv );
	rightmenu->setItemEnabled( rightmlistid, i ? FALSE : cCategory->mlistv );
	rightmenu->setItemEnabled( rightdiscussid, i ? FALSE : cCategory->discussv ); 

	editmenu->setItemEnabled( editsourceid, i ? FALSE : cCategory );
	editmenu->setItemEnabled( editclearid, i ? FALSE : cCategory );

	bmmenu->setItemEnabled( bmaddid, i ? FALSE : cCategory );
}

void Browser::aboutQt()
{
	QMessageBox::aboutQt( this, "About Qt" );
}

void Browser::about()
{
	QMessageBox::about( this, "About Kascade",
				  "Kascade stands for a novel way of searching and\n"
				  "communicating via the Internet.\n\n"
				  "Kascade is an Open Directory tool, such as Dmoz, but with\n"
				  "a distributed nature: someone's contribution is located on\n"
				  "their own server. Kascade is open in every sense, free and\n"
				  "immune to company or government control.\n\n" 
				  "Please visit the Kascade site at http://kascade.org.\n" );
}

void Browser::aboutKDE()
{
	QMessageBox::about( this, "About KDE",
				"The KDE Desktop Environment was written by the KDE Team,\n"
				"a world-wide network of software engineers committed to\n"
				"free software development.\n\n"
				"Visit http://www.kde.org for more information on the KDE\n"
				"Project. Please consider joining and supporting KDE.\n\n"
				"Please report bugs at http://bugs.kde.org.\n" );
}

void Browser::uhm_oops()
{
	QMessageBox::about( this, "Not yet implemented!",
				"This option has not yet been implemented!\n"
				"If you want me to fix this quickly, send me an email at:\n\n"
				"mark@kascade.org\n\n"
				"This is also the place for bug reports and suggestions.\n" );
}

void Browser::aboutAapje()
{
	AapjeDialog *dialog = new AapjeDialog( this, "snurgl" );
	dialog->show();	
}

void Browser::timedMessage( string msg, int time )
{
	statusBar()->message( msg.c_str() );
	QTimer::singleShot( time, this, SLOT( setReady() ) ); 
}

void Browser::setReady()
{
	statusBar()->message( "Ready.." );
}
