#include "choicebox.h"
#include "globals.h"
#include "browser.h"
#include "chatbox.h"
#include "preferences.h"
#include "utility.h"
#include "categorylabel.h"

#include <qcolor.h>
#include <qfont.h>
#include <qtooltip.h>

ChoiceBox::ChoiceBox( vector<string> &namev, vector<string> &memoryv, vector<string> &descv, string caption, QWidget *parent ) : QDialog( parent, 0, FALSE )
{
	selected = 0;
	if( highlight == -1 )
		selected = -1;

	this->namev = namev;
	this->memoryv = memoryv;
	this->descv = descv;

	setCaption( caption.c_str() );

	scrollView = new QScrollView( this );
	scrollView->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
	scrollView->setVScrollBarMode( QScrollView::AlwaysOn );
//	scrollView->setMinimumSize( 0, 0 );
	scrollView->setHScrollBarMode( QScrollView::AlwaysOff ); 

	QColorGroup group;
	group.setColor( QColorGroup::Dark, QColor( white ) );
	scrollView->viewport()->setPalette( QPalette( group, group, group ) ); 

	cancel = new QPushButton( "Close", this );
	connect( cancel, SIGNAL(clicked()), SLOT(close()) );

	resize( 420, 250 );
	setMinimumSize( 150, 100 );

	scrollWidget = new QLabel( this );
	scrollView->addChild( scrollWidget );
	scrollWidget->resize( 1000, 1000 );

	QColorGroup group2;
	group2.setColor( QColorGroup::Background, QColor( white ) );
	scrollWidget->setPalette( QPalette( group2, group2, group2 ) ); 

	addLabels();
	setLabelColors();
	show();
	resizeEvent(0);
}

void ChoiceBox::keyPressEvent( QKeyEvent *event )
{
	int key = event->key();

	vector<int> &keybindingv = config->keyBindingv();
	for( unsigned int n = 0; n < keybindingv.size(); n += 2 )
		if( keybindingv[n+1] == key )
		{
			key = keybindingv[n];
			break;
		}	

	if( key == Key_Up )
	{
		if( selected == -1 )
			selected = labelv.size()/2-1;
		else
			selected--;
	}
	
	else if( key == Key_Down )
	{
		if( selected == labelv.size()/2-1 )
			selected = -1;
		else
			selected++;
	}

	else if( ( key == Key_Right ) && 
		 ( selected != -1 ) )
	{	 
		emit choiceMade( memoryv[selected] );
		emit choiceMade( namev[selected], memoryv[selected] );
	}	

	else if( key == Key_Home )
		selected = 0;
	else if( key == Key_End )
		selected = labelv.size()/2-1;
	else if( key == Key_Escape )
	{
		close();
		return;
	}
	
	setLabelColors();	
	checkScrollHeight();
}

void ChoiceBox::setLabelColors()
{
	QColorGroup group1;
	group1.setColor( QColorGroup::Foreground, QColor( blue ) );
	group1.setColor( QColorGroup::Background, QColor( white ) );

	QColorGroup group2;
	group2.setColor( QColorGroup::Foreground, QColor( white ) );
	group2.setColor( QColorGroup::Background, QColor( darkBlue ) );

	for( unsigned int n = 0; n < labelv.size(); n += 2 )
		if( n == 2*selected )
			labelv[n]->setPalette( QPalette( group2, group2, group2 ) );
		else
			labelv[n]->setPalette( QPalette( group1, group1, group1 ) );
}

void ChoiceBox::checkScrollHeight()
{
        if( selected == -1 ) 
                return;
			
        int viewtop = scrollView->contentsY();
        int viewbottom = viewtop + scrollView->viewport()->height();
        int labeltop = labelv[2*selected]->y();
        int labelbottom = labelv[2*selected+1]->y() + labelv[2*selected+1]->height();

        if( labelbottom+10 > viewbottom ) 
                scrollView->setContentsPos( 0, labelbottom+10-(viewbottom-viewtop) );
        else if( labeltop-10 < viewtop )
                scrollView->setContentsPos( 0, labeltop-10 );
}         

void ChoiceBox::addLabels()
{
	QColorGroup group;
	group.setColor( QColorGroup::Background, QColor( white ) );

	QFont f = this->font();
	f.setUnderline( TRUE );

	for( unsigned int n = 0; n < namev.size(); n++ )
	{
		CategoryLabel *label = new CategoryLabel( scrollWidget, 0, memoryv[n] );
		label->setFont( f );
		label->setCursor( QLabel::pointingHandCursor );
		QObject::connect( label, SIGNAL( LeftMouseButtonClicked( string, string ) ), this, SLOT( gotOne( string, string ) ) );
		labelv.push_back( label );
		QToolTip::add( label, memoryv[n].c_str() );

		QLabel *description = new QLabel( scrollWidget );
		description->setPalette( QPalette( group, group, group ) );
		labelv.push_back( description );

//		scrollView->addChild( label );
//		scrollView->addChild( description );
	}		 
}

void ChoiceBox::gotOne( string name, string memory )
{
	emit choiceMade( memory );
	emit choiceMade( name, memory );
}

void ChoiceBox::resizeLabels()
{
	int maxwidth = scrollView->viewport()->size().width();
	int h = 10;

        for( unsigned int n = 0; n < labelv.size(); n += 2 )
	{
		labelv[n]->setGeometry( 10, 10, 100, 100 );
		labelv[n+1]->setGeometry( 10, 10, 100, 100 );

		labelv[n]->setText( wrapLabel( namev[n/2], maxwidth-10, this ).c_str() );
		labelv[n]->setGeometry( 10, h, maxwidth-10, labelv[n]->sizeHint().height() );

		h += labelv[n]->size().height()+5;	

		labelv[n+1]->setText( wrapLabel( descv[n/2], maxwidth-35, this ).c_str() );
		labelv[n+1]->setGeometry( 35, h, maxwidth-40, labelv[n+1]->sizeHint().height() );
		
		h += labelv[n+1]->size().height()+10;	 
	}

	scrollWidget->resize( scrollView->viewport()->width(), h );
}

void ChoiceBox::resizeEvent( QResizeEvent * )
{
	int width = this->width();
	int height = this->height();

	scrollView->setGeometry( 10, 10, width-20, height-60 );
	cancel->setGeometry( width/2-45, height-40, 90, 30 );

	resizeLabels();
}	
