#include <qapplication.h>
#include <qstatusbar.h>
#include <qtimer.h>
#include <qmessagebox.h>
#include <iostream>

#include "http.h"
#include "globals.h"
#include "browser.h"
#include "errors.h"
#include "preferences.h"

Http::Http() : QObject()
{
	QObject::connect( &socket, SIGNAL( connected() ), this, SLOT( connected() ) );
	QObject::connect( &socket, SIGNAL( connectionClosed() ), this, SLOT( closed() ) );
	QObject::connect( &socket, SIGNAL( readyRead() ), this, SLOT( readyRead() ) );

	QObject::connect( browser, SIGNAL( stopSignal() ), this, SLOT( abort() ) );
}

int Http::getFile( string address )
{
	browser->statusBar()->message( "Connecting.." );
	myapp->processEvents();

	host = address.substr( 7, address.find( "/", 7 )-7 );
	filename = address; 
	
#ifdef DEBUGOUTPUT
	cout << "getting " + address << endl;
#endif	

	QTimer::singleShot( config->timeoutValue(), this, SLOT( error() ) ); 

	socket.connectToHost( host.c_str(), 80 );
	
	socketClosed = FALSE;
	aborted = FALSE;

	sourcev = new vector<string>;
	
	while( !socketClosed )
		myapp->processEvents();

//	if( aborted )
//		cout << "grr aborted" << endl;

	if( sourcev->empty() || 
	    aborted )
		success = FALSE;	
	else
	{
		success = ( (*sourcev)[0].find( "200 OK" ) != -1 );
	
		do
			sourcev->erase( sourcev->begin(), sourcev->begin()+1 );
		while( (*sourcev)[0] != "" );
	}
	
	if( !success )
		delete sourcev;

	browser->statusBar()->message( "Ready.." );
	return success;
}

void Http::connected()
{
	//cout << "connected.." << endl;

	string s = "GET " + filename + " HTTP/1.0\r\n\r\n";
	socket.writeBlock( s.c_str(), s.length() );
}

void Http::readyRead()
{
	//cout << "incoming.." << endl;
	browser->statusBar()->message( "Reading.." );

	while( socket.canReadLine() )
	{
		string s = (const char *)( socket.readLine() );

		int i;
		while( ( i = s.find_first_of( "\n\r" ) ) != -1 )
			s.erase( i, 1 );

		sourcev->push_back( s );
		//cout << "$" + s << endl;
	}	
}

void Http::closed()
{
	//cout << "closed.." << endl;

	socketClosed = TRUE;
}	

void Http::error()
{
	socketClosed = TRUE;
}

void Http::abort()
{
//	cout << "kwad" << endl;

	QMessageBox::about( 0, "Aborted", "HTTP Transmission aborted by user" );

	aborted = TRUE;
	socketClosed = TRUE;
}
