#include <iostream>
#include "category.h"
#include "currents.h"
#include "globals.h"
#include "navigation.h"
#include "parser.h"
#include "addressing.h"
#include "utility.h"
#include "errors.h"
#include "summation.h"
#include "expression.h"
#include "exprnode.h"
#include "tracing.h"
#include "files.h"

#ifdef GUI
#include <qmessagebox.h>
#include <qinputdialog.h>

#include "preferences.h"
#include "browser.h"
#include "infobox.h"
#endif

// enter a category and follow references. used in many places.
// this is the centerpiece of the navigation module.

int enter( Category *category )
{
	//if( !checkingstructure ) cout << "ENTER " + category->name << endl;

        if( !checkLoop( category ) )
                return FALSE;

	checkWarning( category );
	
        Currents c; c.save();
	
	cCategory = category->parent;

        if( category->summation )
        {
		if( checkingstructure )
		{	
			cCategory = category;
			return TRUE;
		}
		
		if( !category->expanded )
		{
			vector<Category *> s_loopCatv = loopCatv;
                    	if( !expandSummation( category ) )
                        	BACKTRACK
			loopCatv = s_loopCatv;	
		}

		cCategory = category;		
        }
        else if( category->target != "" )
        {
                if( category->mask )
                {
			if( checkingstructure )
			{
				cCategory = category;
				return TRUE;
			}

                        if( !enterMask( category ) )
                                BACKTRACK
			category->visited = TRUE;	
                }
                else if( category->selection )
                {
                        if( !enterSelection( category ) )
                                BACKTRACK
                }
                else if( !enterNormal( category ) )
			BACKTRACK
        }
        else
                cCategory = category;

        checkMask( category );

        return TRUE;
}

// enter a category that has a normal reference; handle passed and user arguments

int enterNormal( Category *category )
{
	string target = category->target;
	vector<string> argumentv;

	if( !getUserArgs( target ) )
		return FALSE;

	// expand arguments
	int i;
	for( unsigned int n = 0; n < argv.size(); n += 2 )
		while( ( i = target.find( argv[n] ) ) != -1 )
			target.replace( i, argv[n].length(), argv[n+1] );

	if( !parseArguments( target, argumentv, category ) ) 
		return FALSE;
					
	Currents c; c.save();

	for( unsigned int n = 0; n < argumentv.size(); n += 2 )
		if( !vectorContains( argv, argumentv[n], 2 ) )
		{
			argv.push_back( argumentv[n] );
			argv.push_back( argumentv[n+1] );
		}	

	if( !gotoAddress( target, category ) )
		BACKTRACK
	return TRUE;
}

// prompt user for required arguments

int getUserArgs( string &address )
{
	if( checkingstructure )
		return TRUE;

	int i, j;
	while( ( i = address.find( "%" ) ) != -1 )
	{	
		if( ( j = address.find( "%", i+1 ) ) == -1 )
			return TRUE;

		string arg;
#ifdef GUI
		if( !getInput( arg, address.substr( i+1, j-i-1 ) ) )
			return FALSE;
#else
		cout << "enter " << address.substr( i+1, j-i-1 ) << ":" << endl;
		cin >> arg;
#endif

		address.replace( i, j-i+1, arg );
	}

	return TRUE;
}

// parse arguments, if present

int parseArguments( string &address, vector<string> &argumentv, Category *category )
{
	int i;
	if( ( i = address.find( ';' ) ) == -1 )
		return TRUE;

	string args = address.substr( i+1, address.length()-i-1 );
	address = trim( address.substr( 0, i ) );

	vector<string> newv;
	dirToVec( args, newv, ',', FALSE );

	for( unsigned int n = 0; n < newv.size(); n++ )
	{
		if( ( i = newv[n].find( '=' ) ) <= 0 )
		{
			showNavigationError( category, "syntax error in argument definition" );
			return FALSE;
		}
			
		argumentv.push_back( "_" + trim( newv[n].substr( 0, i ) ) );
		argumentv.push_back( trim( newv[n].substr( i+1, newv[n].length()-i-1 ) ) );
	}
		
	return TRUE;
}

// check to see if we're not entering a reference loop.
// used by enter( .. )

int checkLoop( Category *category )
{
        for( unsigned int n = 0; n < loopCatv.size(); n++ )
                if( loopCatv[n] == category )
                {
                        if( !checkingstructure )
                                showNavigationError( category, "category (in)directly points to itself ; )" );
                        return FALSE;
                }

        loopCatv.push_back( category );
        return TRUE;
}

// drop mask expressions when we have entered a real subcat
// used by enter( .. )

void checkMask( Category *category )
{
        if( category->realsubcat )
        {
                maskv.clear();
                masksv.clear();
        }
}

// automatically enter the right subcategories if selection is active.
// used by enter( .. )

int checkSelection( )
{
        if( selectionv.empty() || !cCategory->subCatv )
                return TRUE;

	int found = FALSE;
        for( unsigned int n = 0; n < loopCatv.size(); n++ )
		if( loopCatv[n]->realsubcat )
		{
			found = TRUE;
			break;
		}
	if( !found ) 
		return TRUE;
	
        Currents c; c.save();

        string selection = selectionv[ selectionv.size()-1 ];
        selectionv.pop_back();

	vector<Category *> s_loopCatv = loopCatv;
	loopCatv.clear(); // experimental

        if( !gotoInternal( selection ) )
        {
                selectionentered = FALSE;
                selectionv.push_back( selection );
                return FALSE;
        }

	loopCatv = s_loopCatv;
        selectionentered = TRUE;
        skippedCat = c.c_cCategory;
        return TRUE; 
}

// enter category that has a selection reference. used by enter( .. )

int enterSelection( Category *category )
{
        //if( !gotoAddress( category->target, category ) )
	if( !enterNormal( category ) )
                return FALSE;
	
	string selection = (*(category->data1v))[0];

	for( unsigned int n = 0; n < selectionv.size(); n++ )
		if( selectionv[n] == selection )
			return TRUE;
	
        // complex task: determine if selection should be added at
        // the front or at the back of selectionv.

        int nrofsel = 0;
        for( unsigned int n = 0; n < loopCatv.size(); n++ )
                if( loopCatv[n]->selection )
                        nrofsel++;
	
        if( nrofsel == 1 )
            selectionv.push_back( selection );
        else
            selectionv.insert( selectionv.begin(), selection );

        return TRUE;
}

// enter category that has a mask reference. used by enter( .. )

int enterMask( Category *category )
{
    	if( !gotoAddress( category->target, category ) )
        	return FALSE;

    	vector<ExprNode *> exprv;
    	vector<string> maskstringv;
    	string maskstring;

    	// parse mask expressions

    	for( unsigned int x = 0; x < category->data1v->size(); x++ )
    	{
        	maskstring = (*(category->data1v))[x];
        	ExprNode *expr = createExprTree( maskstring );
        	
		if( expr == 0 )
            		return FALSE;

        	exprv.push_back( expr );
        	maskstringv.push_back( maskstring );
    	}

    	// update the current mask vector

    	for( unsigned int x = 0; x < exprv.size(); x++ )
    	{
        	int exists = FALSE;

        	for( unsigned int y = 0; y < masksv.size(); y++ )
	    	if( masksv[y] == maskstringv[x] )
                	exists = TRUE;

        	if( !exists )
       	 	{
            		maskv.push_back( exprv[x] );
            		masksv.push_back( maskstringv[x] );
        	}
   	} 

    	return TRUE;
}

// take us to a certain address. 
// consists of three functions, of which gotoRecursive does the real work

int gotoAddress( string address )
{
	return gotoAddress( address, 0 );
}

int gotoAddress( string address, Category *category )
{
    	Currents c; c.save();

    	if( !gotoRecursive( address, category ) )
        	BACKTRACK;

    	return TRUE;
}

int gotoRecursive( string address, Category *category )
{
    	int p_dii;
    	string p_extdir, p_file, p_intdir;
	
//	if( category && !checkingstructure  )
//		cout << "GOTOREC " + address + " CAT " + category->name << endl;

    	if( !parseAddress( address, p_dii, p_extdir, p_file, p_intdir ) )
        	return FALSE;

/*    	if( !checkingstructure )
    		cout << "DII " << p_dii << endl << "EXTDIR " << p_extdir << endl << "FILE " << p_file << endl << "INTDIR " << p_intdir << endl; */

    	if( p_dii )
    	{
        	if( !loadDIIFile( p_extdir, p_file ) )
		{
			if( checkingstructure )
				cCategory = category;
			
            		return FALSE;
		}	
    	}
    	else if( p_extdir != "" )
    	{
		extensionlaunched = TRUE;
		extensionaddress = p_extdir;

        	if( checkingstructure )
		{
			cCategory = category;
            		return TRUE;
		}	

		launchExtension( p_extdir );

		category->visited = TRUE;
        	return FALSE;
    	}

    	if( ( p_intdir != "" ) &&
            !gotoInternal( p_intdir ) ) // (remaining) rel. address
        	return FALSE;

    	return TRUE;
}

// used by gotoRecursive(..) for internal addresses. in turn calls enter(..)

int gotoInternal( string address )
{
    	//cout << "INTERNAL " << address << endl << "FROM " << cCategory->name << endl;

	// handle internal absolute prefix '/'
	
	if( ( address != "" ) &&
	    ( address[0] == '/' ) )
	{
		address.erase( 0, 1 );
	
		while( cCategory->parent )
			cCategory = cCategory->parent;
	}
	
    	if( address == "" )
        	return TRUE;

	// process directories one at a time
	
    	int i = -1;
    	do
    	{
		string dir;
		int j;
		if( ( j = address.find( '/', i+1 ) ) != -1 ) 
	    		dir = address.substr( i+1, j-i-1 ); 
		else
	    		dir = address.substr( i+1, address.length()-i-1 );
        	//cout << "DIR " << dir << endl;

        	vector<Category *> *subCats = cCategory->subCatv;
		int founddir = FALSE;

        	// skip "."'s

        	if( dir == "." )
            		founddir = TRUE;

        	// try ".."'s

        	else if( dir == ".." )
        	{
            		if( cCategory->parent == 0 )
            		{
				showNavigationError( cCategory, "root category has no parent" );
                		return FALSE;
            		}

            		cCategory = cCategory->parent;
            		founddir = TRUE;
        	}

        	// now try full name or abbreviation

        	Category *match = 0;
		int ambiguity = FALSE;
		vector<string> ambcatv;

        	if( !founddir &&
                    subCats )
        	{
            		for( unsigned int n = 0; n < subCats->size(); n++ )
                		if( equalCI( (*subCats)[n]->name, dir ) )
                		{
                    			match = (*subCats)[n];
					break;
                		}

            		if( !match )
                	for( unsigned int n = 0; n < subCats->size(); n++ )
                    		if( startsWithCI( (*subCats)[n]->name, dir ) )
                    		{
					if( match ) 
						ambiguity = TRUE;
                        		match = (*subCats)[n];
					ambcatv.push_back( match->name );
                    		}

			if( ambiguity )
			{
				showNavigationError( cCategory, "\"" + dir + "\" is ambiguous. it could mean:\n" + vecToDir( ambcatv, "\n" ) );
				match = 0;
			}	
			
			if( match )
                		founddir = TRUE;
        	}

        	if( !founddir ) // if still not found, display an error
        	{
			if( !ambiguity )
	                	showNavigationError( cCategory, "\"" + dir + "\" category cannot be resolved" );
                	return FALSE;
        	}

        	// forwarding

        	if( founddir &&
            	    match &&
            	    !enter( match ) )
            		return FALSE;

    	} while( ( i = address.find( '/', i+1 ) ) != -1 );

    	return TRUE;
}

// text-mode interface main loop

void traverseDII( )
{
    	cout << endl << "KASCADE BROWSER / TEXTMODE BUILD" << endl << endl;

    	cCategory->printCategory();

    	for( ;; )
    	{
        	cout << "choice: ";

		char choice;
		cin >> choice;

		if( choice == 'q' )
			break;

		if( choice == 'v' )
		{
			int i;
			cached( cPath, cFile, i );
            		vector<string> *sourcev = cacheSourcev[i];

            		cout << endl;

            		for( unsigned int n = 0; n < sourcev->size(); n++ )
            		{
                 		printint( n+1, sourcev->size() );
                 		cout << " " << (*sourcev)[n] << endl;
            		}
					
			continue;
		}
		
        	if( ( '0' <= choice ) &&
            	    ( choice <= '9' ) )
        	{
	    		unsigned int i;
            		if( ( cCategory->subCatv != 0 ) &&
                	    ( ( i = ( choice - '0' ) ) < cCategory->subCatv->size() ) )
	    		{
                		if( action_enter( (*(cCategory->subCatv))[i] ) ) 
					cCategory->printCategory();
            		} 
	    		else
				cout << "*** TRY A SMALLER NUMBER" << endl;

			continue;
		}

		string address;

		switch( choice )
		{
			case 's': 	cCategory->printCategory();
        	    			break;

			case 'r': 	action_jump( "dii/root.dii" ); 
					cCategory->printCategory();
					break;

			case 'b': 	if( backTrace() )
	                			cCategory->printCategory();
					break;
		
			case 'c': 	clearCache();
					break;

			case 'f':	if( fwdTrace() )
                				cCategory->printCategory();
					break;

            		case 'h':	cout << endl << "KASCADE BROWSER / TEXTMODE BUILD" << endl << endl
                 			<< "0-9:    choose subcategory" << endl
		 			<< "b:      netscape-like back" << endl
		 			<< "f:      netscape-like forward" << endl 
                 			<< "s:      display subcategories" << endl
					<< "c:      clear cache and refresh" << endl
                 			<< "r:      goto root category" << endl
                 			<< "v:      view category source file" << endl
                 			<< "q:      quit to shell prompt" << endl << endl;
					
					break;
					
			default:	cout << "*** UNKNOWN COMMAND" << endl;
		}
    	} 
}
 
// test to see if the current category is 'empty'
// if it is, but is has info or links, show these

int testEmpty() 
{
	if( !cCategory->subCatv &&
   	    ( cCategory->linkv ) )
	{
		cCategory->visited = TRUE;
		showLinks();
	}	

	else if( !cCategory->subCatv &&
	         ( cCategory->chatv ) )
	{
		cCategory->visited = TRUE;
		showChat();
	}

	else if( !cCategory->subCatv && 
	         ( cCategory->info != "" ) )
	{
//		cCategory->visited = TRUE;
		showInformation();
	}

	else if( cCategory->empty() )
	{
//		cCategory->visited = TRUE;
		showNavigationError( cCategory, "empty category" );
	}	
	else
		return FALSE;

	return TRUE;
}

// the user selects a category.

int action_enter( Category *category )
{
	Currents c; c.save();

	selectionentered = FALSE;
	loopCatv.clear();

	int entered = enter( category );
	showParseWarnings();
	parsewarningv.clear();

	if( entered )
	{
		if( checkSelection() &&
		    !testEmpty() )
		{	
			if( c.changed() )
				addTrace( c );

			cCategory->visited = TRUE;	
			return TRUE;
		}
	}
	
	c.load();
	return FALSE;
}

// the user has indicated that the browser should jump to a certain address.
// examples: 'new search', 'goto bookmark', 'open file', 'open url'

int action_jump( string address )
{
	Currents c; c.save();

	if( clear_goto( address ) )
	{
		if( c.changed() )
			addTrace( c );

		return TRUE;
	}
	return FALSE;
}

int clear_goto( string address )
{
	Currents c; c.save();

	clear_environment();

	int success = gotoAddress( address );
	showParseWarnings();
	parsewarningv.clear();

	if( success && !testEmpty() )
	{
		cCategory->visited = TRUE;
		return TRUE;
	}
	else 
		BACKTRACK	
}

void clear_environment() 
{
	selectionentered = FALSE;
	loopCatv.clear();

	selectionv.clear();
	maskv.clear();
	masksv.clear();
	argv.clear();

	cPath = "";
}

// check if category has warning

void checkWarning( Category *category )
{
	if( ( category->warning != "" ) &&
	    !checkingstructure &&
	    !category->visited )
#ifdef GUI
                new InfoBox( "warning", category->warning, browser );
#else
		cout << category->warning << endl;
#endif
}

void showInformation()
{
#ifdef GUI
	browser->action_showinfo();
#else
	cout << cCategory->info << endl;
#endif
}

void showLinks()
{
#ifdef GUI
	browser->action_showlinks();
#else
	cout << "** has only links" << endl;
#endif
}

void showChat()
{
#ifdef GUI
	browser->action_chat();
#else
	cout << "** has only chat channels" << endl;
#endif
}

string debugInfo()
{
	string info;

	if( selectionv.size() )
		info += "selection: " + selectionv[0] + "\n\n";

	if( masksv.size() )
	{
		info += "masks:\n";

		for( unsigned int n = 0; n < masksv.size(); n++ )
			info += masksv[n] + "\n";

		info += "\n";
	}	

	vector<string> *propv = cCategory->propv;
        if( propv )
	{
		info += "properties:\n";
		
        	for( int n = 0; n < propv->size(); n += 2 )
		{
			info += (*propv)[n];
	    		if( (*propv)[n+1] != "" )
				info += " = " + (*propv)[n+1];
			info += "\n";	
		}

		info += "\n";
	}			

    	if( argv.size() )
	{
		info += "arguments:\n";

    	    	for( unsigned int n = 0; n < argv.size(); n += 2 )
			info += argv[n] + " = " + argv[n+1] + "\n";

		info += "\n";
	}
	
	return info;	
}

