/***************************************************************************
                          batchprinter.cpp  -  description
                             -------------------
    begin                : Sat Jan 10 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "batchprinter.h"

#include "definition.h"
#include "kbarcode.h"
#include "label.h"
#include "measurements.h"
#include "printersettings.h"

// Qt includes
#include <qfile.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qprogressdialog.h>

// KDE includes
#include <kapplication.h>
#include <kconfig.h>
#include <kimageio.h>
#include <klocale.h>
#include <kprinter.h>

BatchPrinter::BatchPrinter( KPrinter* p, QWidget* _parent )
    : printer( p ), parent( _parent )
{
    m_events = true;
}

BatchPrinter::BatchPrinter( const QString & path, QWidget* p )
    : m_path( path ), parent( p )
{
    KConfig* conf = kapp->config();

    conf->setGroup("ImageCreation");
    m_filename_article = conf->readBoolEntry( "FilenameArticle", "true" );
    m_format = conf->readEntry( "FileFormat", "PNG" );
}

BatchPrinter::~BatchPrinter()
{
    delete m_data;
    delete painter;
}

void BatchPrinter::start()
{
    painter = new QPainter( printer );
    QPaintDeviceMetrics pdm( painter->device() );

    pageh = pdm.height();   // in pixel

    curw = 0;
    curh = 0;
    c_h = 0;
    c_w = 0;

    QProgressDialog* progress = createProgressDialog( i18n("Printing...") );

    labelprinterdata* lpdata = PrinterSettings::getInstance()->getData();
    measure = def->getMeasurements();

    unsigned int index = 0; // counter gets increased for every label, but not for
                            // labels like article_no etc. (those who are created
                            // by events.

    moveLabels();
    for( unsigned int i = 0; i < m_data->count(); i++ ) {
        Label l( def, buffer, m_name, printer, m_customer,
                 (*m_data)[i].article_no, (*m_data)[i].group );
        l.setSerial( m_serial, m_increment );

        bool newgroup = false;
        if( i == 0 )
            newgroup = true;
        else {
            if( (*m_data)[i].group != (*m_data)[i-1].group )
                newgroup = true;
        }

        if( !curw )
            curw = measure->gapLeft( printer );

        if( !curh )
            curh = measure->gapTop( printer );

        if( m_events ) {
            if( newgroup ) {
                proccessEvents( lpdata->groupEvent1, i18n("Group : ") + (*m_data)[i].group, &l );
                proccessEvents( lpdata->groupEvent2, i18n("Group : ") + (*m_data)[i].group, &l );
                proccessEvents( lpdata->groupEvent3, i18n("Group : ") + (*m_data)[i].group, &l );
                proccessEvents( lpdata->groupEvent4, i18n("Group : ") + (*m_data)[i].group, &l );
            }
            proccessEvents( lpdata->articleEvent1, i18n("Article No. : ") + (*m_data)[i].article_no, &l );
            proccessEvents( lpdata->articleEvent2, i18n("Article No. : ") + (*m_data)[i].article_no, &l );
            proccessEvents( lpdata->articleEvent3, i18n("Article No. : ") + (*m_data)[i].article_no, &l );
            proccessEvents( lpdata->articleEvent4, i18n("Article No. : ") + (*m_data)[i].article_no, &l );
        }
        
        for( int z = 0; z < (*m_data)[i].number; z++ ) {
            changeLine();
            checkForNewPage( &l );

            painter->setClipRect( (int)curw, (int)curh, (int)measure->width( printer ), (int)measure->height( printer ) );
            l.setIndex( index );
            painter->drawPicture( (int)curw, (int)curh, *l.picture() );
            index++;
            painter->setClipping( false );

            drawBorders();

            curw += measure->gapH( printer );
            c_h++;

            if( !checkProgressDialog( progress) ) {
                printer->abort();
                painter->end();
                return;
            }
        }
    }

    painter->end();
    delete progress;
}

void BatchPrinter::startImages()
{
    QProgressDialog* progress = createProgressDialog( i18n("Creating Images...") );

    // TODO: check if this still works
    Measurements* measure = def->getMeasurements();

    painter = new QPainter();
    QPixmap pixmap( (int)measure->width( parent ), (int)measure->height( parent ) );
    for( unsigned int z = 0; z < m_data->count(); z++ ) {
        Label l( def, buffer, m_name, parent, m_customer,
                 (*m_data)[z].article_no, (*m_data)[z].group );
        l.setSerial( m_serial, m_increment );

        QPicture* pic = l.picture();

        pixmap.fill( Qt::white );
        painter->begin( &pixmap );
        painter->drawPicture( 0, 0, *pic );
        painter->end();

        for( int i = 0; i < (*m_data)[z].number; i++ ) {
            QString filename = m_path + "/" +
                               ( m_filename_article ? (*m_data)[z].article_no : l.barcodeNo() )
                               + QString("_%1.").arg( i ) + KImageIO::suffix( m_format );

            unsigned int c = 0;
            while( QFile::exists( filename ) ) {
                filename += "." + QString::number( c );
                c++;
            }

            pixmap.save( filename, m_format );

            if( !checkProgressDialog( progress ) )
                return;
        }

    }
    delete progress;
}

void BatchPrinter::checkForNewPage( Label* label )
{
    if( curh + measure->height( printer ) > pageh || c_w == measure->numV() ) {
        printer->newPage();
        label->setPage( label->page() + 1 );
        curh = measure->gapTop( printer );
        curw = measure->gapLeft( printer );
        c_w = 0;
    }
}

void BatchPrinter::drawBorders()
{
    if( PrinterSettings::getInstance()->getData()->border ) {
        painter->setPen( QPen( Qt::black, 1 ) );
        painter->drawRect( (int)curw, (int)curh,
                           (int)measure->width( painter->device() ),
                           (int)measure->height( painter->device() ) );
    }
}

void BatchPrinter::changeLine()
{
    if( c_h >= measure->numH() ) {
        c_h = 0;
        curw = measure->gapLeft( printer );
        curh += measure->gapV( printer );
        c_w++;
    }
}

void BatchPrinter::proccessEvents( int lb, QString value, Label* label )
{
    if( lb == NEW_PAGE ) {
        if( curh > measure->gapTop( printer ) || curw > measure->gapLeft( printer ) ) {
            printer->newPage();
            label->setPage( label->page() + 1 );
            curh = measure->gapTop( printer );
            curw = measure->gapLeft( printer );
            c_h = 0;
            c_w = 0;
        }
    }

    if( lb == LINE_BREAK )
        changeLine();

    if( lb == ARTICLE_GROUP_NO )
        printXLabel( lb, label, value );


    if( lb == LABEL_X )
        printXLabel( lb, label, QString::null );
}

void BatchPrinter::printXLabel( int lb, Label* label, const QString & value )
{
    changeLine();
    checkForNewPage( label );

    Label::getXLabel( curw, curh, measure->width( printer ), measure->height( printer ), painter, lb, value );

    drawBorders();

    curw += + measure->gapH( printer );
    c_h++;
}

void BatchPrinter::moveLabels()
{
    for( unsigned int i = 0; i < m_move-1; i++ ) {
        if( !curw )
            curw = measure->gapLeft( printer );

        if( !curh )
            curh = measure->gapTop( printer );

        changeLine();

        if( curh + measure->height( printer ) > pageh || c_w == measure->numV() ) {
            c_w = 0;
            curh = measure->gapTop( printer );
            curw = measure->gapLeft( printer );
        }

        curw += measure->gapH( printer );
        c_h++;
    }
}

QProgressDialog* BatchPrinter::createProgressDialog( const QString & caption )
{
    QProgressDialog* progress = new QProgressDialog( caption, i18n("&Cancel"), m_labels+1, parent );
    progress->setMinimumDuration( 0 );
    progress->setProgress( 0 );
    return progress;
}

bool BatchPrinter::checkProgressDialog( QProgressDialog* progress )
{
    kapp->processEvents( 0 );
    progress->setProgress( progress->progress() + 1 );
    if( progress->wasCancelled() ) {
        delete progress;
        return false;
    }
    return true;
}

