/***************************************************************************
                          configdialog.cpp  -  description
                             -------------------
    begin                : Fre Apr 26 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configdialog.h"
#include "printersettings.h"
#include "sqltables.h"
#include "barcodecache.h"
#include "mybarcode.h"

// Qt includes
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpaintdevicemetrics.h>
#include <qradiobutton.h>
#include <qsqldatabase.h>
#include <qtooltip.h>

// KDE includes
#include <kabc/addressee.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kcolorbutton.h>
#include <kiconloader.h>
#include <kimageio.h>
#include <klineedit.h>
#include <klocale.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <kmessagebox.h>
#include <kpushbutton.h>

const QString cached = I18N_NOOP("There are currently %1 cached barcodes.");
using namespace KABC;

ConfigDialog::ConfigDialog( QWidget* parent )
    : KDialogBase( IconList, i18n("Configure KBarcode"), KDialogBase::Ok|KDialogBase::Cancel,
      KDialogBase::Ok, parent, "", true, true )
{
    setupTab2(); // Printer
    if( BarCode::haveBarcode() );
        setupTab7(); // Barcodes
    setupTab1(); // SQL
    setupTab4(); // label editor
    setupTab3(); // import
    setupTab5(); // on new
    setupTab6(); // image creation
}

ConfigDialog::~ConfigDialog()
{
}

void ConfigDialog::setupTab1( )
{
    QFrame* box = addPage( i18n("SQL Settings"), "", BarIcon("connect_no") );
    QVBoxLayout* layout = new QVBoxLayout( box, 6, 6 );
    QSpacerItem* spacer = new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Expanding );

    sqlwidget = new SqlWidget( false, box, "sqlwidget" );

    layout->addWidget( sqlwidget );
    layout->addItem( spacer );
}

void ConfigDialog::setupTab2()
{
    labelprinterdata* lb = PrinterSettings::getInstance()->getData();
    
    QFrame* box = addPage( i18n("Print Settings"), "", BarIcon("fileprint") );

    QVBoxLayout* tabLayout = new QVBoxLayout( box, 11, 6 );
    QHBoxLayout* Layout0 = new QHBoxLayout( 0, 6, 6 );
    QHBoxLayout* Layout1 = new QHBoxLayout( 0, 6, 6 );
    QSpacerItem* spacer = new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Expanding );

    printerQuality = new KComboBox( false, box );
    printerQuality->insertItem( i18n("Medium Resolution (300dpi)") );
    printerQuality->insertItem( i18n("High Resolution (600dpi)") );
    printerQuality->insertItem( i18n("Very High Resolution (1200dpi)") );

    switch( lb->quality ) {
        case PrinterSettings::Middle:
            printerQuality->setCurrentItem( 0 );
            break;
        case PrinterSettings::High:
            printerQuality->setCurrentItem( 1 );
            break;
        case PrinterSettings::VeryHigh:
            printerQuality->setCurrentItem( 2 );
            break;
        default:
            break;
    }

    pageFormat = new KComboBox( false, box );
    PrinterSettings::getInstance()->insertPageFormat( pageFormat );
    pageFormat->setCurrentItem( lb->format );
    
    Layout0->addWidget( new QLabel( i18n("Printer Resolution:"), box ) );
    Layout0->addWidget( printerQuality );
    Layout1->addWidget( new QLabel( i18n("Preview Page Format:"), box ) );
    Layout1->addWidget( pageFormat );
    tabLayout->addLayout( Layout0 );
    tabLayout->addLayout( Layout1 );
    tabLayout->addItem( spacer );
}

void ConfigDialog::setupTab3()
{
    labelprinterdata* lb = PrinterSettings::getInstance()->getData();

    QFrame* box = addPage( i18n("Import"), "", BarIcon("fileimport") );
    QGridLayout* grid = new QGridLayout( box, 2, 2 );

    QLabel* label = new QLabel( box );
    label->setText( i18n("Comment:") );
    grid->addWidget( label, 0, 0 );

    comment = new KLineEdit( lb->comment, box );
    grid->addWidget( comment, 0, 1 );

    label = new QLabel( box );
    label->setText( i18n( "Separator:" ) );
    grid->addWidget( label, 1, 0 );

    separator = new KLineEdit( lb->separator, box );
    grid->addWidget( separator, 1, 1 );

    label = new QLabel( box );
    label->setText( i18n("Quote Character:") );
    grid->addWidget( label, 2, 0 );

    quote  = new KLineEdit( lb->quote, box );
    grid->addWidget( quote, 2, 1 );

    checkUseCustomNo = new QCheckBox( i18n("&Use customer article no. for import"), box );
    checkUseCustomNo->setChecked( lb->useCustomNo );
    
    grid->addMultiCellWidget( checkUseCustomNo, 3, 3, 0, 2 );
    
    QHBoxLayout* Layout1 = new QHBoxLayout( 0, 6, 6 );
    Layout1->addWidget( new QLabel( i18n("File Format:"), box ) );

    combo1 = new KComboBox( box );
    combo1->insertItem( i18n("Quantity") );
    combo1->insertItem( i18n("Article Number") );
    combo1->insertItem( i18n("Group") );
    Layout1->addWidget( combo1 );

    combo2 = new KComboBox( box );
    combo2->insertItem( i18n("Quantity") );
    combo2->insertItem( i18n("Article Number") );
    combo2->insertItem( i18n("Group") );
    Layout1->addWidget( combo2 );

    combo3 = new KComboBox( box );
    combo3->insertItem( i18n("Quantity") );
    combo3->insertItem( i18n("Article Number") );
    combo3->insertItem( i18n("Group") );
    Layout1->addWidget( combo3 );

    grid->addMultiCellLayout( Layout1, 4, 4, 0, 2 );
    QSpacerItem* spacer = new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );
    grid->addItem( spacer, 5, 0 );    

    KConfig* config = kapp->config();
    config->setGroup("FileFormat");
    combo1->setCurrentItem( config->readNumEntry("Data0", 0 ) );
    combo2->setCurrentItem( config->readNumEntry("Data1", 1 ) );
    combo3->setCurrentItem( config->readNumEntry("Data2", 2 ) );
}

void ConfigDialog::setupTab4()
{
    QFrame* box = addPage( i18n("Label Editor"), "", BarIcon("kbarcode") );
    QGridLayout* tabLayout = new QGridLayout( box, 11, 6 );

    checkNewDlg = new QCheckBox( box );
    checkNewDlg->setText( i18n("&Create a new label on startup") );

    date = new KLineEdit( box );
    labelDate = new QLabel( box );
    
    connect( date, SIGNAL( textChanged( const QString & ) ), this, SLOT( updateDatePreview() ) );

    spinUndo = new KIntNumInput( box );
    spinUndo->setLabel( i18n("Undo Limit:"), AlignLeft | AlignVCenter );
    spinUndo->setRange( 1, 100, 1, false );

    spinGrid = new KIntNumInput( spinUndo, 0, box );
    spinGrid->setLabel( i18n("Grid:" ), AlignLeft | AlignVCenter );
    spinGrid->setRange(2, 100, 1, false );

    colorGrid = new KColorButton( box );

    tabLayout->addWidget( checkNewDlg, 0, 0 );
    tabLayout->addMultiCellWidget( spinUndo, 1, 1, 0, 2 );
    tabLayout->addMultiCellWidget( spinGrid, 2, 2, 0, 2 );
    tabLayout->addWidget( new QLabel( i18n("Grid Color:"), box ), 3, 0 );
    tabLayout->addWidget( colorGrid, 3, 1 );
    tabLayout->addWidget( new QLabel( i18n("Date Format:"), box ), 4, 0 );
    tabLayout->addWidget( date, 4, 1 );
    tabLayout->addWidget( labelDate, 4, 2 );
}

void ConfigDialog::setupTab5()
{
    labelprinterdata* lb = PrinterSettings::getInstance()->getData();
    QFrame* box = addPage( i18n("On New"), "", BarIcon("filenew") );

    QVBoxLayout* tabLayout = new QVBoxLayout( box, 11, 6 );

    QButtonGroup* bg = new QButtonGroup( i18n("On New Article"), box );
    bg->setColumnLayout(0, Qt::Vertical );
    bg->layout()->setSpacing( 6 );
    bg->layout()->setMargin( 11 );
    QGridLayout* bgLayout = new QGridLayout( bg->layout() );

    QStringList alist, glist;
    alist.append( i18n("No Line Break") );
    alist.append( i18n("Line Break") );
    alist.append( i18n("Insert Label X") );
    alist.append( i18n("New Page") );
    alist.append( i18n("Article No.") );

    glist.append( i18n("No Line Break") );
    glist.append( i18n("Line Break") );
    glist.append( i18n("Insert Label X") );
    glist.append( i18n("New Page") );
    glist.append( i18n("Group Name") );

    onNewArticle1 = new KComboBox( false, bg );
    onNewArticle2 = new KComboBox( false, bg );
    onNewArticle3 = new KComboBox( false, bg );
    onNewArticle4 = new KComboBox( false, bg );

    onNewArticle1->insertStringList( alist );
    onNewArticle2->insertStringList( alist );
    onNewArticle3->insertStringList( alist );
    onNewArticle4->insertStringList( alist );

    bgLayout->setColStretch( 1, 3 );

    bgLayout->addWidget( new QLabel( "1.", bg ), 0, 0 );
    bgLayout->addWidget( new QLabel( "2.", bg ), 1, 0 );
    bgLayout->addWidget( new QLabel( "3.", bg ), 2, 0 );
    bgLayout->addWidget( new QLabel( "4.", bg ), 3, 0 );

    bgLayout->addWidget( onNewArticle1, 0, 1 );
    bgLayout->addWidget( onNewArticle2, 1, 1 );
    bgLayout->addWidget( onNewArticle3, 2, 1 );
    bgLayout->addWidget( onNewArticle4, 3, 1 );

    QButtonGroup* bg2 = new QButtonGroup( i18n("On New Group"), box );
    bg2->setColumnLayout(0, Qt::Vertical );
    bg2->layout()->setSpacing( 6 );
    bg2->layout()->setMargin( 11 );
    QGridLayout* bg2Layout = new QGridLayout( bg2->layout() );

    onNewGroup1 = new KComboBox( false, bg2 );
    onNewGroup2 = new KComboBox( false, bg2 );
    onNewGroup3 = new KComboBox( false, bg2 );
    onNewGroup4 = new KComboBox( false, bg2 );

    onNewGroup1->insertStringList( glist );
    onNewGroup2->insertStringList( glist );
    onNewGroup3->insertStringList( glist );
    onNewGroup4->insertStringList( glist );

    bg2Layout->setColStretch( 1, 3 );

    bg2Layout->addWidget( new QLabel( "1.", bg2 ), 0, 0 );
    bg2Layout->addWidget( new QLabel( "2.", bg2 ), 1, 0 );
    bg2Layout->addWidget( new QLabel( "3.", bg2 ), 2, 0 );
    bg2Layout->addWidget( new QLabel( "4.", bg2 ), 3, 0 );

    bg2Layout->addWidget( onNewGroup1, 0, 1 );
    bg2Layout->addWidget( onNewGroup2, 1, 1 );
    bg2Layout->addWidget( onNewGroup3, 2, 1 );
    bg2Layout->addWidget( onNewGroup4, 3, 1 );

    tabLayout->addWidget( bg );
    tabLayout->addWidget( bg2 );

    onNewArticle1->setCurrentItem( lb->articleEvent1 );
    onNewArticle2->setCurrentItem( lb->articleEvent2 );
    onNewArticle3->setCurrentItem( lb->articleEvent3 );
    onNewArticle4->setCurrentItem( lb->articleEvent4 );

    onNewGroup1->setCurrentItem( lb->groupEvent1 );
    onNewGroup2->setCurrentItem( lb->groupEvent2 );
    onNewGroup3->setCurrentItem( lb->groupEvent3 );
    onNewGroup4->setCurrentItem( lb->groupEvent4 );
}

void ConfigDialog::setupTab6()
{
    QFrame* box = addPage( i18n("Image Creation"), "", BarIcon("image") );
    QGridLayout* layout = new QGridLayout( box );

    QButtonGroup* bg = new QButtonGroup( i18n("Filename"), box );
    bg->setColumnLayout(0, Qt::Vertical );
    bg->layout()->setSpacing( 6 );
    bg->layout()->setMargin( 11 );
    QVBoxLayout* bgLayout = new QVBoxLayout( bg->layout() );

    radioArticle = new QRadioButton( i18n("Use &article number for filename"), bg );
    radioBarcode = new QRadioButton( i18n("Use &barcode number for filename"), bg );

    bgLayout->addWidget( radioArticle );
    bgLayout->addWidget( radioBarcode );

    comboFormat = new KComboBox( false, box );
    comboFormat->insertStringList( KImageIO::types( KImageIO::Writing ) );
    
    QSpacerItem* spacer = new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Expanding );
    layout->addMultiCellWidget( bg, 0, 1, 0, 2 );
    layout->addWidget( new QLabel( i18n("Output File Format:"), box ), 2, 0 );
    layout->addMultiCellWidget( comboFormat, 2, 2, 1, 2 );
    layout->addItem( spacer, 3, 2 );

    KConfig* config = kapp->config();
    config->setGroup("ImageCreation");
    bool b = config->readBoolEntry( "FilenameArticle", "true" );
    radioArticle->setChecked( b );
    radioBarcode->setChecked( !b );
    comboFormat->setCurrentItem( config->readEntry("FileFormat", "PNG"), false );
}

void ConfigDialog::setupTab7()
{
    QFrame* box = addPage( i18n("Barcode"), "", BarIcon("barcode") );
    QGridLayout* layout = new QGridLayout( box );

    QSpacerItem* spacer = new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Expanding );
    
    QGroupBox* bg = new QGroupBox( i18n("Barcode Cache"), box );
    bg->setColumnLayout(0, Qt::Vertical );
    bg->layout()->setSpacing( 6 );
    bg->layout()->setMargin( 11 );
    QVBoxLayout* bgLayout = new QVBoxLayout( bg->layout() );

    labelCache = new QLabel( i18n(cached).arg( BarcodeCache::instance()->count() ), bg );

    spinCache = new KIntNumInput( bg );
    spinCache->setLabel( i18n("Barcode Cache Size:"),  AlignLeft | AlignVCenter );
    spinCache->setRange( 0, 10000, 1, true );
    spinCache->setValue( BarcodeCache::instance()->size() );
    
    buttonCache = new KPushButton( i18n("&Clear"), bg );
    buttonCache->setEnabled( BarcodeCache::instance()->size() );
    
    bgLayout->addWidget( labelCache );
    bgLayout->addWidget( spinCache );
    bgLayout->addWidget( buttonCache );
    bgLayout->addItem( spacer );


    layout->addWidget( bg, 0, 0 );

    connect( buttonCache, SIGNAL( clicked() ), this, SLOT( slotClearCache() ) );
    
    QToolTip::add( spinCache, i18n("<qt>Specifies how many barcodes should be cached on the harddisk."
                                   "If you print lot's of articles, you should set this to be the same "
                                   "as the number of articles in your database to get best speed results."
                                   "One cached barcode requires about 20kb of diskspace.</qt>") );
}

#if 0
/* Maybe I need this stuff sometimes again */
void ConfigDialog::setupTab6()
{
    QFrame* box = addPage( i18n("Address Import"), "", BarIcon("kaddressbook") );
    QVBoxLayout* layout = new QVBoxLayout( box );
    QHBoxLayout* top = new QHBoxLayout( 0, 6, 6 );

    comboField = new KComboBox( false, box );
    buttonInsert = new KPushButton( i18n("&Insert"), box );

#if QT_VERSION >= 0x030100
    addEditor = new KTextEdit( box );
#else
    addEditor = new QTextEdit( box );
#endif
    addEditor->setTextFormat( Qt::RichText );

    comboField->insertItem( Addressee::uidLabel() );
    comboField->insertItem( Addressee::nameLabel() );
    comboField->insertItem( Addressee::formattedNameLabel() );
    comboField->insertItem( Addressee::familyNameLabel() );
    comboField->insertItem( Addressee::givenNameLabel() );
    comboField->insertItem( Addressee::additionalNameLabel() );
    comboField->insertItem( Addressee::prefixLabel() );
    comboField->insertItem( Addressee::suffixLabel() );
    comboField->insertItem( Addressee::nickNameLabel() );
    comboField->insertItem( Addressee::birthdayLabel() );
    comboField->insertItem( Addressee::homeAddressStreetLabel() );
    comboField->insertItem( Addressee::homeAddressLocalityLabel() );
    comboField->insertItem( Addressee::homeAddressRegionLabel() );
    comboField->insertItem( Addressee::homeAddressPostalCodeLabel() );
    comboField->insertItem( Addressee::homeAddressCountryLabel() );
    comboField->insertItem( Addressee::homeAddressLabelLabel() );
    comboField->insertItem( Addressee::businessAddressStreetLabel() );
    comboField->insertItem( Addressee::businessAddressLocalityLabel() );
    comboField->insertItem( Addressee::businessAddressRegionLabel() );
    comboField->insertItem( Addressee::businessAddressPostalCodeLabel() );
    comboField->insertItem( Addressee::businessAddressCountryLabel() );
    comboField->insertItem( Addressee::businessAddressLabelLabel() );
    comboField->insertItem( Addressee::homePhoneLabel() );
    comboField->insertItem( Addressee::businessPhoneLabel() );
    comboField->insertItem( Addressee::mobilePhoneLabel() );
    comboField->insertItem( Addressee::homeFaxLabel() );
    comboField->insertItem( Addressee::businessFaxLabel() );
    comboField->insertItem( Addressee::carPhoneLabel() );
    comboField->insertItem( Addressee::isdnLabel() );
    comboField->insertItem( Addressee::pagerLabel() );
    comboField->insertItem( Addressee::emailLabel() );
    comboField->insertItem( Addressee::mailerLabel() );
    comboField->insertItem( Addressee::timeZoneLabel() );
    comboField->insertItem( Addressee::geoLabel() );
    comboField->insertItem( Addressee::titleLabel() );
    comboField->insertItem( Addressee::roleLabel() );
    comboField->insertItem( Addressee::organizationLabel() );
    comboField->insertItem( Addressee::noteLabel() );
    comboField->insertItem( Addressee::productIdLabel() );
    comboField->insertItem( Addressee::revisionLabel() );
    comboField->insertItem( Addressee::sortStringLabel() );
    comboField->insertItem( Addressee::urlLabel() );
    comboField->insertItem( Addressee::secrecyLabel() );
    comboField->insertItem( Addressee::logoLabel() );
    comboField->insertItem( Addressee::photoLabel() );
    comboField->insertItem( Addressee::soundLabel() );
    comboField->insertItem( Addressee::agentLabel() );

    top->addWidget( comboField );
    top->addWidget( buttonInsert );

    layout->addLayout( top );
    layout->addWidget( addEditor );
}
#endif

void ConfigDialog::accept()
{
    KConfig* config = kapp->config();
    config->setGroup("FileFormat");
    config->writeEntry("Data0", combo1->currentItem() );
    config->writeEntry("Data1", combo2->currentItem() );
    config->writeEntry("Data2", combo3->currentItem() );

    config->setGroup("ImageCreation");
    config->writeEntry("FilenameArticle", radioArticle->isChecked() );
    config->writeEntry("FileFormat", comboFormat->currentText() );
    config->sync();

    sqlwidget->save();

    labelprinterdata* lpdata = PrinterSettings::getInstance()->getData();
    lpdata->comment = comment->text();
    lpdata->separator = separator->text();
    lpdata->quote = quote->text();
    lpdata->format = pageFormat->currentItem();

    lpdata->articleEvent1 = onNewArticle1->currentItem();
    lpdata->articleEvent2 = onNewArticle2->currentItem();
    lpdata->articleEvent3 = onNewArticle3->currentItem();
    lpdata->articleEvent4 = onNewArticle4->currentItem();

    lpdata->groupEvent1 = onNewGroup1->currentItem();
    lpdata->groupEvent2 = onNewGroup2->currentItem();
    lpdata->groupEvent3 = onNewGroup3->currentItem();
    lpdata->groupEvent4 = onNewGroup4->currentItem();
    lpdata->useCustomNo = checkUseCustomNo->isChecked();

    switch( printerQuality->currentItem() ) {
        case 0:
            lpdata->quality = PrinterSettings::Middle;
            break;
        case 1:
            lpdata->quality = PrinterSettings::High;
            break;
        case 2:
            lpdata->quality = PrinterSettings::VeryHigh;
            break;
        default:
            break;
    }

    BarcodeCache::instance()->setSize( spinCache->value() );

    QDialog::accept();
}

void ConfigDialog::updateDatePreview()
{
    labelDate->setText( i18n("Preview: ") + QDateTime::currentDateTime().toString( date->text() ) );
}

void ConfigDialog::slotClearCache()
{
    BarcodeCache::instance()->clear();
    labelCache->setText( i18n(cached).arg( BarcodeCache::instance()->count() ) );
    buttonCache->setEnabled( false );
}
