/******************************************************************************
 *   Copyright (C) 2006 PhobosK <phobosk@mail.kbfx.org>                       *
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This package is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the             *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this package; if not, write to the Free Software              *
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA *
 ******************************************************************************/

#include "kbfxconfigapp.h"

KbfxConfigApp::KbfxConfigApp(QWidget* parent, const char* name, WFlags fl)
  : KbfxConfigDlgMain(parent,name,fl)
{
//  m_KbfxVersion = tr2i18n("<p align='center'>Running KBFX version: " VERSION "</p>");
  m_KbfxVersion = tr2i18n("<p align='center'>%1</p>");
  m_KbfxVersion2 = tr2i18n("You are running: <b>KBFX " VERSION "</b>");
  m_KbfxNewsBrowserError = tr2i18n("<br><p align='center'><font color='#ff0000'>"
  "The connection to the KBFX News Section on www.kbfx.org is broken."
  "</font><br><br>"
  "If you want you can check the latest news for KBFX from here:"
  "<br><a href='http://www.kbfx.org/'>KBFX News</a></p>");
  m_KbfxNewsBrowserAddress = "http://www.kbfx.org/news/";
  m_FontsPage = FALSE;
  m_PrepareOption=FALSE;
  InitForm();
  handleCliArgs();
  if (!m_PrepareOption)
  {
    browserInit();
    this->show();
  }
  else
  {
    kdDebug() << "KBFX theme prepared. Quitting..." << endl;
    QTimer::singleShot (100, this, SLOT (deleteLater()));
  }
}

KbfxConfigApp::~KbfxConfigApp()
{
}

void KbfxConfigApp::InitForm()
{
  /* implementation for older KBFX */
  lb_Main->clear();

  /* initialize Button page */
  lb_Main->insertItem(img_button, tr2i18n("Start Button"), 0);
  KbfxConfigDlgButton *pageButton = new KbfxConfigDlgButton();
  ws_Main->addWidget(pageButton, 0);
  pageButton->KbfxLabelVersion->setText( m_KbfxVersion.arg(tr2i18n("Start Button")) );
//  pageButton->KbfxLabelVersion->hide();
  connect(this, SIGNAL(KbfxConfigDlgButtonChanged()),
          pageButton, SLOT(ChangeForm()));
  emit KbfxConfigDlgButtonChanged();

  /* initialize Themes page */
  lb_Main->insertItem(img_themes, tr2i18n("Themes"), 1);
  KbfxConfigDlgThemes *pageThemes = new KbfxConfigDlgThemes();
  ws_Main->addWidget(pageThemes, 1);
  pageThemes->KbfxLabelVersion->setText( m_KbfxVersion.arg(tr2i18n(tr2i18n("Themes"))) );
  connect(this, SIGNAL(KbfxConfigDlgThemesChanged()),
          pageThemes, SLOT(ChangeForm()));
  emit KbfxConfigDlgThemesChanged();
  connect(pageThemes->KbfxGetMoreThemes, SIGNAL(clicked()),
          this, SLOT(KbfxGetMoreThemesClicked()));
  connect(this, SIGNAL(KbfxThemeDoInstall(QString &)),
          pageThemes, SLOT(KbfxThemeInstall(QString &)));

  /* initialize Fonts page */
  lb_Main->insertItem(img_fonts, tr2i18n("Fonts"), 2);
  KbfxConfigDlgFonts *pageFonts = new KbfxConfigDlgFonts();
  ws_Main->addWidget(pageFonts, 2);
  pageFonts->KbfxLabelVersion->setText( m_KbfxVersion.arg(tr2i18n("Fonts")) );
//  pageFonts->KbfxLabelVersion->hide();
  connect(this, SIGNAL(KbfxConfigDlgFontsChanged()),
          pageFonts, SLOT(ChangeForm()));
  connect(this, SIGNAL(KbfxConfigDlgFontsDefaults()),
          pageFonts, SLOT(ChangeFormDefaults()));
  emit KbfxConfigDlgFontsChanged();

  /* initialize Menu Style page */
  lb_Main->insertItem(img_style, tr2i18n("Menu Style"), 3);
  KbfxConfigDlgStyle *pageStyle = new KbfxConfigDlgStyle();
  ws_Main->addWidget(pageStyle, 3);
  pageStyle->KbfxLabelVersion->setText( m_KbfxVersion.arg(tr2i18n("Menu Style")) );
//  pageStyle->KbfxLabelVersion->hide();
  connect(this, SIGNAL(KbfxConfigDlgStyleChanged()),
          pageStyle, SLOT(ChangeForm()));
  emit KbfxConfigDlgStyleChanged();

  /* initialize Tooltip page */
  lb_Main->insertItem(img_tooltip, tr2i18n("Tooltip"), 4);
  KbfxConfigDlgTooltip *pageTooltip = new KbfxConfigDlgTooltip();
  ws_Main->addWidget(pageTooltip, 4);
  pageTooltip->KbfxLabelVersion->setText( m_KbfxVersion.arg(tr2i18n("Tooltip")) );
//  pageTooltip->KbfxLabelVersion->hide();
  connect(this, SIGNAL(KbfxConfigDlgTooltipChanged()),
          pageTooltip, SLOT(ChangeForm()) );
  emit KbfxConfigDlgTooltipChanged();

  /* initialize About page */
  lb_Main->insertItem(img_about, tr2i18n("About"), 5);
  KbfxConfigDlgAbout *pageAbout = new KbfxConfigDlgAbout();
  pageAbout->KbfxLabelVersion->setText( m_KbfxVersion.arg(tr2i18n("About")) );
//  pageAbout->KbfxLabelVersion->hide();
  pageAbout->KbfxLabelVersion2->setText(m_KbfxVersion2);
  ws_Main->addWidget (pageAbout,5);

  connect(btn_Default, SIGNAL(clicked()),
          this, SLOT(btn_DefaultClicked()));
  connect(lb_Main, SIGNAL(highlighted(int)),
          this, SLOT(KbfxMenuItemChanged(int)));
  connect( btn_SaveApply, SIGNAL( clicked() ),
  		  this, SLOT( btn_SaveApplyClicked() ) );

  lb_Main->setCurrentItem(0);
  ws_Main->raiseWidget (0);
}

/* process default options for each page */
void KbfxConfigApp::btn_DefaultClicked()
{
  switch(ws_Main->id(ws_Main->visibleWidget()))
  {
    case 0: /* Button page */
    {
      ConfigInit().m_KbfxNormalButtonPath = ConfigInit().m_KbfxNormalButtonPathDefault;
      ConfigInit().m_KbfxHoverButtonPath = ConfigInit().m_KbfxHoverButtonPathDefault;
      ConfigInit().m_KbfxPressedButtonPath = ConfigInit().m_KbfxPressedButtonPathDefault;
      ConfigInit().m_ToolBarResize = ConfigInit().m_ToolBarResizeDefault;
      emit KbfxConfigDlgButtonChanged();
      break;
    }
    case 1: /* Themes page */
    {
      ConfigInit().m_SpinxThemeBasePath = ConfigInit().m_SpinxThemeBasePathDefault;
      ConfigInit().m_UserSpinxThemeBasePath = ConfigInit().m_UserSpinxThemeBasePathDefault;
      ConfigInit().m_SpinxThemeName = ConfigInit().m_SpinxThemeNameDefault;
      ConfigInit().m_SpinxDudeBlink = ConfigInit().m_SpinxDudeBlinkDefault;
      ConfigInit().m_SpinxDudeImage = ConfigInit().m_SpinxDudeImageDefault;
      emit KbfxConfigDlgThemesChanged();
      break;
    }
    case 2: /* Fonts page */
    {
      ConfigInit().m_fontSize = ConfigInit().m_fontSizeDefault;
      ConfigInit().m_fontAppNameColor = ConfigInit().m_fontAppNameColorDefault;
      ConfigInit().m_fontAppCommentColor = ConfigInit().m_fontAppCommentColorDefault;
      ConfigInit().m_lineColor = ConfigInit().m_lineColorDefault;
      ConfigInit().m_fontIndexColor = ConfigInit().m_fontIndexColorDefault;
      ConfigInit().m_userNameColor = ConfigInit().m_userNameColorDefault;
      ConfigInit().m_sepNameColor = ConfigInit().m_sepNameColorDefault;
      ConfigInit().m_KbfxGlobalChange = TRUE;
      emit KbfxConfigDlgFontsDefaults();
      break;
    }
    case 3: /* Style page */
    {
      ConfigInit().m_KbfxMenuType = ConfigInit().m_KbfxMenuTypeDefault;
      emit KbfxConfigDlgStyleChanged();
      break;
    }
    case 4: /* Tooltip page */
    {
      ConfigInit().m_ToolTip = ConfigInit().m_ToolTipDefault;
      ConfigInit().m_ToolTipAnimation = ConfigInit().m_ToolTipAnimationDefault;
      ConfigInit().m_ToolTipText = ConfigInit().m_ToolTipTextDefault;
      emit KbfxConfigDlgTooltipChanged();
      break;
    }
    case 5: /* About page */
    {
      KMessageBox::information(0, tr2i18n("No default settings here ;)"));
      break;
    }
    default: /* Default Action Switch should never be reached */
      kdDebug() << "Default action switch for default clicked..." << endl;
  }
}

void KbfxConfigApp::KbfxMenuItemChanged(int index)
{
  /* switch is used in case we want to add special code
   * for certain page before raiseWidget is called
   */

  if(m_FontsPage)
  {
    m_FontsPage = FALSE;
    KbfxSaveFontsConfig();
    ConfigInit().m_SpinxThemeBasePath = m_SpinxThemeBasePathTmp;
    ConfigInit().m_SpinxThemeName = m_SpinxThemeNameTmp;
  }

  switch(index)
  {
    case 0: /* Button page */
    {
      ws_Main->raiseWidget(0);
      break;
    }
    case 1: /* Themes page */
    {
      ws_Main->raiseWidget(1);
      emit KbfxConfigDlgThemesChanged();
      break;
    }
    case 2: /* Fonts page */
    {
      m_FontsPage = TRUE;
      m_SpinxThemeBasePathTmp = ConfigInit().m_SpinxThemeBasePath;
      m_SpinxThemeNameTmp = ConfigInit().m_SpinxThemeName;
      ConfigInit().m_KbfxGlobalChange = FALSE;
      ws_Main->raiseWidget(2);
      emit KbfxConfigDlgFontsChanged();
      break;
    }
    case 3: /* Style page */
    {
      ws_Main->raiseWidget(3);
      break;
    }
    case 4: /* Tooltip page */
    {
      ws_Main->raiseWidget(4);
      break;
    }
    case 5: /* About page */
    {
      ws_Main->raiseWidget(5);
      break;
    }
    default: /* default action switch should never be reached */
      kdDebug() << "Default action switch for menu changed..." << endl;
  }
}

void KbfxConfigApp::KbfxNewsBrowserOpenURLRequest(const KURL &url, const KParts::URLArgs &name)
{
  KRun::runCommand("konqueror " + url.url());

  return ;
}

void KbfxConfigApp::KbfxNewsBrowserCompleted()
{
  kio->KbfxKioDownloadEnd();
}

void KbfxConfigApp::browserInit()
{
  /* initialize NewsBrowser widget */
  kio = new KbfxKioDownload();
  connect(kio, SIGNAL(KbfxKioDownloadReady()),
          this, SLOT(KbfxNewsBrowserLoad()));
  kio->KbfxKioDownloadStart(m_KbfxNewsBrowserAddress);
}

void KbfxConfigApp::KbfxNewsBrowserLoad()
{
  if(kio->KbfxBrowserError()) KBFXNewsBrowser->setText(m_KbfxNewsBrowserError);
  else
  {
    browser = new KHTMLPart (KBFXNewsBrowser);
    browser->openURL(kio->KbfxBrowserTmpFile());
    browser->view()->resize(KBFXNewsBrowser->width(), KBFXNewsBrowser->height());
    browser->view()->setVScrollBarMode(QScrollView::AlwaysOff);
    browser->view()->setHScrollBarMode(QScrollView::AlwaysOff);
    browser->view()->setFocusPolicy(QWidget::NoFocus);
    browser->view()->show();

    connect(browser->browserExtension(),
            SIGNAL(openURLRequest(const KURL &, const KParts::URLArgs &)),
            this,
            SLOT(KbfxNewsBrowserOpenURLRequest(const KURL &, const KParts::URLArgs &)));
    connect(browser, SIGNAL(completed()),
            this, SLOT(KbfxNewsBrowserCompleted()));
  }
}

void KbfxConfigApp::KbfxGetMoreThemesClicked()
{
  KRun::runCommand ("konqueror 'http://www.kbfx.org/news/new_themes.html'");

  return ;
}

void KbfxConfigApp::handleCliArgs()
{
    KCmdLineArgs* KbfxArgs = KCmdLineArgs::parsedArgs();
	
	/* install kbfx theme cmdline option given */
    if(KbfxArgs->isSet("install"))
    {
      m_KbfxThemeUrl = KbfxArgs->getOption("install");
      ws_Main->raiseWidget(1);

      emit KbfxThemeDoInstall(m_KbfxThemeUrl);

      kdDebug() << "Install option argument: "
                << m_KbfxThemeUrl
                << endl;
    }

	/* prepare kbfx theme cmdline option given */
    if (KbfxArgs->isSet("prepare"))
    {
        m_PrepareOption=TRUE;
        m_KbfxThemeFolderUrl = KbfxArgs->getOption("prepare");
        if(m_KbfxThemeFolderUrl.endsWith("/")) m_KbfxThemeFolderUrl.truncate(m_KbfxThemeFolderUrl.length()-1);
        QString theme_name = m_KbfxThemeFolderUrl.section( '/', -1 );
        QString archive_dir = m_KbfxThemeFolderUrl.section( '/', 0, -2 );
        QString archive_name = archive_dir+"/"+ theme_name+".kbfxtheme";
        kdDebug() << "Prepare option arguments: "
				  << theme_name 
				  << endl
				  << archive_dir
				  << endl
				  << archive_name
				  << endl;
  
  	KTar ThemeArchive(archive_name,"application/x-bzip2" );

  	if(!ThemeArchive.open(IO_WriteOnly))
  	{
    	KMessageBox::sorry(0,
						   tr2i18n("Could not create this KBFX theme package."));

    	kdDebug() << "Error creating theme file: "
    			  << archive_name
    			  << endl;

    	return;
  	}
  
  	ThemeArchive.addLocalDirectory(m_KbfxThemeFolderUrl,theme_name);
  	ThemeArchive.close ();
  	KMessageBox::information(0,
  							 tr2i18n("<p>KBFX Theme <strong>%1</strong> prepared</p>.").arg(theme_name),
  							 tr2i18n("KBFX Theme Ready"));
	kdDebug() << "KBFX theme file ready: "
			  << archive_name 
			  << endl;
    }
    
    KbfxArgs->clear();
}

void KbfxConfigApp::KbfxSaveFontsConfig()
{
  if(ConfigInit().m_KbfxGlobalChange)
  {
    int messageBoxReturn;
    messageBoxReturn = KMessageBox::warningContinueCancel(0,
    tr2i18n("<p>Do you want to save fonts configuration for the KBFX theme "
            "<strong>%1</strong>?</p>").arg( ConfigInit().m_SpinxThemeName),
    tr2i18n("Save fonts configuration"),
    tr2i18n("Save"));

    if( messageBoxReturn == KMessageBox::Cancel) return;

    ConfigInit().writeFontrc(ConfigInit().m_SpinxThemeName);
  }

  ConfigInit().m_KbfxGlobalChange = FALSE;
}

void KbfxConfigApp::btn_SaveApplyClicked()
{
  if(m_FontsPage)
  {
    ConfigInit().writeFontrc(ConfigInit().m_SpinxThemeName);
    tmp_FontSpinxThemeBasePath = ConfigInit().m_SpinxThemeBasePath;
    tmp_FontSpinxThemeName = ConfigInit().m_SpinxThemeName;
    ConfigInit().m_SpinxThemeBasePath = m_SpinxThemeBasePathTmp;
    ConfigInit().m_SpinxThemeName = m_SpinxThemeNameTmp;
  }
  
  ConfigInit().write();
  if(!m_FontsPage)
  {
  	ConfigInit().writeFontrc(ConfigInit().m_SpinxThemeName);
  }
  ConfigInit().m_KbfxGlobalChange = FALSE;
  DCOPRef m_kickerkbfxInterface("kicker", "kbfxInterface");
  m_kickerkbfxInterface.call("notifyConfigChange()");
  
  if(m_FontsPage)
  {
    ConfigInit().m_SpinxThemeBasePath = tmp_FontSpinxThemeBasePath;
    ConfigInit().m_SpinxThemeName = tmp_FontSpinxThemeName;
  }
}

#include "kbfxconfigapp.moc"
