/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kbfxspinxlistbox.h"
//#include "cursor.xpm"
#include <qimage.h>
//#include <qpixmap.h>
#include <qapplication.h>
#include <qevent.h>
#include <qdragobject.h>


void
KbfxSpinxListBox::dragLeaveEvent (QDragLeaveEvent * e)
{
  e = e;
}

void
KbfxSpinxListBox::dragMoveEvent (QDragMoveEvent * e)
{
  e = e;
}

void
KbfxSpinxListBox::scroll (int delta)
{

  QWheelEvent we (QCursor::pos (), delta, Qt::NoButton);
  QApplication::sendEvent (this, &we);

}


void
KbfxSpinxListBox::scrollRest (int x)
{
  x = x;
  if (_type != 1)
    {
      this->move (this->x (), 0);
      scrolllen = 0;
    }

}


void
KbfxSpinxListBox::wheelEvent (QWheelEvent * e)
{
if(!this->isVisible())
	return;

 QListBoxItem *_item = this->firstItem ();
  if (_item == NULL )
    return;
 int _h = _item->height(this);
 scrollBy(0,y()-e->delta());
}

void
KbfxSpinxListBox::mouseMoveEvent (QMouseEvent * e)
{

if (e->state() & LeftButton) {
    int distance = (e->pos() - m_dragPos).manhattanLength();
    if (distance > QApplication::startDragDistance())
    {

	QListBoxItem *_item = this->itemAt (e->pos ());
     	*_selected = e->pos ();
        VistaListBoxItem * _tmp = (VistaListBoxItem*)_item;
	startDrag(_tmp);
    }

return ;
}



  if (e->type () == QEvent::MouseMove && blocked)
    {
      QListBoxItem *_item = this->itemAt (e->pos ());
      *_selected = e->pos ();
	
     VistaListBoxItem * _tmp = (VistaListBoxItem*)_item;
      
      if (_item == NULL)
	{
	  this->clearFocus ();
		setCursor(Qt::ArrowCursor);
	  return;
	}
      else 
	{
	if(_tmp->getType() != 3)
	{
	  QCursor kbfxCursor;
	  kbfxCursor.setShape (Qt::PointingHandCursor);
	  this->setCursor ((const QCursor) kbfxCursor);
	}
	if(_tmp->getType() == 3)
		setCursor(Qt::ArrowCursor);
	}
      this->setFocus ();
      _lastItem = (VistaListBoxItem *) _item;
      emit onItem (_item);
      this->setSelected (_item, true);

    }



}

void KbfxSpinxListBox::contentsMousePressEvent(QMouseEvent *event)
{
if (event->button() == LeftButton)
    m_dragPos = event->pos();
QListBox::contentsMousePressEvent(event);

}

void KbfxSpinxListBox::contentsMouseMoveEvent(QMouseEvent *event)
{
QListBox::contentsMouseMoveEvent(event);


}

void KbfxSpinxListBox::startDrag( VistaListBoxItem * _item )
{

if(_item == NULL)
	return ;

QString person = *_item->getText();


if(_item->getType() == 0)
{	
if (!person.isEmpty()) 
{
    //QTextDrag *drag = new QTextDrag(person, this);
	QUriDrag * drag = new QUriDrag(QStrList(_item->getExec()),this,_item->getExec().ascii());
  //  drag->setSubtype("x-desktop");
	drag->setFileNames (QStringList(_item->getExec()));
    drag->setPixmap(_item->drawDragPixmap());
    drag->drag();
	qDebug("drag done");
	emit dragDone((QListBoxItem*)_item);
}

}
}

void
KbfxSpinxListBox::leaveEvent (QEvent * e)
{
  e = e;
  if (!_type)
    this->clearFocus ();

}
