;; s.t.o.2/theme.jl

(let* (
    (font (get-font "-adobe-helvetica-bold-r-normal-*-*-120-*-*-p-*-iso8859-1"))

    (title-width
      (lambda (w)
        (let
          ((w-width (car (window-dimensions w))))
        (max 0 (+ 37 (min (- w-width 55) (text-width (window-name w) font)))))))

     (titlebar-left (list (make-image "tl-i.png") (make-image "tl.png")))

     (titlebar-right (list (make-image "tr-i.png") (make-image "tr.png")))

     (title-colors (list "black" "white"))

     (middle (list (make-image "middle-i.png")
                   (make-image "middle.png")))
     
     (corner (list (make-image "corner-i.png")
                         (make-image "corner.png")))

     (close (list (make-image "close-i.png")
                  (make-image "close.png") nil
                  (make-image "close.png")))

     (maximize (list (make-image "up-i.png")
			 (make-image "up.png") nil
                     (make-image "up.png")))

     (iconify (list (make-image "down-i.png")
			(make-image "down.png") nil
                    (make-image "down.png")))

     (shade (list (make-image "shade-i.png")
                  (make-image "shade.png") nil
                  (make-image "shade.png")))

     (menu (list (make-image "right-i.png")
                 (make-image "right.png") nil
                 (make-image "right.png")))

     ;; frame layout
     (frame `(
              ;; close button
              ((background . ,close)
               (top-edge . -25)
               (left-edge . 0)
               (cursor . left_ptr)
               (class . close-button))

	      ;; titlebar (left side)
	      ((background . ,titlebar-left)
	       (foreground . ,title-colors)
	       (text . ,window-name)
               (font . ,font)
	       (x-justify . center)
	       (y-justify . center)
	       (top-edge . -25)
	       (left-edge . 17)
	       (width . ,(lambda (w) (title-width w)))
               (cursor . left_ptr)
	       (class . title))

	      ;; middle
	      ((background . ,middle)
	       (left-edge . ,(lambda (w) (title-width w)))
	       (top-edge . -25)
               (cursor . left_ptr)
	       (class . title))

	      ;; titlebar (right side)
	      ((background . ,titlebar-right)
	       (top-edge . -25)
	       (left-edge . ,(lambda (w) (+ (title-width w) 25)))
	       (right-edge . 0)
               (cursor . left_ptr)
	       (class . title))

              ;; shade button
              ((background . ,shade)
               (top-edge . -25)
               (right-edge . 0)
               (cursor . left_ptr)
               (class . shade-button))

              ;; maximize button
              ((background . ,maximize)
               (top-edge . -25)
               (right-edge . 17)
               (cursor . left_ptr)
               (class . maximize-button))

              ;; iconify button
              ((background . ,iconify)
               (top-edge . -25)
               (right-edge . 34)
               (cursor . left_ptr)
               (class . iconify-button))

              ;; resize corner
              ((background . ,corner)
               (bottom-edge . 0)
               (right-edge . 0)
               (cursor . left_ptr)
               (class . bottom-right-corner))
       ))

       (shaped-frame `(
              ;; close button
              ((background . ,close)
               (top-edge . -25)
               (left-edge . 0)
               (cursor . left_ptr)
               (class . close-button))

	      ;; titlebar (left side)
	      ((background . ,titlebar-left)
	       (foreground . ,title-colors)
	       (text . ,window-name)
               (font . ,font)
	       (x-justify . center)
	       (y-justify . center)
	       (top-edge . -25)
	       (left-edge . 17)
	       (width . ,(lambda (w) (title-width w)))
               (cursor . left_ptr)
	       (class . title))

	      ;; middle
	      ((background . ,middle)
	       (left-edge . ,(lambda (w) (title-width w)))
	       (top-edge . -25)
               (cursor . left_ptr)
	       (class . title))

	      ;; titlebar (right side)
	      ((background . ,titlebar-right)
	       (top-edge . -25)
	       (left-edge . ,(lambda (w) (+ (title-width w) 25)))
	       (right-edge . 0)
               (cursor . left_ptr)
	       (class . title))

              ;; shade button
              ((background . ,shade)
               (top-edge . -25)
               (right-edge . 0)
               (cursor . left_ptr)
               (class . shade-button))
       ))

       (transient-frame `(
	      ;; titlebar (left side)
	      ((background . ,titlebar-left)
	       (foreground . ,title-colors)
	       (text . ,window-name)
               (font . ,font)
	       (x-justify . center)
	       (y-justify . center)
	       (top-edge . -25)
	       (left-edge . 0)
	       (width . ,(lambda (w) (title-width w)))
               (cursor . left_ptr)
	       (class . title))

	      ;; middle
	      ((background . ,middle)
	       (left-edge . ,(lambda (w) (title-width w)))
	       (top-edge . -25)
               (cursor . left_ptr)
	       (class . title))

	      ;; titlebar (right side)
	      ((background . ,titlebar-right)
	       (top-edge . -25)
	       (left-edge . ,(lambda (w) (+ (title-width w) 25)))
	       (right-edge . 0)
               (cursor . left_ptr)
	       (class . title))

              ;; shade button
              ((background . ,shade)
               (top-edge . -25)
               (right-edge . 0)
               (cursor . left_ptr)
               (class . shade-button))
       ))

       (shaped-transient-frame `(
	      ;; titlebar (left side)
	      ((background . ,titlebar-left)
	       (foreground . ,title-colors)
	       (text . ,window-name)
               (font . ,font)
	       (x-justify . center)
	       (y-justify . center)
	       (top-edge . -25)
	       (left-edge . 0)
	       (width . ,(lambda (w) (title-width w)))
               (cursor . left_ptr)
	       (class . title))

	      ;; middle
	      ((background . ,middle)
	       (left-edge . ,(lambda (w) (title-width w)))
	       (top-edge . -25)
               (cursor . left_ptr)
	       (class . title))

	      ;; titlebar (right side)
	      ((background . ,titlebar-right)
	       (top-edge . -25)
	       (left-edge . ,(lambda (w) (+ (title-width w) 25)))
	       (right-edge . 0)
               (cursor . left_ptr)
	       (class . title))

              ;; shade button
              ((background . ,shade)
               (top-edge . -25)
               (right-edge . 0)
               (cursor . left_ptr)
               (class . shade-button))
       )))
  
  (def-frame-class shade-button '((cursor . left_ptr))
      (bind-keys shade-button-keymap "Button1-Off" 'toggle-window-shaded)
      (bind-keys shade-button-keymap "Button3-Click1" 'popup-window-menu))

  (add-frame-style 's.t.o.2
		   (lambda (w type)
		     (cond ((eq type 'shaped)
			    shaped-frame)
			   ((eq type 'transient)
			    transient-frame)
			   ((eq type 'shaped-transient)
			    shaped-transient-frame)
			   ((eq type 'unframed)
			    nil-frame)
			   (t
			    frame))))

  (call-after-property-changed 'WM_NAME
    (lambda ()
      (rebuild-frames-with-style 's.t.o.22)))
)
