package org.kde.koala;
import org.kde.qt.*;


/** {@link KWinModule} emits these signals */
public interface KWinModuleSignals {

/** 
 A window has been removed
   
*/
	void windowRemoved( int arg1 );

/** 
 Remove a dock window
   
*/
	void systemTrayWindowRemoved( int arg1 );
	void destroyed();

/** 
 The window changed somehow.
     
*/
	void windowChanged( int arg1 );

/** 
 Switched to another virtual desktop
   
*/
	void currentDesktopChanged( int arg1 );

/** 
 Add a dock window
   
*/
	void systemTrayWindowAdded( int arg1 );

/** 
 Desktops have been renamed
    
*/
	void desktopNamesChanged();

/** 
 A window has been added
   
*/
	void windowAdded( int arg1 );
	void strutChanged();

/** 
 Hint that <Window> is active (= has focus) now.
   
*/
	void activeWindowChanged( int arg1 );

/** 
 The workarea has changed
   
*/
	void workAreaChanged();

/** 
 The number of desktops changed
    
*/
	void numberOfDesktopsChanged( int arg1 );

/** 
 The stacking order of the window changed. The new order
 can be obtained with {@link KWinModule#stackingOrder}
     
*/
	void stackingOrderChanged();
}

