#!/usr/bin/env python

# Ported to PyQt by Issac Trotts on Jan 1, 2002

import sys
from qt import *

import dropsite, secret


def addStuff( parent, yn_image, yn_secret = 0 ):
    tll = QVBoxLayout( parent, 10 )
    d = dropsite.DropSite( parent, 'dropsite' )
    d.setFrameStyle( QFrame.Sunken + QFrame.WinPanel )
    tll.addWidget( d )
    if yn_image:
        stuff = QPixmap()
        if not stuff.load( "trolltech.bmp" ):
            stuff = QPixmap(20,20)
            stuff.fill(Qt.green)
        d.setPixmap( stuff )
    else:
        d.setText("Drag and Drop")
    d.setFont(QFont("Helvetica",18))
    if secret:
        s = secret.SecretSource( 42, parent )
        tll.addWidget( s )

    format = QLabel( "\n\n\n\nNone\n\n\n\n", parent )
    tll.addWidget( format )
    tll.activate()
    parent.resize( parent.sizeHint() )

    QObject.connect( d, PYSIGNAL('message(QString &)'),
        format, SLOT('setText(QString &)') )


app = QApplication( sys.argv )

mw = QWidget()
addStuff( mw, 1 )
mw.setCaption( "Qt Example - Drag and Drop" )
mw.show()

mw2 = QWidget()
addStuff( mw2, 0 )
mw2.setCaption( "Qt Example - Drag and Drop" )
mw2.show()

mw3 = QWidget()
addStuff( mw3, 1, 1 )
mw3.setCaption( "Qt Example - Drag and Drop" )
mw3.show()

QObject.connect(qApp,SIGNAL('lastWindowClosed()'),qApp,SLOT('quit()'))

app.exec_loop()
