#ifndef __DESIGN_H__
#define __DESIGN_H__

/**
 * @libdoc Kdetv Class Reference
 * @mainpage Kdetv Class Reference
 *
 * This library is part of the Kdetv application, and provides an
 * easy to use API for accessing Video4Linux devices in KDE
 * applications.
 *
 * @section common Core Classes
 *
 * @ref KdetvIface : 
 *     The DCOP interface to Kdetv.
 *
 * @ref Kdetv
 *     A QObject that provides a high-level API to the TV.
 *
 * @section components Components
 *
 * @ref KdetvPart :
 *     A KPart that displays a TV picture.
 *
 * @ref ChannelEditor :
 *     A widget for editing a suite of TV channels.
 *
 * @ref KdetvWidget :
 *     A QWidget that displays a TV picture.
 *
 * @ref KdetvApplet :
 *     A KPanelApplet that displays a TV picture.
 *
 * @ref KdetvExtension :
 *     A KPanelExtension that displays a TV picture.
 *
 * @section actions Actions
 *
 * @ref KdetvActions :
 *     Creates the KActions for Kdetv widgets.
 *
 * @ref SliderAction :
 *     A @ref KAction that displays a number using the @ref QSlider class.
 *
 * @ref LCDNumberAction :
 *     A @ref KAction that displays a number using the @ref QLCDNumber class.
 *
 * @section channels Channel Handling
 *
 * @ref Channel :
 *     A single TV channel.
 *
 * @ref ChannelStore :
 *     A suite of TV channels.
 *
 * @ref ChannelIO :
 *     A simple interface for loading and saving suites of channels.
 *
 * @ref ChannelIOFormat :
 *     A baseclass for channel format handlers.
 *
 * @section lowlevel Low-Level API
 *
 * If you need to interact with a video device at a lower level than that
 * provided by the Kdetv abstraction then you should use the V4LDev
 * class. This class (and those that inherit from it) provide a wrapper
 * around the various Video4Linux <a href="man:/ioctl">ioctl</a> calls.
 *
 * @ref V4LDev :
 *     A generic interface implemented by all video devices.
 *
 * @ref V4LTuner :
 *     A tuner device.
 *
 * @ref V4LCamera
 *     A camera device.
 *
 */

#endif
