/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mon Jan 31 11:05:05 CET 2000
    copyright            : (C) 2000 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kscribble.h"

static const char *description =
	I18N_NOOP("KDE 2 example application");

static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("image file to open"), 0 },
  { 0, 0, 0 }
};


int main(int argc, char *argv[])
{
	KAboutData aboutData( "kscribble", I18N_NOOP("KScribble"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2000, Ralf Nolden");
	aboutData.addAuthor("Ralf Nolden",0, "rnolden@kdevelop.de");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;
  KImageIO::registerFormats();

  if (app.isRestored())
  {
    RESTORE(KScribbleApp);
  }
  else
  {
    KScribbleApp *kscribble = new KScribbleApp();
    kscribble->show();

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		
		if (args->count())
			for(int i=0;i<args->count();i++)
        kscribble->openDocumentFile(args->arg(i));
		else
		  kscribble->openDocumentFile();
		
		args->clear();
  }

  return app.exec();
}
