import os.path
import SCons.Defaults
import SCons.Tool
import SCons.Util
def _yaccEmitter(target, source, env, ysuf, hsuf):
    if len(source) and '-d' in SCons.Util.CLVar(env.subst("$YACCFLAGS")):
        base, ext=os.path.splitext(SCons.Util.to_String(source[0]))
        if ext==ysuf:
            base, ext=os.path.splitext(SCons.Util.to_String(target[0]))
            target.append(base + hsuf)
    return (target, source)
def yEmitter(target, source, env):
    return _yaccEmitter(target, source, env, '.y', '.h')
def yyEmitter(target, source, env):
    return _yaccEmitter(target, source, env, '.yy', '.hpp')
def generate(env):
    """ """
    c_file, cxx_file=SCons.Tool.createCFileBuilders(env)
    
    c_file.add_action('.y', SCons.Defaults.YaccAction)
    cxx_file.add_action('.yy', SCons.Defaults.YaccAction)
    c_file.add_emitter('.y', yEmitter)
    cxx_file.add_emitter('.yy', yyEmitter)
    env['YACC']     =env.Detect('bison') or 'yacc'
    env['YACCFLAGS']=SCons.Util.CLVar('')
    env['YACCCOM']  ='$YACC $YACCFLAGS -o $TARGET $SOURCES'
def exists(env):
    return env.Detect(['bison', 'yacc'])
