/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 07-24-2007
 * 
 * Copyright 2007 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
#ifndef EXIF_H
#define EXIF_H

#include <qfile.h>
#include <qstring.h>


/**
 *  An assembly of various functions to extract and manipulate
 *  EXIF and JPEG data. If kflickr needs to be able to do more
 *  then get basic data from the JPEG and EXIF it would be wise
 *  to use a 3rd party lib to do it.
 *  @author M. Asselstine <asselsm@gmail.com>
 */
class EXIF
{
public:
    /** Constructor.
     *  @param imageFilename name of Image file containing possible exif data
     */
    EXIF(const QString& imageFilename);

    /** Destructor */
    ~EXIF() {};

    /** Return just the EXIF data contained in the file.
     *  @return raw byte data of the full EXIF
     */
    QByteArray rawData();

    /** Returns the UserComment found in the EXIF data.
     *  @return UserComment extracted from EXIF
     */
    QString userComment();

protected:
    /** Prevent default constructor being called */
    EXIF() {};

private:
    /** Find something in the EXIF data. A rush job so at the
     *  moment I can only guarantee this works for IFD0 and
     *  subIFD. Will handle both small and large endian.
     *  @param tag The 2 byte tag of the thing we want
     *  @param type Pointer to store the integer data type
     *  @param offset Ponter to store the offset to the data
     *  @param num Pointer to store the number of components of type that makup the data
     *  @return TRUE if found, FALSE for error or not found
     */
    bool findData(const Q_UINT16 tag, int* type, int* offset, int* num);

    QByteArray m_exif;      /// storage for the EXIF data
    QString m_comment;      /// storage for a jpeg meta data comment string
};

#endif
