\ hp34401.4th
\
\ GPIB interface to the HP34401A multimeter
\
\ Requires:
\
\   gpib.4th
\   strings.4th
\
\ Revisions:
\
\	3-23-1999	ported from UR/FORTH
\	6-17-1999	modified to talk to two meters
\

22 constant HP_ADDR  \ default GPIB primary address for meter        

: read_meter ( n -- f | return the measured value from meter n )               
 	HP_ADDR + 	\ GPIB address of meter n
	dup
	" READ?" swap send_command                                
	18 swap read_bytes
	gpib_in_buf fnumber_buf 1+ 16 cmove  
	15 fnumber_buf c!                                            
	fnumber_buf string>f ;                                  

: read_meter1 ( -- f | return measurement from meter 1 )
	0 read_meter ;

: read_meter2 ( -- f | return measurement from meter 2 )
	1 read_meter ;





