// kForth.cpp
//
// The kForth environment
//
// Copyright (c) 1998--2000 Krishna Myneni and David P. Wallace, 
//   Creative Consulting for Research and Education
// 
// This software is provided under the terms of the GNU General Public License.
//
//
// Usage from console prompt:
//
//      kforth name[.4th] [-D]
//
char* Rls_Date = "8-8-2000";

#include <stdio.h>
#include <fstream.h>
#include <strstream.h>
#include <string.h>
#include <vector>
extern "C" {
#include <readline/readline.h>
#include <readline/history.h>
}
#include "fbc.h"
#include "ForthCompiler.h"
#include "ForthVM.h"

extern vector<DictionaryEntry> Dictionary;
extern char* C_ErrorMessages[];

extern "C" int* JumpTable;

int debug = 0;

void main(int argc, char *argv[])
{
    char name[256], InFileName[256], OutFileName[256], *cp, ch;
    char s[256], *input_line;
    istrstream* pSS = NULL;
    char* prompt = " ok\n";
    vector<byte> op;
    int nWords, i, j, ec;

    cout << "\nkForth v 1.0";
    cout << "\nRls. " << Rls_Date;
    cout << "\nCopyright (c) 1998--2000 Krishna Myneni and David P. Wallace";
    cout << "\nCreative Consulting for Research and Education";
    cout << "\nProvided under the GNU General Public License.\n\n";


    nWords = OpenForth();

    i = 1;

    while (i < argc)
    {
	if (strstr(argv[i], "-D"))
	{
	   debug = -1;
	}
	else
	{
		strcpy (s, "include ");
        	strcat (s, argv[i]);
		pSS = new istrstream (s);
	}
	++i;
    }

    if (debug) cout << '\n' << nWords << " words defined.\n";

    int* sp;
    byte* tp;
    int line_num;

    if (debug) cout << "Jump Table address is " << JumpTable;
    cout << "\nReady!\n";

//----------------  the interpreter main loop

    SetForthOutputStream (cout);

    while (1)
    {

        // Obtain commands and execute

        do
        {
	    if (! pSS)
	    {
		input_line = readline(NULL);
		if (strlen(input_line)) add_history(input_line);
		strncpy(s, input_line, 255);
		free(input_line);
	       
            	pSS = new istrstream (s);
	    }
	    SetForthInputStream (*pSS);
            ec = ForthCompiler (&op, &line_num);
	    delete pSS;
	    pSS = NULL;

        } while (ec == E_C_ENDOFSTREAM) ;   // test for premature end of input
                                            //   such as a word definition
                                            //   that spans multiple lines

        if (ec)
        {
	    if (ec < MAX_ERR_MESSAGES)
	      cout << "Line " << line_num << ": " << C_ErrorMessages[ec] << '\n';

            if (debug)
	    {
		cout << "\nGenerated " << op.size() << " opcodes.\n";
            	OutputForthByteCode (&op);
	    }
        }
        else
        {
            if (debug) OutputForthByteCode (&op);

            if (op.size())
            {
                ec = ForthVM (&op, &sp, &tp);
                if (ec)
                {
		  if (ec != 8) PrintVM_Error(ec);
// StackDump(cout);
                }
		else
		  cout << prompt;
            }


        }

        op.erase(op.begin(), op.end());

    }

}
//---------------------------------------------------------------

