/***************************************************************************
                          kgeo.h  -  description
                             -------------------
    begin                : Sam Aug 11 19:50:48 CEST 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KGEO_H
#define KGEO_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qstrlist.h>
#include <qcursor.h>
#include <qlist.h>
#include <qdialog.h>
#include <qtabdialog.h>
#include <qcheckbox.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qdir.h>
#include <qpoint.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qpixmap.h>
#include <qmessagebox.h>
#include <qstringlist.h>
#include <qbutton.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qrect.h>
#include <qimage.h>
#include <qslider.h>
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qtimer.h>
#include <qtoolbutton.h>
#include <qtoolbar.h>
#include <qcombobox.h>

// include files for KDE
#include <ktoolbar.h>
#include <ktoolbarbutton.h>
#include <kstddirs.h>
#include <qcstring.h>
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kcursor.h>
#include <ktoolbarradiogroup.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <knuminput.h>
#include <kprinter.h>
#include <kpopupmenu.h>
#include <kstatusbar.h>

// my include files
#include "geowidget.h"
#include "mainwidget.h"
#include "geoobjects.h"
#include "metricscenter.h"
#include "point.h"
#include "mirrorpoint.h"
#include "pointonline.h"
#include "pointofconc.h"
#include "line.h"
#include "segment.h"
#include "eraser.h"
#include "colorizer.h"
#include "thicker.h"
#include "tracer.h"
#include "attacher.h"
#include "triangle.h"
#include "bisection.h"
#include "circle.h"
#include "fixedcircle.h"
#include "angle.h"
#include "distance.h"
#include "arc.h"
#include "area.h"
#include "slope.h"
#include "circumference.h"
#include "vector.h"
#include "ray.h"
#include "parallel.h"
#include "perpendicular.h"
#include "move.h"
#include "rotation.h"
#include "text.h"
#include "colorlabel.h"

#include "splashscreen.h"
#include "preferencesdialog.h"
#include "coordinatesdialog.h"
#include "diameterdialog.h"
#include "resource.h"

// system specific includes
#include <iostream.h>

/**
  * The base class for KGeo application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KGeoView creates your center view, which is connected
  * to the window's Doc object.
  * KGeoApp reimplements the methods that KTMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using KAccel.
  * @see KTMainWindow
  * @see KApplication
  * @see KConfig
  * @see KAccel
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 0.4 code generation
  */
class KGeoApp : public KMainWindow
{
  Q_OBJECT

  public:

    /** construtor of KGeoApp, calls all init functions to create the application.
     * @see initMenuBar initToolBar
     */
    KGeoApp();

    ~KGeoApp();

		/** This widget is used for drawing */
   	GeoWidget						*canvas;

  protected:

    void initMenuBar();

    /** this creates the toolbars. */
    void initToolBar();

    /** sets up the statusbar for the main window by initialzing a statuslabel.*/
    void initStatusBar();

  public slots:

    /** switch argument for slot selection by menu or toolbar ID */
		void toolBar2Clicked( int x );
    /** switch argument for slot selection by menu or toolbar ID */
    void commandCallback(int id_);
    /** open a new application window by creating a new instance of KGeoApp */
    void slotFileNewWindow();
    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** open a file and load it into the document*/
    void slotFileOpen();
    /** opens a file from the recent files menu */
    void slotFileOpenRecent(int id_);
    /** save a document */
    void slotFileSave();
    /** save a document by a new filename */
    void slotFileSaveAs();
    /** asks for saving if the file is modified, then closes the actual file and window */
    void slotFileClose();
    /** print the actual file */
    void slotFilePrint();
    /** closes all open windows by calling close() on each memberList item until the list
		 *	is empty, then quits the application.If queryClose() returns false because the
		 *	user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();
    /** put the marked text/object into the clipboard and remove
     *	it from the document
     */
    void slotEditCut();
    /** put the marked text/object into the clipboard
     */
    void slotEditCopy();
    /** paste the clipboard into the document
     */
    void slotEditPaste();
    /** shows prederences dialog
		 */
		void slotEditPreferences();
    /** toggles the toolbar
		 */
    void slotViewToolBar();
    /** toggles the statusbar
     */
    void slotViewStatusBar();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const QString &text);
    /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
     * statusbar messages that give information about actions for toolbar icons and menuentries.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusHelpMsg(const QString &text);
		/** This slot is called in order to choose the draw color. */
		void slotChooseDrawColor();
		/** This slot is called from canvas if the right mouseButton has been pressed */
		void slotMouseRightPressEvent( QPoint *pt );
		/** This slot is called from canvas if the right mouseButton has been pressed */
		void slotMouseRightPressEvent( Coordinates coords );
		/** This slot prints the mouse coordinates in the statusbar.
		 */
  	void printCoordsInStatusline( Coordinates coords );
		/** This slot prints the filename in the titlebar
		*/
  	void printFilenameInWindowTitle();
		/**	This slot saves the preferences in config file and draws everything new
				according to pref.*/
		void savePreferences();
		/**	This slot prepares the preferences window - it reads from the config file.*/
		void getPreferences();
		/** Starts Kiosk mode.*/
		void startKioskMode();
		/** Ends Kiosk mode.*/
		void endKioskMode();
		/** Changes mouse pointer if over an object that CAN BE MOVED.*/
		void changeMousePointer( Coordinates coords );
  	/**	CurrentObject is reset to 0 when mousebutton is released after moving.*/
		void releaseMouse( Coordinates coords );
		/**	This slot insert a new (empty) object other than a base point.
		 *	  The following mouse clicks on the GeoWidget will be send to this object. */
		void insertObject ( Coordinates coords );
		/**	This slot checks whether pt is really an objects and selects it for moving. CurrentObject
			  contains a pointer to that object.*/
		void selectPoint( Coordinates coords );
		/** This slot moves the currentObject.*/
		void movePoint( Coordinates coords );
		/** This slot moves all objects, so that they can reposition themselves.*/
		void move();

		void newDrawing();
		void loadDrawing( QString fileName );
		void loadObjects( KSimpleConfig *config );
		void loadMetrics( KSimpleConfig *config );
		void saveDrawing( QString fileName );
		void saveObjects( KSimpleConfig *config );
		void saveMetrics( KSimpleConfig *config );
		void setPointSize( int size );
		void setLineWidth( int width );
		void setBackgroundColor( QColor color );
		void setDrawColor( QColor color );
		void loadDrawingDialog();
		void saveDrawingDialog();
		void saveAsDrawingDialog();
		void fillRecentMenu();
		void loadRecent( int id );
		void updateRecentFiles( QString newName );
		void printDialog();
		void startSplashScreen();
		
    void keyPressEvent( QKeyEvent *ev );
		/**	Connects the signals of the left toolbar that are necessary for the move mode.*/
		void startMoveMode();

  protected:

    /** contains the recently used filenames */
    QStrList recentFiles;
    /** the configuration object of the application */
    KConfig *config;
    /** file_menu contains all items of the menubar entry "File" */
    QPopupMenu *fileMenu;
    /** the recent file menu containing the last five opened files */
    QPopupMenu *recentFilesMenu;
    /** edit_menu contains all items of the menubar entry "Edit" */
    QPopupMenu *editMenu;
    /** view_menu contains all items of the menubar entry "View" */
    QPopupMenu *viewMenu;
    /** help_menu contains all items of the menubar entry "Help" */
    KPopupMenu *helpMenu_;
    /** Kontext menu for right mouse click */
    QPopupMenu *kontextMenu;
		/** This is currently selected Object */
		GeoObjects					*currentObject;
		/**	This is currently drawn Object	*/
		GeoObjects					*newObject;
		/** List of all objects */
		QList <GeoObjects> 	objectList;
		/** In this list you can find all the arguments (GeoObjects) that have
				been passed to a newly drawn object. */
		QList <GeoObjects>	paramObjects;
		/** To be added later */
		QList <GeoObjects> 	searchObject;
		/** This is a return list for all the search method */
		QList <GeoObjects> 	returnList;
		/** This is a return that contains all objects that can be moved. */
		QList <GeoObjects> 	moveList;
		/** tells you whether changes ahve to be changes and if drawing hae been named */
		bool 								unsavedChanges, unnamedDrawing;
		/** Tells you whether Keukld is in Move object, Move grid or construction mode */
	  int 								drawingMode;
		/** Whether mouse is over a certain object */
		bool isOverObject;
		/** Contains the kiosk window. */
		QDialog							*kiosk;
		/**	Splash Screen */
		QDialog							*splash;
		/** Contains the pref window. */
		PreferencesDialog *preferencesDialog;
		/**	contains current filename */
		QString 						currentFilename;
		/**	Contains main widget */
		MainWidget *mainWidget;

    /** Does the recursive search for get methods. */
		void	getObjectsRecursion(  GeoObjects *obj, QList <GeoObjects>& list );
    /** Fills list with all child objects of obj. */
		void	getChildren( GeoObjects *obj, QList <GeoObjects>& list );
    /** Fills list with all objects that can be moved around and that lie under pt. */
		void	getAllMovableObjects( QPoint *pt, QList <GeoObjects>& list );
    /** Fills list with all objects that can be moved around and that lie under pt. */
		void	getAllMovableObjects( Coordinates & coords, QList <GeoObjects>& list );
    /** Fills list with all objects that obj would accept as parameters
				and that lie under pt. */
		void	getAllValidObjects( GeoObjects *obj, QPoint *pt, QList <GeoObjects>& list );
		/**	Creates list of objects that are in list1 but not in list2 and saves it in
				list3. */
		void	getInvertedList( 	QList <GeoObjects>& list1,
														QList <GeoObjects>& list2,
														QList <GeoObjects>& list3 );

		/**	Does what it says... */
		void deleteAllObjects();
		/**	Disconnect all signals and slots from toolbar on the left that contains
				the construction buttons.*/
		void disconnectAll();
		/**	Connects the signals of the left toolbar that are necessary for the drag mode.*/
		void startDragMode();
		/**	Connects all slots with signals necessary for construction mode.	*/
		void startConstructionMode( QString statusLine );
		/**	Connects all slots with signals necessary for move grid mode.	*/
		void startMoveGridMode();
		/**	When creating a new object, e.g. a line, you need to click to points on the
				screen. These objects will be drawn as selected. When another draw mode is
				chosen before the line has been finished, these objects need to be deselected
				and to be painted in their usual way.		*/
		void deselectParamObjects ();
		/**	This list usually contains found objects, when one of the search procedure
				are called.	*/
		GeoObjects * selectObject( QList <GeoObjects> list );

		QCursor					standardCursor;
		QCheckBox 			*box1;
		QCheckBox 			*box2;
		QCheckBox 			*box3;
		QCheckBox 			*box11;
		QCheckBox 			*box12;
		QButtonGroup 		*bg;		
		QHBoxLayout 		*GeoWidgetLayout;
		int							currentButtonID;
		int							lastButtonID;
		ColorLabel			*colorLabel;
};

#endif // KGEO_H
