/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/
/*
 *  $Revision: 1.11 $
 *
 *  Copyright (C) 2000 Mission Critical Linux, LLC
 *
 *  Author: Dave Winchell <winchell@missioncriticallinux.com>
 *  
 */

#ifndef CLU_LOCK_H
#define CLU_LOCK_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

typedef struct {
	ulong	magic_number;
        ulong   check_sum;
	int 	version;
	int 	lockData;
        ulong   holder_pc;
        pid_t   holder_pid;
} DiskLockBlock;

void clu_lock(void);

#define  LOCK_SUCCESS 0
#define  LOCK_HELD 1
#define  LOCK_FAILURE 2
#define  LOCK_NOT_HELD 4

/* clu_try_lock returns:
 *         LOCK_SUCCESS:  lock not held on entry, held on return - caller need to release
 *         LOCK_FAILURE:  lock not held on entry, lock not held on return
 */

int clu_try_lock(void);
void clu_un_lock(void);

/*  assert_clu_lock_held:
 *          faults process if cluster lock not held
 */

void assert_clu_lock_held(char *s);
int test_clu_lock_held(void);
int clu_powerCyclePartner(void);

#define SHADOW_SUCCESS 0
#define SHADOW_NO_ACCESS 1
#define SHADOW_BAD_CHECKSUM 2

/* partition values */

#define PRIMARY 0
#define SHADOW 1
#define RANDOM -1

void setPreferredReadPartition(int partition);
void flipPreferredReadPartition(void);
void clu_lock_repair(void);

/* CLU_MAX_DAEMON_PING_TIME and CLU_MAX_DAEMON_STARTUP_TIME need to be
 * greater than the lock timeouts because the lock code does not
 * do any heartbeating
 */

#define CLU_GLOBAL_LOCK_TIME_OUT_SECS 40
#define CLU_NODE_LOCK_TIME_OUT_SECS (2*CLU_GLOBAL_LOCK_TIME_OUT_SECS)
#define CLU_MAX_DAEMON_PING_TIME (3*CLU_GLOBAL_LOCK_TIME_OUT_SECS)

#define CLU_MAX_DAEMON_STARTUP_TIME (7*CLU_GLOBAL_LOCK_TIME_OUT_SECS)

int clu_clear_partner_state(void);
#endif


