/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/
/*
 * $Revision: 1.4 $
 * Copyright (C) 2000 Mission Critical Linux, LLC
 * Author: Brian Stevens <stevens@missioncriticallinux.com>
 *
 */

#ifndef __CLUCFG_H
#define __CLUCFG_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <netinet/in.h>
#include <sys/param.h>
#include <clusterdefs.h>

/*
 * Types of channels to heartbeat across
 */

#define CHAN_NET	1
#define CHAN_SERIAL	2

/*
 * Channel configuration definition
 */
typedef struct {
    int            id;
    int		   type;
    union {
	struct {
	    char   name[MAXHOSTNAMELEN];
	} serial;

	struct {
	    char   name[MAXHOSTNAMELEN];
	    char   if_name[MAXHOSTNAMELEN];
	    struct sockaddr_in	addr;
	} net;
    } dev;

} ChanCfg;


typedef struct {
    int                 id;
    int                 state;
} ChanState;


/*
 * Node configuration definition
 */

typedef struct {
    char		name[MAXHOSTNAMELEN];
    ChanCfg		*chans;
    char	  	quorumPartitionPrimary[MAXPATHLEN];
    char	  	quorumPartitionShadow[MAXPATHLEN];
    char	  	powerSerialPort[MAXPATHLEN];
    char	  	powerSwitchType[MAXHOSTNAMELEN];
} NodeCfg;

typedef struct {
    int                 id;
    int                 state;
} NodeState;
/*
 * Cluster configuration definition
 */

typedef struct {
    char		name[128];	/* define in clusterdefs.h */
    int			lid;		/* local id */
    int			num_nodes;
    int			num_chans;
    NodeCfg		*nodes;
} CluCfg;

/*
 * Library routine prototypes
 */

CluCfg *get_clu_cfg(char *);

/*
 * New API stuff
 */
CluCfg *cluGetConfig(void);

/*
 * Returns the local node id.
 */
int cluGetLocalNodeId(void);

/*
 * Delete a cluster channel, as specified by id
 */
int cluDelChan(int chan_id);

/*
 * Add a cluster channel
 */
int cluAddChan(ChanCfg *chan[MAX_NODES]);

/*
 * Modify node name
 */
int cluModifyNodeName(int node_id, char *name);

/*
 * Returns a pointer to a list of channel states
 */
ChanState *cluGetChanState(void);

#ifdef __cplusplus
}
#endif

#endif /* __CLUCFG_H */
