# $Revision: 1.8 $
#
# Kimberlite RPM spec file.
#   This was developed on RedHat 6.2.
# 
# NOTE: You must build this as the root user, and the kimberlite
#       software will be installed on the RPM Build Host.
# 
Summary: kimberlite - open source shared storage clustering for Linux
Name: kimberlite
Version: 1.1.0
Release: 1
Copyright: GPL
URL: http://oss.missioncriticallinux.com/kimberlite/
Group: Utilities
Packager: Eric Z. Ayers <eric.ayers@compgen.com>
Source: http://oss.missioncriticallinux.com/downloads/kimberlite-%{version}.tar.gz
Buildroot: /tmp/%{name}-buildroot
%description
Kimberlite is a complete framework providing high availability for application
services on Linux.  The key features of the architecture include the following:

- A complete high-availability service infrastructure prevents you from having 
  to assemble an infrastructure from disparate components.

- An extensible service-configuration framework enables you to easily
  integrate a wide variety of applications.

- An exceptional data integrity guarantee differentiates the software from
  other contemporary offerings from the Linux community.  Because of this
  guarantee, a Kimberlite cluster provides a solid foundation for
  highly-available data services, such as network-exported databases and
  NFS file systems, and is ideal as the data tier for dynamic web content.

- Services fail over automatically when problems occur, without requiring
  manual intervention by system administrators.

- A command line user interface and a web-based graphical user interface
  enable you to monitor and manage the cluster.

- A cluster utilizes commodity hardware and storage options, such as SCSI and 
  FibreChannel.

- Extensive documentation is provided, including end-user documents and design 
  specifications.

%prep
%setup -q
./configure --disable-init

%build
make clean
make

%install
rm -rf $RPM_BUILD_ROOT
make install "prefix=$RPM_BUILD_ROOT/opt/cluster" "sysconfdir=$RPM_BUILD_ROOT/etc/opt/cluster" "mandir=$RPM_BUILD_ROOT/usr/man"
install -D -m 755 init.d/cluster $RPM_BUILD_ROOT/etc/rc.d/init.d/cluster
install -D -m 755 init.d/rawio $RPM_BUILD_ROOT/etc/rc.d/init.d/rawio


%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/etc/rc.d/init.d/cluster
# NOTE: I intentionally left out rawio. see below -EZA
/opt/cluster
%doc doc

%post

sysvdir=/etc/rc.d/

cd $sysvdir
ln -sf ../init.d/cluster $sysvdir/rc1.d/K01cluster
ln -sf ../init.d/cluster $sysvdir/rc2.d/S99cluster
ln -sf ../init.d/cluster $sysvdir/rc3.d/S99cluster
ln -sf ../init.d/cluster $sysvdir/rc4.d/S99cluster
ln -sf ../init.d/cluster $sysvdir/rc5.d/S99cluster
ln -sf ../init.d/cluster $sysvdir/rc6.d/K01cluster

if [ ! -x $sysvdir/init.d/rawio ] 
then 
cat <<EOT >$sysvdir/init.d/rawio
#!/bin/bash
# rawio		Map block devices to raw character devices.
# description:  rawio mapping
# chkconfig: 345 98 01
#

# Bind raw devices to block devices.
# Tailor to match the device special files matching your disk configuration.
# Note: Must be world readable for cluster web GUI to be operational.
raw /dev/raw/raw1 /dev/sdb2
chmod a+r /dev/raw/raw1
raw /dev/raw/raw2 /dev/sdb3 
chmod a+r /dev/raw/raw2
EOT
fi

chmod 755 $sysvdir/init.d/rawio

ln -sf ../init.d/rawio $sysvdir/rc1.d/K01rawio
ln -sf ../init.d/rawio $sysvdir/rc2.d/S98rawio
ln -sf ../init.d/rawio $sysvdir/rc3.d/S98rawio
ln -sf ../init.d/rawio $sysvdir/rc4.d/S98rawio
ln -sf ../init.d/rawio $sysvdir/rc5.d/S98rawio
ln -sf ../init.d/rawio $sysvdir/rc6.d/K01rawio


cat <<EOT

Installation complete.  Now you need to configure the cluster.

You can find documentation for installation and administration
in /var/tmp/kimberlite-root/doc/cluster.html.


Remember to edit the /etc/rc.d/init.d/rawio script
to reflect the proper raw partition information for your system.

You also need to run the /var/tmp/kimberlite-root/bin/member_config
script on each cluster member.

EOT

%postun

sysvdir=/etc/rc.d/
cd $sysvdir
rm rc*.d/[SK]*rawio rc*.d/[SK]*cluster
