/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/
#ifndef _HASH_H_
#define _HASH_H_
#ifdef __cplusplus
extern "C" {
#endif

/* hash.h
   Author: Ron Lawrence <lawrence@missioncriticallinux.com>
   Version: $Revision: 1.5 $
*/

struct hash_table;

/*@null@*/
struct hash_table *hash_new(
  unsigned int (*hash_function)(void*),
  int (*same_function)(void*,void*));

void hash_destroy(
  struct hash_table *table);

void *hash_find(
  struct hash_table *table, 
  void *key);

void* hash_remove(
  struct hash_table *table, 
  void *key);

void hash_insert(
  struct hash_table *table, 
  void *key,
  void *value);

/* Pre-defined hash functions... */
unsigned int hash_string(void*);
unsigned int hash_integer(void*);

/* Pre-defined equality functions... */
int same_string(void*,void*);
int same_integer(void*,void*);

/* Return an array of char*'s that point to keys in the hash table.
   The char* array is freshly allocated using malloc, and must be
   free'd by the caller. */
char **hash_keys(struct hash_table *table, int *count);

void hash_dump(struct hash_table* table);

#ifdef __cplusplus
}
#endif
#endif

