/******************************************************************************
                                chatroom.h
                             -------------------
    begin                : Wednesday March 28 2000
    copyright            : (C) 2001 by Benjamin Meyer
    email                : ben-dev@meyerhome.net
 ******************************************************************************/

#ifndef CHATROOM_H
#define CHATROOM_H

#include "chat.h"

class ChatRoomControlImp;
class QToolButton;

/**
 * This is the implementation of a chat "room" window.  It uses the chat class.
 * @author Benjamin Meyer
 */
class ChatRoom : public Chat {

Q_OBJECT

signals:
  /// Get information on this buddy.
  void getInfo( QString contactName );

  /// We want a private chat with 'contactName'
  void im( QString contactName );

  /// Bring up a invite widget with the list of buddies. 'room' is this room.
  void showInviteWidget( int room );

public:
  /// Constructor
  ChatRoom(QString userName = "", QString roomName = "", QWidget *parent=0);

public slots:
  /// Parse in a new message.
  void messageInParse(QString buddyName, bool whisper, QString message);

  /// You were just kicked out of the room, put up a log message.
  void leftRoom();

  /// A buddy's status has changed.
  void updateBuddy( QString buddyName, bool newStatus );

private slots:
  void initChatWindow();
  /// Emit signal to save the current size.
  void saveSize();

  /// Bring up the invite dialog to invite people to the room.
  void slotBuddyInvite();

  /// Bring up the toolbar editor for it to be edited.
  void options_configuretoolbars();

private:
  /// list of buddies.
  ChatRoomControlImp* control;

  /// Invite button.
  QToolButton *userInviteButton;

  /// The splitter for the control.
  QSplitter *vSplitter;

};

#endif

// chatroom.h

